/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.blockstate.BlockStateCodecs;
import de.diddiz.LogBlock.util.ActionColor;
import de.diddiz.LogBlock.util.BukkitUtils;
import de.diddiz.LogBlock.util.MessagingUtil;
import de.diddiz.LogBlock.util.TypeColor;
import de.diddiz.LogBlock.util.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Candle;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.block.data.type.DaylightDetector;
import org.bukkit.block.data.type.Lectern;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.Switch;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.inventory.ItemStack;

public class BlockChange
implements LookupCacheElement {
    public final long id;
    public final long date;
    public final Location loc;
    public final Actor actor;
    public final String playerName;
    public final int replacedMaterial;
    public final int replacedData;
    public final int typeMaterial;
    public final int typeData;
    public final byte[] replacedState;
    public final byte[] typeState;
    public final ChestAccess ca;

    public BlockChange(long date, Location loc, Actor actor, int replaced, int replacedData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess ca) {
        this.id = 0L;
        this.date = date;
        this.loc = loc;
        this.actor = actor;
        this.replacedMaterial = replaced;
        this.replacedData = replacedData;
        this.replacedState = replacedState;
        this.typeMaterial = type;
        this.typeData = typeData;
        this.typeState = typeState;
        this.ca = ca;
        this.playerName = actor == null ? null : actor.getName();
    }

    public BlockChange(ResultSet rs, QueryParams p) throws SQLException {
        ItemStack stack;
        this.id = p.needId ? rs.getLong("id") : 0L;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.actor = p.needPlayer ? new Actor(rs) : null;
        this.playerName = p.needPlayer ? rs.getString("playername") : null;
        this.replacedMaterial = p.needType ? rs.getInt("replaced") : 0;
        this.replacedData = p.needType ? rs.getInt("replacedData") : -1;
        this.typeMaterial = p.needType ? rs.getInt("type") : 0;
        this.typeData = p.needType ? rs.getInt("typeData") : -1;
        this.replacedState = p.needType ? rs.getBytes("replacedState") : null;
        this.typeState = p.needType ? rs.getBytes("typeState") : null;
        ChestAccess catemp = null;
        if (p.needChestAccess && (stack = Utils.loadItemStack(rs.getBytes("item"))) != null) {
            catemp = new ChestAccess(stack, rs.getBoolean("itemremove"), rs.getInt("itemtype"));
        }
        this.ca = catemp;
    }

    private BaseComponent getTypeDetails(BlockData type, byte[] typeState) {
        return this.getTypeDetails(type, typeState, null, null);
    }

    private BaseComponent getTypeDetails(BlockData type, byte[] typeState, BlockData oldType, byte[] oldTypeState) {
        BaseComponent typeDetails = null;
        if (BlockStateCodecs.hasCodec(type.getMaterial())) {
            try {
                typeDetails = BlockStateCodecs.getChangesAsComponent(type.getMaterial(), Utils.deserializeYamlConfiguration(typeState), type.equals((Object)oldType) ? Utils.deserializeYamlConfiguration(oldTypeState) : null);
            }
            catch (Exception e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Could not parse BlockState for " + String.valueOf(type.getMaterial()), e);
            }
        }
        if (typeDetails == null) {
            return new TextComponent("");
        }
        TextComponent component = new TextComponent(" ");
        component.addExtra(typeDetails);
        return component;
    }

    public String toString() {
        return BaseComponent.toPlainText((BaseComponent[])this.getLogMessage(-1));
    }

    @Override
    public BaseComponent[] getLogMessage(int entry) {
        TextComponent msg = new TextComponent();
        if (this.date > 0L) {
            msg.addExtra((BaseComponent)MessagingUtil.prettyDate(this.date));
            msg.addExtra(" ");
        }
        if (this.actor != null) {
            msg.addExtra(this.actor.getName());
            msg.addExtra(" ");
        }
        BlockData type = this.getBlockSet();
        BlockData replaced = this.getBlockReplaced();
        if (type == null || replaced == null) {
            msg.addExtra("did an unknown block modification");
            return new BaseComponent[]{msg};
        }
        BaseComponent typeDetails = this.getTypeDetails(type, this.typeState, replaced, this.replacedState);
        BaseComponent replacedDetails = this.getTypeDetails(replaced, this.replacedState);
        if (type.getMaterial().equals((Object)replaced.getMaterial()) || type.getMaterial() == Material.CAKE && BukkitUtils.isCandleCake(replaced.getMaterial())) {
            if (BukkitUtils.isEmpty(type.getMaterial())) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("did an unspecified action", ActionColor.INTERACT.getColor()));
            } else if (this.ca != null) {
                if (this.ca.itemStack == null) {
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("looked inside ", ActionColor.INTERACT.getColor()));
                    msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                } else if (this.ca.remove) {
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("took ", ActionColor.DESTROY.getColor()));
                    msg.addExtra((BaseComponent)BukkitUtils.toString(this.ca.itemStack));
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(" from ", ActionColor.DESTROY.getColor()));
                    msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                } else {
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("put ", ActionColor.CREATE.getColor()));
                    msg.addExtra((BaseComponent)BukkitUtils.toString(this.ca.itemStack));
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(" into ", ActionColor.CREATE.getColor()));
                    msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                }
            } else if (type instanceof Waterlogged && ((Waterlogged)type).isWaterlogged() != ((Waterlogged)replaced).isWaterlogged()) {
                if (((Waterlogged)type).isWaterlogged()) {
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("waterlogged ", ActionColor.CREATE.getColor()));
                    msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                } else {
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("dried ", ActionColor.DESTROY.getColor()));
                    msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                }
            } else if (BukkitUtils.isContainerBlock(type.getMaterial())) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("opened ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            } else if (type instanceof Openable && ((Openable)type).isOpen() != ((Openable)replaced).isOpen()) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(((Openable)type).isOpen() ? "opened " : "closed ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            } else if (type.getMaterial() == Material.LEVER && ((Switch)type).isPowered() != ((Switch)replaced).isPowered()) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("switched ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(((Switch)type).isPowered() ? " on" : " off"));
            } else if (type instanceof Switch && ((Switch)type).isPowered() != ((Switch)replaced).isPowered()) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("pressed ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            } else if (type.getMaterial() == Material.CAKE) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("ate a piece of ", ActionColor.DESTROY.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            } else if (type.getMaterial() == Material.NOTE_BLOCK) {
                Note note = ((NoteBlock)type).getNote();
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("set ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra(" to ");
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(note.getTone().name() + (note.isSharped() ? "#" : "")));
            } else if (type.getMaterial() == Material.REPEATER) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("set ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra(" to ");
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(((Repeater)type).getDelay()));
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(" ticks delay", TypeColor.DEFAULT.getColor()));
            } else if (type.getMaterial() == Material.COMPARATOR) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("set ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra(" to ");
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(((Comparator)type).getMode()));
            } else if (type.getMaterial() == Material.DAYLIGHT_DETECTOR) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("set ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra(" to ");
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(((DaylightDetector)type).isInverted() ? "inverted" : "normal"));
            } else if (type instanceof Lectern) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("changed the book on a ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra(" to");
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(typeDetails));
            } else if (type instanceof Powerable) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("stepped on ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            } else if (type.getMaterial() == Material.TRIPWIRE) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("ran into ", ActionColor.INTERACT.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            } else if (type instanceof Sign || type instanceof WallSign) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("edited a ", ActionColor.CREATE.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(" to", ActionColor.CREATE.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(typeDetails));
            } else if (type instanceof Candle && ((Candle)type).getCandles() != ((Candle)replaced).getCandles()) {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("added a candle to ", ActionColor.CREATE.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            } else if ((type instanceof Candle || BukkitUtils.isCandleCake(type.getMaterial())) && ((Lightable)type).isLit() != ((Lightable)replaced).isLit()) {
                if (((Lightable)type).isLit()) {
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("lit a ", ActionColor.CREATE.getColor()));
                    msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                } else {
                    msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("extinguished a ", ActionColor.CREATE.getColor()));
                    msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                }
            } else {
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("replaced ", ActionColor.CREATE.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(replaced));
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(replacedDetails));
                msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(" with ", ActionColor.CREATE.getColor()));
                msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
                msg.addExtra((BaseComponent)MessagingUtil.prettyState(typeDetails));
            }
        } else if (BukkitUtils.isEmpty(type.getMaterial())) {
            msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("destroyed ", ActionColor.DESTROY.getColor()));
            msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(replaced));
            msg.addExtra((BaseComponent)MessagingUtil.prettyState(replacedDetails));
        } else if (BukkitUtils.isEmpty(replaced.getMaterial())) {
            msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("created ", ActionColor.CREATE.getColor()));
            msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            msg.addExtra((BaseComponent)MessagingUtil.prettyState(typeDetails));
        } else {
            msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor("replaced ", ActionColor.CREATE.getColor()));
            msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(replaced));
            msg.addExtra((BaseComponent)MessagingUtil.prettyState(replacedDetails));
            msg.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(" with ", ActionColor.CREATE.getColor()));
            msg.addExtra((BaseComponent)MessagingUtil.prettyMaterial(type));
            msg.addExtra((BaseComponent)MessagingUtil.prettyState(typeDetails));
        }
        if (this.loc != null) {
            msg.addExtra(" at ");
            msg.addExtra((BaseComponent)MessagingUtil.prettyLocation(this.loc, entry));
        }
        return new BaseComponent[]{msg};
    }

    public BlockData getBlockReplaced() {
        return MaterialConverter.getBlockData(this.replacedMaterial, this.replacedData);
    }

    public BlockData getBlockSet() {
        return MaterialConverter.getBlockData(this.typeMaterial, this.typeData);
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }
}

