/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.util;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Bell;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.projectiles.ProjectileSource;

public class LoggingUtil {
    public static void smartLogBlockPlace(Consumer consumer, Actor actor, BlockState replaced, BlockState placed) {
        int initialy;
        int y;
        Location loc = replaced.getLocation();
        Material placedType = placed.getType();
        if (!placedType.hasGravity() || !BukkitUtils.canDirectlyFallIn(replaced.getBlock().getRelative(BlockFace.DOWN).getType())) {
            Block above;
            Block below;
            if (placedType == Material.TWISTING_VINES && (below = placed.getBlock().getRelative(BlockFace.DOWN)).getType() == Material.TWISTING_VINES) {
                consumer.queueBlockReplace(actor, below.getState(), Material.TWISTING_VINES_PLANT.createBlockData());
            }
            if (placedType == Material.WEEPING_VINES && (above = placed.getBlock().getRelative(BlockFace.UP)).getType() == Material.WEEPING_VINES) {
                consumer.queueBlockReplace(actor, above.getState(), Material.WEEPING_VINES_PLANT.createBlockData());
            }
            if (BukkitUtils.isEmpty(replaced.getType())) {
                consumer.queueBlockPlace(actor, placed);
            } else {
                consumer.queueBlockReplace(actor, replaced, placed);
            }
            return;
        }
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        for (y = initialy = loc.getBlockY(); y > loc.getWorld().getMinHeight() && BukkitUtils.canFallIn(loc.getWorld(), x, y - 1, z); --y) {
        }
        if (initialy != y && !BukkitUtils.isEmpty(replaced.getType())) {
            consumer.queueBlockBreak(actor, replaced);
        }
        if (y > loc.getWorld().getMinHeight()) {
            Location finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
            if (y == initialy || !BukkitUtils.isFallingEntityKiller(finalLoc.getBlock().getType())) {
                if (BukkitUtils.isEmpty(finalLoc.getBlock().getType())) {
                    consumer.queueBlockPlace(actor, finalLoc, placed.getBlockData());
                } else {
                    consumer.queueBlockReplace(actor, finalLoc.getBlock().getState(), placed.getBlockData());
                }
            }
        }
    }

    public static void smartLogFallables(Consumer consumer, Actor actor, Block origin) {
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Block checkBlock = origin.getRelative(BlockFace.UP);
        int up = 0;
        int highestBlock = checkBlock.getWorld().getHighestBlockYAt(checkBlock.getLocation());
        while (checkBlock.getType().hasGravity()) {
            Location finalLoc;
            int y;
            consumer.queueBlockBreak(actor, checkBlock.getState());
            Location loc = origin.getLocation();
            int x = loc.getBlockX();
            int z = loc.getBlockZ();
            for (y = loc.getBlockY(); y > loc.getWorld().getMinHeight() && BukkitUtils.canFallIn(loc.getWorld(), x, y - 1, z); --y) {
            }
            if (y > loc.getWorld().getMinHeight() && !BukkitUtils.isFallingEntityKiller((finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z)).getBlock().getType())) {
                finalLoc.add(0.0, (double)up, 0.0);
                if (BukkitUtils.isEmpty(finalLoc.getBlock().getType())) {
                    consumer.queueBlockPlace(actor, finalLoc, checkBlock.getBlockData());
                } else {
                    consumer.queueBlockReplace(actor, finalLoc, finalLoc.getBlock().getBlockData(), checkBlock.getBlockData());
                }
                ++up;
            }
            if (checkBlock.getY() >= highestBlock) break;
            checkBlock = checkBlock.getRelative(BlockFace.UP);
        }
        if (wcfg.isLogging(Logging.SCAFFOLDING) && checkBlock.getType() == Material.SCAFFOLDING && consumer.getLogblock().getScaffoldingLogging() != null) {
            consumer.getLogblock().getScaffoldingLogging().addScaffoldingBreaker(actor, checkBlock);
        }
    }

    public static void smartLogBlockBreak(Consumer consumer, Actor actor, Block origin) {
        LoggingUtil.smartLogBlockReplace(consumer, actor, origin, null);
    }

    public static void smartLogBlockReplace(Consumer consumer, Actor actor, Block origin, BlockData replacedWith) {
        Block checkBlock;
        Material typeAbove;
        Block above;
        Block below;
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Material replacedType = origin.getType();
        if ((replacedType == Material.TWISTING_VINES || replacedType == Material.TWISTING_VINES_PLANT) && (below = origin.getRelative(BlockFace.DOWN)).getType() == Material.TWISTING_VINES_PLANT) {
            consumer.queueBlockReplace(actor, below.getState(), Material.TWISTING_VINES.createBlockData());
        }
        if ((replacedType == Material.WEEPING_VINES || replacedType == Material.WEEPING_VINES_PLANT) && (above = origin.getRelative(BlockFace.UP)).getType() == Material.WEEPING_VINES_PLANT) {
            consumer.queueBlockReplace(actor, above.getState(), Material.WEEPING_VINES.createBlockData());
        }
        if ((replacedType == Material.CAVE_VINES || replacedType == Material.CAVE_VINES_PLANT) && (above = origin.getRelative(BlockFace.UP)).getType() == Material.CAVE_VINES_PLANT) {
            consumer.queueBlockReplace(actor, above.getState(), Material.CAVE_VINES.createBlockData());
        }
        if (BukkitUtils.isRelativeTopBreakable(typeAbove = (checkBlock = origin.getRelative(BlockFace.UP)).getType())) {
            if (typeAbove == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(typeAbove)) {
                Block doorBlock = checkBlock;
                if (!BukkitUtils.isTop(doorBlock.getBlockData())) {
                    if ((doorBlock = doorBlock.getRelative(BlockFace.UP)).getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(doorBlock.getType())) {
                        consumer.queueBlockBreak(actor, doorBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else if (BukkitUtils.isDoublePlant(typeAbove)) {
                Block plantBlock = checkBlock;
                if (!BukkitUtils.isTop(plantBlock.getBlockData())) {
                    if (BukkitUtils.isDoublePlant((plantBlock = plantBlock.getRelative(BlockFace.UP)).getType())) {
                        consumer.queueBlockBreak(actor, plantBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else {
                consumer.queueBlockBreak(actor, checkBlock.getState());
                checkBlock = checkBlock.getRelative(BlockFace.UP);
                typeAbove = checkBlock.getType();
                while (BukkitUtils.isRelativeTopBreakable(typeAbove)) {
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                    checkBlock = checkBlock.getRelative(BlockFace.UP);
                    typeAbove = checkBlock.getType();
                }
            }
        } else if (typeAbove == Material.LANTERN) {
            Lantern lantern = (Lantern)checkBlock.getBlockData();
            if (!lantern.isHanging()) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        } else if (typeAbove == Material.BELL) {
            Bell bell = (Bell)checkBlock.getBlockData();
            if (bell.getAttachment() == Bell.Attachment.FLOOR) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        } else if (typeAbove == Material.POINTED_DRIPSTONE) {
            Block dripStoneBlock = checkBlock;
            while (dripStoneBlock.getType() == Material.POINTED_DRIPSTONE) {
                PointedDripstone dripstone = (PointedDripstone)dripStoneBlock.getBlockData();
                if (dripstone.getVerticalDirection() != BlockFace.UP) {
                    if (dripstone.getThickness() != PointedDripstone.Thickness.TIP_MERGE) break;
                    PointedDripstone newDripstone = (PointedDripstone)dripstone.clone();
                    newDripstone.setThickness(PointedDripstone.Thickness.TIP);
                    consumer.queueBlockReplace(actor, dripStoneBlock.getState(), (BlockData)newDripstone);
                    break;
                }
                consumer.queueBlockBreak(actor, dripStoneBlock.getState());
                dripStoneBlock = dripStoneBlock.getRelative(BlockFace.UP);
            }
        }
        checkBlock = origin.getRelative(BlockFace.DOWN);
        Material typeBelow = checkBlock.getType();
        if (typeBelow == Material.LANTERN) {
            Lantern lantern = (Lantern)checkBlock.getBlockData();
            if (lantern.isHanging()) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        } else if (BukkitUtils.isHangingSign(typeBelow)) {
            consumer.queueBlockBreak(actor, checkBlock.getState());
        } else if (typeBelow == Material.BELL) {
            Bell bell = (Bell)checkBlock.getBlockData();
            if (bell.getAttachment() == Bell.Attachment.CEILING) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        } else if (typeBelow == Material.WEEPING_VINES || typeBelow == Material.WEEPING_VINES_PLANT || typeBelow == Material.CAVE_VINES || typeBelow == Material.CAVE_VINES_PLANT) {
            consumer.queueBlockBreak(actor, checkBlock.getState());
            checkBlock = checkBlock.getRelative(BlockFace.DOWN);
            typeBelow = checkBlock.getType();
            while (typeBelow == Material.WEEPING_VINES || typeBelow == Material.WEEPING_VINES_PLANT || typeBelow == Material.CAVE_VINES || typeBelow == Material.CAVE_VINES_PLANT) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
                checkBlock = checkBlock.getRelative(BlockFace.DOWN);
                typeBelow = checkBlock.getType();
            }
        } else if (!(replacedType != Material.BIG_DRIPLEAF && replacedType != Material.BIG_DRIPLEAF_STEM || typeBelow != Material.BIG_DRIPLEAF && typeBelow != Material.BIG_DRIPLEAF_STEM)) {
            consumer.queueBlockBreak(actor, checkBlock.getState());
            checkBlock = checkBlock.getRelative(BlockFace.DOWN);
            typeBelow = checkBlock.getType();
            while (typeBelow == Material.BIG_DRIPLEAF || typeBelow == Material.BIG_DRIPLEAF_STEM) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
                checkBlock = checkBlock.getRelative(BlockFace.DOWN);
                typeBelow = checkBlock.getType();
            }
        } else if (typeBelow == Material.POINTED_DRIPSTONE) {
            Block dripStoneBlock = checkBlock;
            while (dripStoneBlock.getType() == Material.POINTED_DRIPSTONE) {
                PointedDripstone dripstone = (PointedDripstone)dripStoneBlock.getBlockData();
                if (dripstone.getVerticalDirection() != BlockFace.DOWN) {
                    if (dripstone.getThickness() != PointedDripstone.Thickness.TIP_MERGE) break;
                    PointedDripstone newDripstone = (PointedDripstone)dripstone.clone();
                    newDripstone.setThickness(PointedDripstone.Thickness.TIP);
                    consumer.queueBlockReplace(actor, dripStoneBlock.getState(), (BlockData)newDripstone);
                    break;
                }
                consumer.queueBlockBreak(actor, dripStoneBlock.getState());
                dripStoneBlock = dripStoneBlock.getRelative(BlockFace.DOWN);
            }
        }
        List<Location> relativeBreakables = BukkitUtils.getBlocksNearby(origin, BukkitUtils.getRelativeBreakables());
        if (!relativeBreakables.isEmpty()) {
            for (Location location : relativeBreakables) {
                Block block = location.getBlock();
                BlockData blockData = block.getBlockData();
                if (!(blockData instanceof Directional)) continue;
                if (blockData.getMaterial() == Material.BELL) {
                    if (((Bell)blockData).getAttachment() != Bell.Attachment.SINGLE_WALL || !block.getRelative(((Bell)blockData).getFacing()).equals(origin)) continue;
                    consumer.queueBlockBreak(actor, block.getState());
                    continue;
                }
                if (!block.getRelative(((Directional)blockData).getFacing().getOppositeFace()).equals(origin)) continue;
                consumer.queueBlockBreak(actor, block.getState());
            }
        }
        if (replacedType == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(replacedType)) {
            Block doorBlock = origin;
            doorBlock = !BukkitUtils.isTop(doorBlock.getBlockData()) ? doorBlock.getRelative(BlockFace.UP) : doorBlock.getRelative(BlockFace.DOWN);
            if (doorBlock.getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(doorBlock.getType())) {
                consumer.queueBlockBreak(actor, doorBlock.getState());
            }
        } else if (BukkitUtils.isDoublePlant(replacedType)) {
            Block plantBlock = origin;
            plantBlock = !BukkitUtils.isTop(origin.getBlockData()) ? plantBlock.getRelative(BlockFace.UP) : plantBlock.getRelative(BlockFace.DOWN);
            if (BukkitUtils.isDoublePlant(plantBlock.getType())) {
                consumer.queueBlockBreak(actor, plantBlock.getState());
            }
        }
        if (replacedWith == null) {
            consumer.queueBlockBreak(actor, origin.getState());
        } else {
            consumer.queueBlockReplace(actor, origin.getState(), replacedWith);
        }
    }

    public static String checkText(String text) {
        if (text == null) {
            return text;
        }
        if (Config.mb4) {
            return text;
        }
        return text.replaceAll("[^\\u0000-\\uFFFF]", "?");
    }

    public static Entity getRealDamager(Entity damager) {
        Entity realRemover;
        ProjectileSource realDamager;
        if (damager instanceof Projectile && (realDamager = ((Projectile)damager).getShooter()) instanceof Entity) {
            damager = (Entity)realDamager;
        }
        if (damager instanceof TNTPrimed && (realRemover = ((TNTPrimed)damager).getSource()) != null) {
            damager = realRemover;
        }
        return damager;
    }
}

