/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.questioner;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.questioner.Question;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class Questioner {
    private final LogBlock logBlock;
    private final ConcurrentHashMap<UUID, Question> questions = new ConcurrentHashMap();

    public Questioner(LogBlock logBlock) {
        this.logBlock = logBlock;
        logBlock.getServer().getPluginManager().registerEvents((Listener)new QuestionerListener(), (Plugin)logBlock);
        logBlock.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)logBlock, (Runnable)new QuestionsReaper(), 600L, 600L);
    }

    public String ask(Player respondent, String questionMessage, String ... answers) {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("This method may not be called from the primary thread");
        }
        Question question = new Question(respondent, questionMessage, answers);
        Question oldQuestion = this.questions.put(respondent.getUniqueId(), question);
        if (oldQuestion != null) {
            oldQuestion.returnAnswer("no", true);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return question.ask();
    }

    private class QuestionerListener
    implements Listener {
        private QuestionerListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
            String answer;
            UUID player = event.getPlayer().getUniqueId();
            Question question = (Question)Questioner.this.questions.get(player);
            if (question != null && question.returnAnswer(answer = event.getMessage().substring(1).toLowerCase())) {
                Questioner.this.questions.remove(player, question);
                event.setCancelled(true);
            }
        }
    }

    private class QuestionsReaper
    implements Runnable {
        private QuestionsReaper() {
        }

        @Override
        public void run() {
            if (Questioner.this.questions.isEmpty()) {
                return;
            }
            Iterator it = Questioner.this.questions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Question question = (Question)e.getValue();
                if (!question.isExpired(Questioner.this.logBlock.getServer().getPlayer((UUID)e.getKey()) == null)) continue;
                it.remove();
            }
        }
    }
}

