/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Bell;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.projectiles.ProjectileSource;

public class LoggingUtil {
    public static void smartLogBlockPlace(Consumer consumer, Actor actor, BlockState replaced, BlockState placed) {
        int initialy;
        int y;
        Location loc = replaced.getLocation();
        if (!placed.getType().hasGravity() || !BukkitUtils.canDirectlyFallIn(replaced.getBlock().getRelative(BlockFace.DOWN).getType())) {
            if (BukkitUtils.isEmpty(replaced.getType())) {
                consumer.queueBlockPlace(actor, placed);
            } else {
                consumer.queueBlockReplace(actor, replaced, placed);
            }
            return;
        }
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        for (y = initialy = loc.getBlockY(); y > 0 && BukkitUtils.canFallIn(loc.getWorld(), x, y - 1, z); --y) {
        }
        if (initialy != y && !BukkitUtils.isEmpty(replaced.getType())) {
            consumer.queueBlockBreak(actor, replaced);
        }
        if (y != 0) {
            Location finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
            if (y == initialy || !BukkitUtils.getFallingEntityKillers().contains(finalLoc.getBlock().getType())) {
                if (BukkitUtils.isEmpty(finalLoc.getBlock().getType())) {
                    consumer.queueBlockPlace(actor, finalLoc, placed.getBlockData());
                } else {
                    consumer.queueBlockReplace(actor, finalLoc.getBlock().getState(), placed.getBlockData());
                }
            }
        }
    }

    public static void smartLogFallables(Consumer consumer, Actor actor, Block origin) {
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Block checkBlock = origin.getRelative(BlockFace.UP);
        int up = 0;
        int highestBlock = checkBlock.getWorld().getHighestBlockYAt(checkBlock.getLocation());
        while (checkBlock.getType().hasGravity()) {
            int y;
            consumer.queueBlockBreak(actor, checkBlock.getState());
            Location loc = origin.getLocation();
            int x = loc.getBlockX();
            int z = loc.getBlockZ();
            for (y = loc.getBlockY(); y > 0 && BukkitUtils.canFallIn(loc.getWorld(), x, y - 1, z); --y) {
            }
            if (y != 0) {
                Location finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
                if (!BukkitUtils.getFallingEntityKillers().contains(finalLoc.getBlock().getType())) {
                    finalLoc.add(0.0, (double)up, 0.0);
                    if (BukkitUtils.isEmpty(finalLoc.getBlock().getType())) {
                        consumer.queueBlockPlace(actor, finalLoc, checkBlock.getBlockData());
                    } else {
                        consumer.queueBlockReplace(actor, finalLoc, finalLoc.getBlock().getBlockData(), checkBlock.getBlockData());
                    }
                    ++up;
                }
            }
            if (checkBlock.getY() >= highestBlock) break;
            checkBlock = checkBlock.getRelative(BlockFace.UP);
        }
        if (wcfg.isLogging(Logging.SCAFFOLDING) && checkBlock.getType() == Material.SCAFFOLDING && consumer.getLogblock().getScaffoldingLogging() != null) {
            consumer.getLogblock().getScaffoldingLogging().addScaffoldingBreaker(actor, checkBlock);
        }
    }

    public static void smartLogBlockBreak(Consumer consumer, Actor actor, Block origin) {
        LoggingUtil.smartLogBlockReplace(consumer, actor, origin, null);
    }

    public static void smartLogBlockReplace(Consumer consumer, Actor actor, Block origin, BlockData replacedWith) {
        Bell bell;
        Bell bell2;
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Block checkBlock = origin.getRelative(BlockFace.UP);
        Material typeAbove = checkBlock.getType();
        if (BukkitUtils.getRelativeTopBreakabls().contains(typeAbove)) {
            if (typeAbove == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(typeAbove)) {
                Block doorBlock = checkBlock;
                if (!BukkitUtils.isTop(doorBlock.getBlockData())) {
                    if ((doorBlock = doorBlock.getRelative(BlockFace.UP)).getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(doorBlock.getType())) {
                        consumer.queueBlockBreak(actor, doorBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else if (BukkitUtils.isDoublePlant(typeAbove)) {
                Block plantBlock = checkBlock;
                if (!BukkitUtils.isTop(plantBlock.getBlockData())) {
                    if (BukkitUtils.isDoublePlant((plantBlock = plantBlock.getRelative(BlockFace.UP)).getType())) {
                        consumer.queueBlockBreak(actor, plantBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        } else if (typeAbove == Material.LANTERN) {
            Lantern lantern = (Lantern)checkBlock.getBlockData();
            if (!lantern.isHanging()) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        } else if (typeAbove == Material.BELL && (bell2 = (Bell)checkBlock.getBlockData()).getAttachment() == Bell.Attachment.FLOOR) {
            consumer.queueBlockBreak(actor, checkBlock.getState());
        }
        checkBlock = origin.getRelative(BlockFace.DOWN);
        Material typeBelow = checkBlock.getType();
        if (typeBelow == Material.LANTERN) {
            Lantern lantern = (Lantern)checkBlock.getBlockData();
            if (lantern.isHanging()) {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        } else if (typeBelow == Material.BELL && (bell = (Bell)checkBlock.getBlockData()).getAttachment() == Bell.Attachment.CEILING) {
            consumer.queueBlockBreak(actor, checkBlock.getState());
        }
        List<Location> relativeBreakables = BukkitUtils.getBlocksNearby(origin, BukkitUtils.getRelativeBreakables());
        if (relativeBreakables.size() != 0) {
            for (Location location : relativeBreakables) {
                Block block = location.getBlock();
                BlockData blockData = block.getBlockData();
                if (!(blockData instanceof Directional)) continue;
                if (blockData.getMaterial() == Material.BELL) {
                    if (((Bell)blockData).getAttachment() != Bell.Attachment.SINGLE_WALL || !block.getRelative(((Bell)blockData).getFacing()).equals(origin)) continue;
                    consumer.queueBlockBreak(actor, block.getState());
                    continue;
                }
                if (!block.getRelative(((Directional)blockData).getFacing().getOppositeFace()).equals(origin)) continue;
                consumer.queueBlockBreak(actor, block.getState());
            }
        }
        if (origin.getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(origin.getType())) {
            Block doorBlock = origin;
            doorBlock = !BukkitUtils.isTop(doorBlock.getBlockData()) ? doorBlock.getRelative(BlockFace.UP) : doorBlock.getRelative(BlockFace.DOWN);
            if (doorBlock.getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(doorBlock.getType())) {
                consumer.queueBlockBreak(actor, doorBlock.getState());
            }
        } else if (BukkitUtils.isDoublePlant(origin.getType())) {
            Block plantBlock = origin;
            plantBlock = !BukkitUtils.isTop(origin.getBlockData()) ? plantBlock.getRelative(BlockFace.UP) : plantBlock.getRelative(BlockFace.DOWN);
            if (BukkitUtils.isDoublePlant(plantBlock.getType())) {
                consumer.queueBlockBreak(actor, plantBlock.getState());
            }
        }
        if (replacedWith == null) {
            consumer.queueBlockBreak(actor, origin.getState());
        } else {
            consumer.queueBlockReplace(actor, origin.getState(), replacedWith);
        }
    }

    public static String checkText(String text) {
        if (text == null) {
            return text;
        }
        if (Config.mb4) {
            return text;
        }
        return text.replaceAll("[^\\u0000-\\uFFFF]", "?");
    }

    public static Entity getRealDamager(Entity damager) {
        Entity realRemover;
        ProjectileSource realDamager;
        if (damager instanceof Projectile && (realDamager = ((Projectile)damager).getShooter()) instanceof Entity) {
            damager = (Entity)realDamager;
        }
        if (damager instanceof TNTPrimed && (realRemover = ((TNTPrimed)damager).getSource()) != null) {
            damager = realRemover;
        }
        return damager;
    }
}

