/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.LoggingUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;

public class BlockPlaceLogging
extends LoggingListener {
    public BlockPlaceLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (Config.isLogging(event.getBlock().getWorld(), Logging.BLOCKPLACE)) {
            BlockState before = event.getBlockReplacedState();
            BlockState after = event.getBlockPlaced().getState();
            Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
            if (before.getType() == Material.LECTERN && after.getType() == Material.LECTERN && !Config.isLogging(event.getBlock().getWorld(), Logging.LECTERNBOOKCHANGE)) {
                return;
            }
            LoggingUtil.smartLogBlockPlace(this.consumer, actor, before, after);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (Config.isLogging(event.getPlayer().getWorld(), Logging.BLOCKPLACE)) {
            Waterlogged clickedWaterlogged;
            Material placedMaterial = event.getBucket() == Material.LAVA_BUCKET ? Material.LAVA : Material.WATER;
            BlockData clickedBlockData = event.getBlockClicked().getBlockData();
            if (placedMaterial == Material.WATER && clickedBlockData instanceof Waterlogged && !(clickedWaterlogged = (Waterlogged)clickedBlockData).isWaterlogged()) {
                Waterlogged clickedWaterloggedWithWater = (Waterlogged)clickedWaterlogged.clone();
                clickedWaterloggedWithWater.setWaterlogged(true);
                this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlockClicked().getLocation(), (BlockData)clickedWaterlogged, (BlockData)clickedWaterloggedWithWater);
                return;
            }
            Block placedAt = event.getBlockClicked().getRelative(event.getBlockFace());
            if (placedAt.isEmpty()) {
                this.consumer.queueBlockPlace(Actor.actorFromEntity((Entity)event.getPlayer()), placedAt.getLocation(), placedMaterial.createBlockData());
            } else {
                this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)event.getPlayer()), placedAt.getLocation(), placedAt.getBlockData(), placedMaterial.createBlockData());
            }
        }
    }
}

