/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.worldedit;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class CuboidRegion
implements Cloneable {
    private org.bukkit.World world;
    private BlockVector min = new BlockVector();
    private BlockVector max = new BlockVector();

    public CuboidRegion(org.bukkit.World world, org.bukkit.util.Vector first, org.bukkit.util.Vector second) {
        this.world = world;
        this.min.setX(Math.min(first.getBlockX(), second.getBlockX()));
        this.min.setY(Math.min(first.getBlockY(), second.getBlockY()));
        this.min.setZ(Math.min(first.getBlockZ(), second.getBlockZ()));
        this.max.setX(Math.max(first.getBlockX(), second.getBlockX()));
        this.max.setY(Math.max(first.getBlockY(), second.getBlockY()));
        this.max.setZ(Math.max(first.getBlockZ(), second.getBlockZ()));
    }

    public static CuboidRegion fromPlayerSelection(Player player, Plugin worldEditPlugin) {
        Region selection;
        LocalSession session = ((WorldEditPlugin)worldEditPlugin).getSession(player);
        org.bukkit.World world = player.getWorld();
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        if (!weWorld.equals((Object)session.getSelectionWorld())) {
            throw new IllegalArgumentException("No selection defined");
        }
        try {
            selection = session.getSelection(weWorld);
        }
        catch (IncompleteRegionException e) {
            throw new IllegalArgumentException("No selection defined");
        }
        if (selection == null) {
            throw new IllegalArgumentException("No selection defined");
        }
        if (!(selection instanceof com.sk89q.worldedit.regions.CuboidRegion)) {
            throw new IllegalArgumentException("You have to define a cuboid selection");
        }
        Vector weMin = selection.getMinimumPoint();
        Vector weMax = selection.getMaximumPoint();
        org.bukkit.util.Vector min = new org.bukkit.util.Vector(weMin.getBlockX(), weMin.getBlockY(), weMin.getBlockZ());
        org.bukkit.util.Vector max = new org.bukkit.util.Vector(weMax.getBlockX(), weMax.getBlockY(), weMax.getBlockZ());
        return new CuboidRegion(world, min, max);
    }

    public static CuboidRegion fromCorners(org.bukkit.World world, Location first, Location second) {
        return new CuboidRegion(world, first.toVector(), second.toVector());
    }

    public org.bukkit.World getWorld() {
        return this.world;
    }

    public BlockVector getMinimumPoint() {
        return this.min;
    }

    public BlockVector getMaximumPoint() {
        return this.max;
    }

    public int getSizeX() {
        return this.max.getBlockX() - this.min.getBlockX() + 1;
    }

    public int getSizeZ() {
        return this.max.getBlockZ() - this.min.getBlockZ() + 1;
    }

    public CuboidRegion clone() {
        try {
            CuboidRegion clone = (CuboidRegion)super.clone();
            clone.min = this.min.clone();
            clone.max = this.max.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("RegionContainer should be cloneable", ex);
        }
    }
}

