/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.StructureGrowEvent;

public class StructureGrowLogging
extends LoggingListener {
    public StructureGrowLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getWorld());
        if (wcfg != null) {
            Actor actor;
            if (event.getPlayer() != null) {
                if (!wcfg.isLogging(Logging.BONEMEALSTRUCTUREGROW)) {
                    return;
                }
                actor = Actor.actorFromEntity((Entity)event.getPlayer());
            } else {
                if (!wcfg.isLogging(Logging.NATURALSTRUCTUREGROW)) {
                    return;
                }
                actor = new Actor("NaturalGrow");
            }
            for (BlockState state : event.getBlocks()) {
                this.consumer.queueBlockReplace(actor, state.getBlock().getState(), state);
            }
        }
    }
}

