/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.EntityTypeConverter;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.componentwrapper.Component;
import de.diddiz.LogBlock.componentwrapper.Components;
import de.diddiz.LogBlock.util.ActionColor;
import de.diddiz.LogBlock.util.MessagingUtil;
import de.diddiz.LogBlock.util.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class EntityChange
implements LookupCacheElement {
    public final long id;
    public final long date;
    public final Location loc;
    public final Actor actor;
    public final EntityType type;
    public final int entityId;
    public final UUID entityUUID;
    public final EntityChangeType changeType;
    public final byte[] data;

    public EntityChange(long date, Location loc, Actor actor, EntityType type, UUID entityid, EntityChangeType changeType, byte[] data) {
        this.id = 0L;
        this.date = date;
        this.loc = loc;
        this.actor = actor;
        this.type = type;
        this.entityId = -1;
        this.entityUUID = entityid;
        this.changeType = changeType;
        this.data = data;
    }

    public EntityChange(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? rs.getLong("id") : 0L;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.actor = p.needPlayer ? new Actor(rs) : null;
        this.type = p.needType ? EntityTypeConverter.getEntityType(rs.getInt("entitytypeid")) : null;
        this.entityId = p.needData ? rs.getInt("entityid") : 0;
        this.entityUUID = p.needData ? UUID.fromString(rs.getString("entityuuid")) : null;
        this.changeType = p.needType ? EntityChangeType.valueOf(rs.getInt("action")) : null;
        this.data = p.needData ? rs.getBytes("data") : null;
    }

    public String toString() {
        return Components.toPlainText(this.getLogMessage());
    }

    @Override
    public Component getLogMessage(int entry) {
        Component msg = Components.empty();
        if (this.date > 0L) {
            msg = msg.append(MessagingUtil.prettyDate(this.date));
            msg = msg.append(" ");
        }
        if (this.actor != null) {
            msg = msg.append(this.actor.getName());
            msg = msg.append(" ");
        }
        if (this.changeType == EntityChangeType.CREATE) {
            msg = msg.append(MessagingUtil.createTextComponentWithColor("created ", ActionColor.CREATE.getColor()));
        } else if (this.changeType == EntityChangeType.KILL) {
            boolean living = this.type != null && LivingEntity.class.isAssignableFrom(this.type.getEntityClass()) && !ArmorStand.class.isAssignableFrom(this.type.getDeclaringClass());
            msg = msg.append(MessagingUtil.createTextComponentWithColor(living ? "killed " : "destroyed ", ActionColor.DESTROY.getColor()));
        } else if (this.changeType == EntityChangeType.ADDEQUIP) {
            ItemStack stack;
            YamlConfiguration conf = Utils.deserializeYamlConfiguration(this.data);
            ItemStack itemStack = stack = conf == null ? null : conf.getItemStack("item");
            if (stack == null) {
                msg = msg.append(MessagingUtil.createTextComponentWithColor("added an item to ", ActionColor.CREATE.getColor()));
            } else {
                msg = msg.append(MessagingUtil.createTextComponentWithColor("added ", ActionColor.CREATE.getColor()));
                msg = msg.append(MessagingUtil.prettyMaterial(stack.getType()));
                msg = msg.append(" to ");
            }
        } else if (this.changeType == EntityChangeType.REMOVEEQUIP) {
            ItemStack stack;
            YamlConfiguration conf = Utils.deserializeYamlConfiguration(this.data);
            ItemStack itemStack = stack = conf == null ? null : conf.getItemStack("item");
            if (stack == null) {
                msg = msg.append(MessagingUtil.createTextComponentWithColor("removed an item from ", ActionColor.DESTROY.getColor()));
            } else {
                msg = msg.append(MessagingUtil.createTextComponentWithColor("removed ", ActionColor.DESTROY.getColor()));
                msg = msg.append(MessagingUtil.prettyMaterial(stack.getType()));
                msg = msg.append(" from ");
            }
        } else {
            msg = this.changeType == EntityChangeType.MODIFY ? msg.append(MessagingUtil.createTextComponentWithColor("modified ", ActionColor.INTERACT.getColor())) : (this.changeType == EntityChangeType.GET_STUNG ? msg.append(MessagingUtil.createTextComponentWithColor("got stung by ", ActionColor.DESTROY.getColor())) : msg.append(MessagingUtil.createTextComponentWithColor("did an unknown action to ", ActionColor.INTERACT.getColor())));
        }
        msg = this.type != null ? msg.append(MessagingUtil.prettyEntityType(this.type)) : msg.append(MessagingUtil.prettyMaterial("an unknown entity"));
        if (this.loc != null) {
            msg = msg.append(" at ");
            msg = msg.append(MessagingUtil.prettyLocation(this.loc, entry));
        }
        return msg;
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    public static enum EntityChangeType {
        CREATE,
        KILL,
        MODIFY,
        ADDEQUIP,
        REMOVEEQUIP,
        GET_STUNG;

        private static EntityChangeType[] values;

        public static EntityChangeType valueOf(int ordinal) {
            return values[ordinal];
        }

        static {
            values = EntityChangeType.values();
        }
    }
}

