/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChatMessage;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSign;
import de.diddiz.LogBlock.blockstate.BlockStateCodecs;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.events.BlockChangePreLogEvent;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class Consumer
extends Thread {
    private final Deque<Row> queue = new ArrayDeque<Row>();
    private final LogBlock logblock;
    private final Map<Actor, Integer> playerIds = new HashMap<Actor, Integer>();
    private final Map<Actor, Integer> uncommitedPlayerIds = new HashMap<Actor, Integer>();
    private long addEntryCounter;
    private long nextWarnCounter;
    private boolean shutdown;
    private long shutdownInitialized;

    Consumer(LogBlock logblock) {
        this.logblock = logblock;
        PlayerLeaveRow.class.getName();
        this.setName("Logblock-Consumer");
    }

    public void queueBlock(Actor actor, Location loc, BlockData typeBefore, BlockData typeAfter) {
        this.queueBlock(actor, loc, typeBefore, typeAfter, null, null, null);
    }

    public void queueBlockBreak(Actor actor, BlockState before) {
        this.queueBlock(actor, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getBlockData(), null, BlockStateCodecs.serialize(before), null, null);
    }

    public void queueBlockBreak(Actor actor, Location loc, BlockData typeBefore) {
        this.queueBlock(actor, loc, typeBefore, null);
    }

    public void queueBlockPlace(Actor actor, BlockState after) {
        this.queueBlock(actor, new Location(after.getWorld(), (double)after.getX(), (double)after.getY(), (double)after.getZ()), null, after.getBlockData(), null, BlockStateCodecs.serialize(after), null);
    }

    public void queueBlockPlace(Actor actor, Location loc, BlockData type) {
        this.queueBlock(actor, loc, null, type);
    }

    public void queueBlockReplace(Actor actor, BlockState before, BlockState after) {
        this.queueBlock(actor, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getBlockData(), after.getBlockData(), BlockStateCodecs.serialize(before), BlockStateCodecs.serialize(after), null);
    }

    public void queueBlockReplace(Actor actor, BlockState before, BlockData typeAfter) {
        this.queueBlock(actor, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getBlockData(), typeAfter, BlockStateCodecs.serialize(before), null, null);
    }

    public void queueBlockReplace(Actor actor, BlockData typeBefore, BlockState after) {
        this.queueBlock(actor, new Location(after.getWorld(), (double)after.getX(), (double)after.getY(), (double)after.getZ()), typeBefore, after.getBlockData(), null, BlockStateCodecs.serialize(after), null);
    }

    public void queueBlockReplace(Actor actor, Location loc, BlockData typeBefore, BlockData typeAfter) {
        this.queueBlock(actor, loc, typeBefore, typeAfter, null, null, null);
    }

    public void queueChestAccess(Actor actor, BlockState container, ItemStack itemStack, boolean remove) {
        if (!(container instanceof InventoryHolder)) {
            throw new IllegalArgumentException("Container must be instanceof InventoryHolder");
        }
        this.queueChestAccess(actor, new Location(container.getWorld(), (double)container.getX(), (double)container.getY(), (double)container.getZ()), container.getBlockData(), itemStack, remove);
    }

    public void queueChestAccess(Actor actor, Location loc, BlockData type, ItemStack itemStack, boolean remove) {
        this.queueBlock(actor, loc, type, type, null, null, new ChestAccess(itemStack, remove, MaterialConverter.getOrAddMaterialId(itemStack.getType().getKey())));
    }

    public void queueContainerBreak(Actor actor, BlockState container) {
        if (!(container instanceof InventoryHolder)) {
            return;
        }
        this.queueContainerBreak(actor, new Location(container.getWorld(), (double)container.getX(), (double)container.getY(), (double)container.getZ()), container.getBlockData(), ((InventoryHolder)container).getInventory());
    }

    public void queueContainerBreak(Actor actor, Location loc, BlockData type, Inventory inv) {
        ItemStack[] items;
        for (ItemStack item : items = BukkitUtils.compressInventory(inv.getContents())) {
            this.queueChestAccess(actor, loc, type, item, true);
        }
        this.queueBlockBreak(actor, loc, type);
    }

    public void queueKill(Entity killer, Entity victim) {
        if (killer == null || victim == null) {
            return;
        }
        ItemStack weapon = null;
        Actor killerActor = Actor.actorFromEntity(killer);
        if (killer instanceof Player && ((Player)killer).getInventory().getItemInMainHand() != null) {
            weapon = ((Player)killer).getInventory().getItemInMainHand();
        }
        if (killer instanceof Projectile) {
            weapon = new ItemStack(BukkitUtils.itemIDfromProjectileEntity(killer));
            ProjectileSource ps = ((Projectile)killer).getShooter();
            killerActor = ps == null ? Actor.actorFromEntity(killer) : Actor.actorFromProjectileSource(ps);
        }
        this.queueKill(victim.getLocation(), killerActor, Actor.actorFromEntity(victim), weapon);
    }

    public void queueKill(Actor killer, Entity victim) {
        if (killer == null || victim == null) {
            return;
        }
        this.queueKill(victim.getLocation(), killer, Actor.actorFromEntity(victim), null);
    }

    public void queueKill(Location location, Actor killer, Actor victim, ItemStack weapon) {
        if (victim == null || !Config.isLogged(location.getWorld())) {
            return;
        }
        this.addQueueLast(new KillRow(location, killer == null ? null : killer, victim, weapon == null ? 0 : MaterialConverter.getOrAddMaterialId(weapon.getType().getKey().toString())));
    }

    public void queueSignBreak(Actor actor, Location loc, BlockData type, YamlConfiguration typeState) {
        this.queueBlock(actor, loc, type, null, typeState, null, null);
    }

    public void queueSignBreak(Actor actor, Sign sign) {
        this.queueSignBreak(actor, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getBlockData(), BlockStateCodecs.serialize((BlockState)sign));
    }

    public void queueSignPlace(Actor actor, Location loc, BlockData type, String[] lines) {
        if (type.getMaterial() != Material.SIGN && type.getMaterial() != Material.WALL_SIGN || lines == null || lines.length != 4) {
            return;
        }
        this.queueBlock(actor, loc, type, type, null, BlockStateCodecSign.serialize(lines), null);
    }

    public void queueSignPlace(Actor actor, Sign sign) {
        this.queueSignPlace(actor, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getBlockData(), sign.getLines());
    }

    public void queueChat(Actor player, String message) {
        if (!Config.ignoredChat.isEmpty()) {
            String lowerCaseMessage = message.toLowerCase();
            for (String ignored : Config.ignoredChat) {
                if (!lowerCaseMessage.startsWith(ignored)) continue;
                return;
            }
        }
        if (Config.hiddenPlayers.contains(player.getName().toLowerCase())) {
            return;
        }
        this.addQueueLast(new ChatRow(player, message));
    }

    public void queueJoin(Player player) {
        this.addQueueLast(new PlayerJoinRow(player));
    }

    public void queueLeave(Player player, long onlineTime) {
        this.addQueueLast(new PlayerLeaveRow(player, onlineTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Deque<Row> deque = this.queue;
        synchronized (deque) {
            this.shutdown = true;
            this.shutdownInitialized = System.currentTimeMillis();
            this.queue.notifyAll();
        }
        while (this.isAlive()) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Row> currentRows = new ArrayList<Row>();
        Connection conn = null;
        BatchHelper batchHelper = new BatchHelper();
        block22: while (true) {
            try {
                while (true) {
                    Row r;
                    if (conn == null) {
                        conn = this.logblock.getConnection();
                        if (conn != null) {
                            conn.setAutoCommit(false);
                        } else {
                            boolean wantsShutdown;
                            Deque<Row> deque = this.queue;
                            synchronized (deque) {
                                wantsShutdown = this.shutdown;
                            }
                            if (wantsShutdown) break block22;
                            this.logblock.getLogger().severe("[Consumer] Could not connect to the database!");
                            try {
                                Thread.sleep(10000L);
                                continue block22;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                        }
                    }
                    boolean processBatch = false;
                    Deque<Row> deque = this.queue;
                    synchronized (deque) {
                        if (this.shutdown && (this.queue.isEmpty() || System.currentTimeMillis() - this.shutdownInitialized > 20000L)) {
                            if (currentRows.isEmpty()) {
                                break block22;
                            }
                            processBatch = true;
                        }
                        if ((r = this.queue.pollFirst()) == null) {
                            try {
                                if (currentRows.isEmpty() && !this.shutdown) {
                                    this.queue.wait();
                                } else {
                                    processBatch = true;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (r != null) {
                        boolean failOnActors = false;
                        for (Actor actor : r.getActors()) {
                            if (this.playerIDAsIntIncludeUncommited(actor) != null || this.addPlayer(conn, actor)) continue;
                            this.logblock.getLogger().warning("[Consumer] Failed to add player " + actor.getName());
                            failOnActors = true;
                        }
                        if (!failOnActors) {
                            currentRows.add(r);
                            r.process(conn, batchHelper);
                        }
                    }
                    if (currentRows.size() < (processBatch ? 1 : Config.forceToProcessAtLeast * 10)) continue;
                    batchHelper.processStatements(conn);
                    conn.commit();
                    currentRows.clear();
                    this.playerIds.putAll(this.uncommitedPlayerIds);
                    this.uncommitedPlayerIds.clear();
                }
            }
            catch (Exception e) {
                this.logblock.getLogger().log(Level.SEVERE, "[Consumer] Could not insert entries!", e);
                boolean retry = false;
                if (e instanceof SQLException) {
                    String state = ((SQLException)e).getSQLState();
                    boolean bl = retry = state != null && (state.equals("08S01") || state.equals("08001") || state.equals("08004") || state.equals("HY000") || state.equals("40001"));
                }
                if (retry) {
                    Deque<Row> deque = this.queue;
                    synchronized (deque) {
                        while (!currentRows.isEmpty()) {
                            this.queue.addFirst((Row)currentRows.remove(currentRows.size() - 1));
                        }
                    }
                }
                currentRows.clear();
                batchHelper.reset();
                this.uncommitedPlayerIds.clear();
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                conn = null;
                continue;
            }
            break;
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        Deque<Row> deque = this.queue;
        synchronized (deque) {
            while (!currentRows.isEmpty()) {
                this.queue.addFirst((Row)currentRows.remove(currentRows.size() - 1));
            }
        }
    }

    public void writeToFile() throws FileNotFoundException {
        long time = System.currentTimeMillis();
        HashSet<Actor> insertedPlayers = new HashSet<Actor>();
        int counter = 0;
        new File("plugins/LogBlock/import/").mkdirs();
        PrintWriter writer = new PrintWriter(new File("plugins/LogBlock/import/queue-" + time + "-0.sql"));
        while (!this.isQueueEmpty()) {
            Row r = this.pollQueueFirst();
            if (r == null) continue;
            for (Actor actor : r.getActors()) {
                if (this.playerIds.containsKey(actor) || insertedPlayers.contains(actor)) continue;
                writer.println("INSERT IGNORE INTO `lb-players` (playername,UUID) SELECT '" + Utils.mysqlTextEscape(actor.getName()) + "','" + Utils.mysqlTextEscape(actor.getUUID()) + "' FROM `lb-players` WHERE NOT EXISTS (SELECT NULL FROM `lb-players` WHERE UUID = '" + Utils.mysqlTextEscape(actor.getUUID()) + "') LIMIT 1;");
                insertedPlayers.add(actor);
            }
            for (String insert : r.getInserts()) {
                writer.println(insert);
            }
            if (++counter % 1000 != 0) continue;
            writer.close();
            writer = new PrintWriter(new File("plugins/LogBlock/import/queue-" + time + "-" + counter / 1000 + ".sql"));
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getQueueSize() {
        Deque<Row> deque = this.queue;
        synchronized (deque) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isQueueEmpty() {
        Deque<Row> deque = this.queue;
        synchronized (deque) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueueLast(Row row) {
        Deque<Row> deque = this.queue;
        synchronized (deque) {
            boolean wasEmpty = this.queue.isEmpty();
            this.queue.addLast(row);
            ++this.addEntryCounter;
            if (Config.queueWarningSize > 0 && this.queue.size() >= Config.queueWarningSize && this.addEntryCounter >= this.nextWarnCounter) {
                this.logblock.getLogger().warning("[Consumer] Queue overloaded. Size: " + this.queue.size());
                this.nextWarnCounter = this.addEntryCounter + 1000L;
            }
            if (wasEmpty) {
                this.queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row pollQueueFirst() {
        Deque<Row> deque = this.queue;
        synchronized (deque) {
            return this.queue.pollFirst();
        }
    }

    static void hide(Player player) {
        Config.hiddenPlayers.add(player.getName().toLowerCase());
    }

    static void unHide(Player player) {
        Config.hiddenPlayers.remove(player.getName().toLowerCase());
    }

    static boolean toggleHide(Player player) {
        String playerName = player.getName().toLowerCase();
        if (Config.hiddenPlayers.contains(playerName)) {
            Config.hiddenPlayers.remove(playerName);
            return false;
        }
        Config.hiddenPlayers.add(playerName);
        return true;
    }

    private boolean addPlayer(Connection conn, Actor actor) throws SQLException {
        String name = actor.getName();
        String uuid = actor.getUUID();
        Statement state = conn.createStatement();
        state.execute("INSERT IGNORE INTO `lb-players` (playername,UUID) SELECT '" + Utils.mysqlTextEscape(name) + "','" + Utils.mysqlTextEscape(uuid) + "' FROM `lb-players` WHERE NOT EXISTS (SELECT NULL FROM `lb-players` WHERE UUID = '" + Utils.mysqlTextEscape(uuid) + "') LIMIT 1;");
        ResultSet rs = state.executeQuery("SELECT playerid FROM `lb-players` WHERE UUID = '" + Utils.mysqlTextEscape(uuid) + "'");
        if (rs.next()) {
            this.uncommitedPlayerIds.put(actor, rs.getInt(1));
        }
        rs.close();
        state.close();
        return this.uncommitedPlayerIds.containsKey(actor);
    }

    private void queueBlock(Actor actor, Location loc, BlockData typeBefore, BlockData typeAfter, YamlConfiguration stateBefore, YamlConfiguration stateAfter, ChestAccess ca) {
        if (typeBefore == null || typeBefore.getMaterial() == Material.CAVE_AIR || typeBefore.getMaterial() == Material.VOID_AIR) {
            typeBefore = Bukkit.createBlockData((Material)Material.AIR);
        }
        if (typeAfter == null || typeAfter.getMaterial() == Material.CAVE_AIR || typeAfter.getMaterial() == Material.VOID_AIR) {
            typeAfter = Bukkit.createBlockData((Material)Material.AIR);
        }
        if (Config.fireCustomEvents) {
            BlockChangePreLogEvent event = new BlockChangePreLogEvent(actor, loc, typeBefore, typeAfter, stateBefore, stateAfter, ca);
            this.logblock.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            actor = event.getOwnerActor();
            loc = event.getLocation();
            typeBefore = event.getTypeBefore();
            typeAfter = event.getTypeAfter();
            stateBefore = event.getStateBefore();
            stateAfter = event.getStateAfter();
            ca = event.getChestAccess();
        }
        if (actor == null || loc == null || typeBefore == null || typeAfter == null || Config.hiddenPlayers.contains(actor.getName().toLowerCase()) || !Config.isLogged(loc.getWorld()) || typeBefore != typeAfter && Config.hiddenBlocks.contains(typeBefore.getMaterial()) && Config.hiddenBlocks.contains(typeAfter.getMaterial())) {
            return;
        }
        String replacedString = typeBefore.getAsString();
        int replacedMaterialId = MaterialConverter.getOrAddMaterialId(replacedString);
        int replacedStateId = MaterialConverter.getOrAddBlockStateId(replacedString);
        String typeString = typeAfter.getAsString();
        int typeMaterialId = MaterialConverter.getOrAddMaterialId(typeString);
        int typeStateId = MaterialConverter.getOrAddBlockStateId(typeString);
        this.addQueueLast(new BlockRow(loc, actor, replacedMaterialId, replacedStateId, Utils.serializeYamlConfiguration(stateBefore), typeMaterialId, typeStateId, Utils.serializeYamlConfiguration(stateAfter), ca));
    }

    private String playerID(Actor actor) {
        if (actor == null) {
            return "NULL";
        }
        Integer id = this.playerIds.get(actor);
        if (id != null) {
            return id.toString();
        }
        return "(SELECT playerid FROM `lb-players` WHERE UUID = '" + Utils.mysqlTextEscape(actor.getUUID()) + "')";
    }

    private Integer playerIDAsIntIncludeUncommited(Actor actor) {
        if (actor == null) {
            return null;
        }
        Integer id = this.playerIds.get(actor);
        if (id != null) {
            return id;
        }
        return this.uncommitedPlayerIds.get(actor);
    }

    private int safeY(Location loc) {
        int safeY = loc.getBlockY();
        if (safeY < 0) {
            safeY = 0;
        }
        if (safeY > 65535) {
            safeY = 65535;
        }
        return safeY;
    }

    protected static interface IntCallback {
        public void call(int var1) throws SQLException;
    }

    private class BatchHelper {
        private HashMap<String, PreparedStatement> preparedStatements = new HashMap();
        private HashSet<PreparedStatement> preparedStatementsWithGeneratedKeys = new HashSet();
        private LinkedHashMap<PreparedStatement, ArrayList<IntCallback>> generatedKeyHandler = new LinkedHashMap();
        private HashMap<Location, Integer> uncommitedBlockActors = new HashMap();

        private BatchHelper() {
        }

        public void reset() {
            this.preparedStatements.clear();
            this.preparedStatementsWithGeneratedKeys.clear();
            this.generatedKeyHandler.clear();
            this.uncommitedBlockActors.clear();
        }

        public void addUncommitedBlockActorId(Location loc, int actorId) {
            this.uncommitedBlockActors.put(loc, actorId);
        }

        public Integer getUncommitedBlockActor(Location loc) {
            return this.uncommitedBlockActors.get(loc);
        }

        public void processStatements(Connection conn) throws SQLException {
            while (!this.generatedKeyHandler.isEmpty()) {
                Map.Entry<PreparedStatement, ArrayList<IntCallback>> entry = this.generatedKeyHandler.entrySet().iterator().next();
                PreparedStatement smt = entry.getKey();
                ArrayList<IntCallback> callbackList = entry.getValue();
                this.generatedKeyHandler.remove(smt);
                smt.executeBatch();
                if (!this.preparedStatementsWithGeneratedKeys.contains(smt)) continue;
                ResultSet keys = smt.getGeneratedKeys();
                int[] results = new int[callbackList.size()];
                int pos = 0;
                while (keys.next() && pos < results.length) {
                    results[pos++] = keys.getInt(1);
                }
                keys.close();
                for (int i = 0; i < results.length; ++i) {
                    IntCallback callback = callbackList.get(i);
                    if (callback == null) continue;
                    callback.call(results[i]);
                }
            }
            this.uncommitedBlockActors.clear();
        }

        public PreparedStatement getOrPrepareStatement(Connection conn, String sql, int autoGeneratedKeys) throws SQLException {
            PreparedStatement smt = this.preparedStatements.get(sql);
            if (smt == null) {
                smt = conn.prepareStatement(sql, autoGeneratedKeys);
                this.preparedStatements.put(sql, smt);
                if (autoGeneratedKeys == 1) {
                    this.preparedStatementsWithGeneratedKeys.add(smt);
                }
            }
            return smt;
        }

        public void addBatch(PreparedStatement smt, IntCallback generatedKeysCallback) throws SQLException {
            smt.addBatch();
            ArrayList<IntCallback> callbackList = this.generatedKeyHandler.get(smt);
            if (callbackList == null) {
                callbackList = new ArrayList();
                this.generatedKeyHandler.put(smt, callbackList);
            }
            callbackList.add(generatedKeysCallback);
        }
    }

    private class PlayerLeaveRow
    implements Row {
        private final long onlineTime;
        private final Actor actor;
        private String statementString;

        PlayerLeaveRow(Player player, long onlineTime) {
            this.onlineTime = onlineTime;
            this.actor = Actor.actorFromEntity((Entity)player);
            this.statementString = "UPDATE `lb-players` SET onlinetime = onlinetime + ? WHERE lastlogin > 0 && UUID = ?";
        }

        @Override
        public String[] getInserts() {
            if (Config.logPlayerInfo) {
                return new String[]{"UPDATE `lb-players` SET onlinetime = onlinetime + " + this.onlineTime + " WHERE lastlogin > 0 && UUID = '" + Utils.mysqlTextEscape(this.actor.getUUID()) + "';"};
            }
            return new String[0];
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.actor};
        }

        @Override
        public void process(Connection conn, BatchHelper batchHelper) throws SQLException {
            PreparedStatement smt = batchHelper.getOrPrepareStatement(conn, this.statementString, 2);
            smt.setLong(1, this.onlineTime);
            smt.setString(2, this.actor.getUUID());
            batchHelper.addBatch(smt, null);
        }
    }

    private class PlayerJoinRow
    implements Row {
        private final Actor player;
        private final long lastLogin;
        private final String ip;
        private String statementString;

        PlayerJoinRow(Player player) {
            this.player = Actor.actorFromEntity((Entity)player);
            this.lastLogin = System.currentTimeMillis() / 1000L;
            this.ip = player.getAddress().toString().replace("'", "\\'");
            this.statementString = Config.logPlayerInfo ? "UPDATE `lb-players` SET lastlogin = FROM_UNIXTIME(?), firstlogin = IF(firstlogin = 0, FROM_UNIXTIME(?), firstlogin), ip = ?, playername = ? WHERE UUID = ?" : "UPDATE `lb-players` SET playername = ? WHERE UUID = ?";
        }

        @Override
        public String[] getInserts() {
            if (Config.logPlayerInfo) {
                return new String[]{"UPDATE `lb-players` SET lastlogin = FROM_UNIXTIME(" + this.lastLogin + "), firstlogin = IF(firstlogin = 0, FROM_UNIXTIME(" + this.lastLogin + "), firstlogin), ip = '" + this.ip + "', playername = '" + Utils.mysqlTextEscape(this.player.getName()) + "' WHERE UUID = '" + this.player.getUUID() + "';"};
            }
            return new String[]{"UPDATE `lb-players` SET playername = '" + Utils.mysqlTextEscape(this.player.getName()) + "' WHERE UUID = '" + Utils.mysqlTextEscape(this.player.getUUID()) + "';"};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.player};
        }

        @Override
        public void process(Connection conn, BatchHelper batchHelper) throws SQLException {
            PreparedStatement smt = batchHelper.getOrPrepareStatement(conn, this.statementString, 2);
            if (Config.logPlayerInfo) {
                smt.setLong(1, this.lastLogin);
                smt.setLong(2, this.lastLogin);
                smt.setString(3, this.ip);
                smt.setString(4, this.player.getName());
                smt.setString(5, this.player.getUUID());
            } else {
                smt.setString(1, this.player.getName());
                smt.setString(2, this.player.getUUID());
            }
            batchHelper.addBatch(smt, null);
        }
    }

    private class ChatRow
    extends ChatMessage
    implements Row {
        private String statementString;

        ChatRow(Actor player, String message) {
            super(player, message);
            this.statementString = "INSERT INTO `lb-chat` (date, playerid, message) VALUES (FROM_UNIXTIME(?), ?, ?)";
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `lb-chat` (date, playerid, message) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.player) + ", '" + Utils.mysqlTextEscape(this.message) + "');"};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.player};
        }

        @Override
        public void process(Connection conn, BatchHelper batchHelper) throws SQLException {
            PreparedStatement smt = batchHelper.getOrPrepareStatement(conn, this.statementString, 2);
            smt.setLong(1, this.date);
            smt.setInt(2, Consumer.this.playerIDAsIntIncludeUncommited(this.player));
            smt.setString(3, this.message);
            batchHelper.addBatch(smt, null);
        }
    }

    private class KillRow
    implements Row {
        final long date = System.currentTimeMillis() / 1000L;
        final Actor killer;
        final Actor victim;
        final int weapon;
        final Location loc;
        final String statementString;

        KillRow(Location loc, Actor attacker, Actor defender, int weapon) {
            this.loc = loc;
            this.killer = attacker;
            this.victim = defender;
            this.weapon = weapon;
            this.statementString = "INSERT INTO `" + Config.getWorldConfig((World)loc.getWorld()).table + "-kills` (date, killer, victim, weapon, x, y, z) VALUES (FROM_UNIXTIME(?), ?, ?, ?, ?, ?, ?)";
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `" + Config.getWorldConfig((World)this.loc.getWorld()).table + "-kills` (date, killer, victim, weapon, x, y, z) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.killer) + ", " + Consumer.this.playerID(this.victim) + ", " + this.weapon + ", " + this.loc.getBlockX() + ", " + Consumer.this.safeY(this.loc) + ", " + this.loc.getBlockZ() + ");"};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.killer, this.victim};
        }

        @Override
        public void process(Connection conn, BatchHelper batchHelper) throws SQLException {
            PreparedStatement smt = batchHelper.getOrPrepareStatement(conn, this.statementString, 2);
            smt.setLong(1, this.date);
            smt.setInt(2, Consumer.this.playerIDAsIntIncludeUncommited(this.killer));
            smt.setInt(3, Consumer.this.playerIDAsIntIncludeUncommited(this.victim));
            smt.setInt(4, this.weapon);
            smt.setInt(5, this.loc.getBlockX());
            smt.setInt(6, Consumer.this.safeY(this.loc));
            smt.setInt(7, this.loc.getBlockZ());
            batchHelper.addBatch(smt, null);
        }
    }

    private class BlockRow
    extends BlockChange
    implements Row {
        final String statementString;
        final String selectActorIdStatementString;

        public BlockRow(Location loc, Actor actor, int replaced, int replacedData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess ca) {
            super(System.currentTimeMillis() / 1000L, loc, actor, replaced, replacedData, replacedState, type, typeData, typeState, ca);
            this.statementString = Config.getWorldConfig((World)loc.getWorld()).insertBlockStatementString;
            this.selectActorIdStatementString = Config.getWorldConfig((World)loc.getWorld()).selectBlockActorIdStatementString;
        }

        @Override
        public String[] getInserts() {
            String table = Config.getWorldConfig((World)this.loc.getWorld()).table;
            String[] inserts = new String[this.ca != null || this.replacedState != null || this.typeState != null ? 2 : 1];
            inserts[0] = "INSERT INTO `" + table + "-blocks` (date, playerid, replaced, replaceddata, type, typedata, x, y, z) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.actor) + ", " + this.replacedMaterial + ", " + this.replacedData + ", " + this.typeMaterial + ", " + this.typeData + ", '" + this.loc.getBlockX() + "', " + Consumer.this.safeY(this.loc) + ", '" + this.loc.getBlockZ() + "');";
            if (this.replacedState != null || this.typeState != null) {
                inserts[1] = "INSERT INTO `" + table + "-state` (replacedState, typeState, id) VALUES(" + Utils.mysqlPrepareBytesForInsertAllowNull(this.replacedState) + ", " + Utils.mysqlPrepareBytesForInsertAllowNull(this.typeState) + ", LAST_INSERT_ID());";
            } else if (this.ca != null) {
                inserts[1] = "INSERT INTO `" + table + "-chestdata` (id, item, itemremove, itemtype) values (LAST_INSERT_ID(), '" + Utils.mysqlEscapeBytes(Utils.saveItemStack(this.ca.itemStack)) + "', " + (this.ca.remove ? 1 : 0) + ", " + this.ca.itemType + ");";
            }
            return inserts;
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.actor};
        }

        @Override
        public void process(final Connection conn, final BatchHelper batchHelper) throws SQLException {
            int sourceActor = Consumer.this.playerIDAsIntIncludeUncommited(this.actor);
            Location actorBlockLocation = this.actor.getBlockLocation();
            if (actorBlockLocation != null) {
                Integer tempSourceActor = batchHelper.getUncommitedBlockActor(actorBlockLocation);
                if (tempSourceActor != null) {
                    sourceActor = tempSourceActor;
                } else {
                    PreparedStatement smt = batchHelper.getOrPrepareStatement(conn, this.selectActorIdStatementString, 2);
                    smt.setInt(1, actorBlockLocation.getBlockX());
                    smt.setInt(2, Consumer.this.safeY(actorBlockLocation));
                    smt.setInt(3, actorBlockLocation.getBlockZ());
                    ResultSet rs = smt.executeQuery();
                    if (rs.next()) {
                        sourceActor = rs.getInt(1);
                    }
                    rs.close();
                }
            }
            PreparedStatement smt = batchHelper.getOrPrepareStatement(conn, this.statementString, 1);
            smt.setLong(1, this.date);
            smt.setInt(2, sourceActor);
            smt.setInt(3, this.replacedMaterial);
            smt.setInt(4, this.replacedData);
            smt.setInt(5, this.typeMaterial);
            smt.setInt(6, this.typeData);
            smt.setInt(7, this.loc.getBlockX());
            smt.setInt(8, Consumer.this.safeY(this.loc));
            smt.setInt(9, this.loc.getBlockZ());
            batchHelper.addUncommitedBlockActorId(this.loc, sourceActor);
            batchHelper.addBatch(smt, new IntCallback(){

                @Override
                public void call(int id) throws SQLException {
                    PreparedStatement ps;
                    if (BlockRow.this.typeState != null || BlockRow.this.replacedState != null) {
                        ps = batchHelper.getOrPrepareStatement(conn, Config.getWorldConfig((World)BlockRow.this.loc.getWorld()).insertBlockStateStatementString, 2);
                        ps.setBytes(1, BlockRow.this.replacedState);
                        ps.setBytes(2, BlockRow.this.typeState);
                        ps.setInt(3, id);
                        batchHelper.addBatch(ps, null);
                    }
                    if (BlockRow.this.ca != null) {
                        ps = batchHelper.getOrPrepareStatement(conn, Config.getWorldConfig((World)BlockRow.this.loc.getWorld()).insertBlockChestDataStatementString, 2);
                        ps.setBytes(1, Utils.saveItemStack(BlockRow.this.ca.itemStack));
                        ps.setInt(2, BlockRow.this.ca.remove ? 1 : 0);
                        ps.setInt(3, id);
                        ps.setInt(4, BlockRow.this.ca.itemType);
                        batchHelper.addBatch(ps, null);
                    }
                }
            });
        }
    }

    private static interface Row {
        public String[] getInserts();

        public void process(Connection var1, BatchHelper var2) throws SQLException;

        public Actor[] getActors();
    }
}

