/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import java.util.Objects;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.SignChangeEvent;

public class SignChangeLogging
extends LoggingListener {
    public SignChangeLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        BlockState newState;
        if (Config.isLogging(event.getBlock().getWorld(), Logging.SIGNTEXT) && (newState = event.getBlock().getState()) instanceof Sign) {
            Sign sign = (Sign)newState;
            SignSide signSide = sign.getSide(event.getSide());
            boolean changed = false;
            for (int i = 0; i < 4; ++i) {
                if (Objects.equals(signSide.getLine(i), event.getLine(i))) continue;
                signSide.setLine(i, event.getLine(i));
                changed = true;
            }
            if (changed) {
                this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlock().getState(), newState);
            }
        }
    }
}

