/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.util.UUID;
import org.bukkit.DyeColor;
import org.bukkit.GameEvent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.type.Cake;
import org.bukkit.block.data.type.Candle;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.block.data.type.DaylightDetector;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.block.data.type.Switch;
import org.bukkit.block.data.type.TurtleEgg;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.inventory.ItemStack;

public class InteractLogging
extends LoggingListener {
    private UUID lastInteractionPlayer;
    private BlockData lastInteractionBlockData;
    private Location lastInteractionLocation;

    public InteractLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getPlayer().getWorld());
        if (wcfg != null) {
            ItemStack inHand;
            Block clicked = event.getClickedBlock();
            if (clicked == null) {
                return;
            }
            BlockData blockData = clicked.getBlockData();
            Material type = blockData.getMaterial();
            Player player = event.getPlayer();
            Location loc = clicked.getLocation();
            this.lastInteractionPlayer = player.getUniqueId();
            this.lastInteractionBlockData = blockData;
            this.lastInteractionLocation = loc;
            if (BukkitUtils.isFenceGate(type) || BukkitUtils.isWoodenTrapdoor(type)) {
                if (wcfg.isLogging(Logging.DOORINTERACT) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    Openable newBlockData;
                    newBlockData.setOpen(!(newBlockData = (Openable)blockData.clone()).isOpen());
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                }
            } else if (BukkitUtils.isPressurePlate(type)) {
                if (wcfg.isLogging(Logging.PRESUREPLATEINTERACT) && event.getAction() == Action.PHYSICAL) {
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, blockData);
                }
            } else if (BukkitUtils.isWoodenDoor(type)) {
                if (wcfg.isLogging(Logging.DOORINTERACT) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    Door newBlockData;
                    newBlockData.setOpen(!(newBlockData = (Door)blockData.clone()).isOpen());
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                }
            } else if (BukkitUtils.isButton(type) || type == Material.LEVER) {
                if (wcfg.isLogging(Logging.SWITCHINTERACT) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    Switch newBlockData = (Switch)blockData.clone();
                    if (!newBlockData.isPowered() || type == Material.LEVER) {
                        newBlockData.setPowered(!newBlockData.isPowered());
                    }
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                }
            } else if (BukkitUtils.isSign(type)) {
                Sign signBefore;
                BlockState before;
                Material itemType;
                if (wcfg.isLogging(Logging.SIGNTEXT) && event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getItem() != null && (BukkitUtils.isDye(itemType = event.getItem().getType()) || itemType == Material.GLOW_INK_SAC || itemType == Material.INK_SAC || itemType == Material.HONEYCOMB) && (before = event.getClickedBlock().getState()) instanceof Sign && !(signBefore = (Sign)before).isWaxed()) {
                    DyeColor newColor;
                    Sign signAfter = (Sign)event.getClickedBlock().getState();
                    Side side = BukkitUtils.getFacingSignSide((Entity)player, clicked);
                    SignSide signSideBefore = signBefore.getSide(side);
                    SignSide signSideAfter = signAfter.getSide(side);
                    if (itemType == Material.GLOW_INK_SAC) {
                        if (!signSideBefore.isGlowingText() && this.hasText(signSideBefore)) {
                            signSideAfter.setGlowingText(true);
                            this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)player), (BlockState)signBefore, (BlockState)signAfter);
                        }
                    } else if (itemType == Material.INK_SAC) {
                        if (signSideBefore.isGlowingText() && this.hasText(signSideBefore)) {
                            signSideAfter.setGlowingText(false);
                            this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)player), (BlockState)signBefore, (BlockState)signAfter);
                        }
                    } else if (itemType == Material.HONEYCOMB) {
                        signAfter.setWaxed(true);
                        this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)player), (BlockState)signBefore, (BlockState)signAfter);
                    } else if (BukkitUtils.isDye(itemType) && this.hasText(signSideBefore) && (newColor = BukkitUtils.dyeToDyeColor(itemType)) != null && signSideBefore.getColor() != newColor) {
                        signSideAfter.setColor(newColor);
                        this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)player), (BlockState)signBefore, (BlockState)signAfter);
                    }
                }
            } else if (type == Material.CAKE) {
                if (event.hasItem() && BukkitUtils.isCandle(event.getItem().getType()) && event.useItemInHand() != Event.Result.DENY) {
                    BlockData newBlockData = Material.valueOf((String)(event.getItem().getType().name() + "_CAKE")).createBlockData();
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, newBlockData);
                } else if (wcfg.isLogging(Logging.CAKEEAT) && event.getAction() == Action.RIGHT_CLICK_BLOCK && player.getFoodLevel() < 20) {
                    Cake newBlockData = (Cake)blockData.clone();
                    if (newBlockData.getBites() < 6) {
                        newBlockData.setBites(newBlockData.getBites() + 1);
                        this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                    } else {
                        this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, Material.AIR.createBlockData());
                    }
                }
            } else if (type == Material.NOTE_BLOCK) {
                if (wcfg.isLogging(Logging.NOTEBLOCKINTERACT) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    NoteBlock newBlockData = (NoteBlock)blockData.clone();
                    if (newBlockData.getNote().getOctave() == 2) {
                        newBlockData.setNote(new Note(0, Note.Tone.F, true));
                    } else {
                        newBlockData.setNote(newBlockData.getNote().sharped());
                    }
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                }
            } else if (type == Material.REPEATER) {
                if (wcfg.isLogging(Logging.DIODEINTERACT) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    Repeater newBlockData = (Repeater)blockData.clone();
                    newBlockData.setDelay(newBlockData.getDelay() % 4 + 1);
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                }
            } else if (type == Material.COMPARATOR) {
                if (wcfg.isLogging(Logging.COMPARATORINTERACT) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    Comparator newBlockData;
                    newBlockData.setMode((newBlockData = (Comparator)blockData.clone()).getMode() == Comparator.Mode.COMPARE ? Comparator.Mode.SUBTRACT : Comparator.Mode.COMPARE);
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                }
            } else if (type == Material.DAYLIGHT_DETECTOR) {
                if (wcfg.isLogging(Logging.DAYLIGHTDETECTORINTERACT) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    DaylightDetector newBlockData;
                    newBlockData.setInverted(!(newBlockData = (DaylightDetector)blockData.clone()).isInverted());
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
                }
            } else if (type == Material.TRIPWIRE) {
                if (wcfg.isLogging(Logging.TRIPWIREINTERACT) && event.getAction() == Action.PHYSICAL) {
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, blockData);
                }
            } else if (type == Material.FARMLAND) {
                if (wcfg.isLogging(Logging.CROPTRAMPLE) && event.getAction() == Action.PHYSICAL) {
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, Material.DIRT.createBlockData());
                    Block trampledCrop = clicked.getRelative(BlockFace.UP);
                    if (BukkitUtils.isCropBlock(trampledCrop.getType())) {
                        this.consumer.queueBlockBreak(Actor.actorFromEntity((Entity)player), trampledCrop.getState());
                    }
                }
            } else if (type == Material.TURTLE_EGG) {
                if (wcfg.isLogging(Logging.BLOCKBREAK) && event.getAction() == Action.PHYSICAL) {
                    TurtleEgg turtleEggData = (TurtleEgg)blockData;
                    int eggs = turtleEggData.getEggs();
                    if (eggs > 1) {
                        TurtleEgg turtleEggData2 = (TurtleEgg)turtleEggData.clone();
                        turtleEggData2.setEggs(eggs - 1);
                        this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, (BlockData)turtleEggData, (BlockData)turtleEggData2);
                    } else {
                        this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, (BlockData)turtleEggData, Material.AIR.createBlockData());
                    }
                }
            } else if (type == Material.PUMPKIN && (wcfg.isLogging(Logging.BLOCKBREAK) || wcfg.isLogging(Logging.BLOCKPLACE)) && event.getAction() == Action.RIGHT_CLICK_BLOCK && (inHand = event.getItem()) != null && inHand.getType() == Material.SHEARS) {
                BlockFace clickedFace = event.getBlockFace();
                Directional newBlockData = (Directional)Material.CARVED_PUMPKIN.createBlockData();
                if (clickedFace == BlockFace.NORTH || clickedFace == BlockFace.SOUTH || clickedFace == BlockFace.EAST || clickedFace == BlockFace.WEST) {
                    newBlockData.setFacing(clickedFace);
                } else {
                    Location playerLoc = player.getLocation();
                    playerLoc.subtract(0.5, 0.0, 0.5);
                    double dx = playerLoc.getX() - loc.getX();
                    double dz = playerLoc.getZ() - loc.getZ();
                    if (Math.abs(dx) > Math.abs(dz)) {
                        newBlockData.setFacing(dx > 0.0 ? BlockFace.EAST : BlockFace.WEST);
                    } else {
                        newBlockData.setFacing(dz > 0.0 ? BlockFace.SOUTH : BlockFace.NORTH);
                    }
                }
                this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, blockData, (BlockData)newBlockData);
            }
        }
    }

    private boolean hasText(SignSide signSide) {
        for (int i = 0; i < 4; ++i) {
            if (signSide.getLine(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGenericGameEvent(GenericGameEvent event) {
        if (this.lastInteractionPlayer != null && event.getEntity() != null && event.getEntity().getUniqueId().equals(this.lastInteractionPlayer) && this.lastInteractionLocation != null && event.getLocation().equals((Object)this.lastInteractionLocation)) {
            if (this.lastInteractionBlockData instanceof Candle) {
                Candle newCandle;
                BlockData newData;
                Candle previousCandle = (Candle)this.lastInteractionBlockData;
                if (previousCandle.isLit() && (newData = this.lastInteractionLocation.getBlock().getBlockData()) instanceof Candle && !(newCandle = (Candle)newData).isLit() && !newCandle.isWaterlogged()) {
                    this.consumer.queueBlockReplace(Actor.actorFromEntity(event.getEntity()), this.lastInteractionLocation, this.lastInteractionBlockData, newData);
                }
            } else if (this.lastInteractionBlockData instanceof Lightable && BukkitUtils.isCandleCake(this.lastInteractionBlockData.getMaterial())) {
                Lightable newLightable;
                Lightable previousLightable = (Lightable)this.lastInteractionBlockData;
                BlockData newData = this.lastInteractionLocation.getBlock().getBlockData();
                if (event.getEvent().equals(GameEvent.EAT)) {
                    WorldConfig wcfg = Config.getWorldConfig(event.getLocation().getWorld());
                    if (wcfg.isLogging(Logging.CAKEEAT)) {
                        newData = Material.CAKE.createBlockData();
                        ((Cake)newData).setBites(1);
                        this.consumer.queueBlockReplace(Actor.actorFromEntity(event.getEntity()), this.lastInteractionLocation, this.lastInteractionBlockData, newData);
                    }
                } else if (previousLightable.isLit() && newData instanceof Lightable && !(newLightable = (Lightable)newData).isLit()) {
                    this.consumer.queueBlockReplace(Actor.actorFromEntity(event.getEntity()), this.lastInteractionLocation, this.lastInteractionBlockData, newData);
                }
            }
        }
        this.lastInteractionPlayer = null;
        this.lastInteractionBlockData = null;
        this.lastInteractionLocation = null;
    }
}

