/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DumpedLogImporter
implements Runnable {
    private final LogBlock logblock;

    DumpedLogImporter(LogBlock logblock) {
        this.logblock = logblock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File[] imports = new File(this.logblock.getDataFolder(), "import").listFiles(new Utils.ExtensionFilenameFilter("sql"));
        if (imports != null && imports.length > 0) {
            this.logblock.getLogger().info("Found " + imports.length + " imports.");
            Arrays.sort(imports, new ImportsComparator());
            Connection conn = null;
            try {
                conn = this.logblock.getConnection();
                if (conn == null) {
                    return;
                }
                conn.setAutoCommit(false);
                Statement st = conn.createStatement();
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.logblock.getDataFolder(), "import/failed.txt")));
                int successes = 0;
                int errors = 0;
                try {
                    for (File sqlFile : imports) {
                        String line = null;
                        try {
                            this.logblock.getLogger().info("Trying to import " + sqlFile.getName() + " ...");
                            BufferedReader reader = new BufferedReader(new FileReader(sqlFile));
                            int statements = 0;
                            while ((line = reader.readLine()) != null) {
                                if (line.endsWith(";")) {
                                    line = line.substring(0, line.length() - 1);
                                }
                                if (line.isEmpty()) continue;
                                ++statements;
                                st.addBatch(line);
                            }
                            st.executeBatch();
                            conn.commit();
                            reader.close();
                            sqlFile.delete();
                            successes += statements;
                            this.logblock.getLogger().info("Successfully imported " + sqlFile.getName() + ".");
                        }
                        catch (Exception ignored) {
                            try {
                                BufferedReader reader = new BufferedReader(new FileReader(sqlFile));
                                while ((line = reader.readLine()) != null) {
                                    if (line.endsWith(";")) {
                                        line = line.substring(0, line.length() - 1);
                                    }
                                    if (line.isEmpty()) continue;
                                    try {
                                        st.execute(line);
                                        ++successes;
                                    }
                                    catch (SQLException ex) {
                                        this.logblock.getLogger().severe("Error while importing: '" + line + "': " + ex.getMessage());
                                        writer.write(line + Utils.newline);
                                        ++errors;
                                    }
                                }
                                conn.commit();
                                reader.close();
                                sqlFile.delete();
                                this.logblock.getLogger().info("Successfully imported " + sqlFile.getName() + ".");
                            }
                            catch (Exception ex) {
                                this.logblock.getLogger().severe("Error while importing " + sqlFile.getName() + ": " + ex.getMessage());
                                ++errors;
                            }
                        }
                    }
                }
                finally {
                    writer.close();
                }
                st.close();
                this.logblock.getLogger().info("Successfully imported stored queue. (" + successes + " rows imported, " + errors + " errors)");
            }
            catch (Exception ex) {
                this.logblock.getLogger().log(Level.WARNING, "Error while importing: ", ex);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private static class ImportsComparator
    implements Comparator<File> {
        private final Pattern splitPattern = Pattern.compile("[\\-\\.]");

        private ImportsComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            String[] name2;
            String[] name1 = this.splitPattern.split(o1.getName());
            if (name1.length > (name2 = this.splitPattern.split(o2.getName())).length) {
                return 1;
            }
            if (name1.length < name2.length) {
                return -1;
            }
            for (int i = 0; i < name1.length; ++i) {
                int compareString;
                String part1 = name1[i];
                String part2 = name2[i];
                if (part1.length() > 0 && part2.length() > 0) {
                    char first1 = part1.charAt(0);
                    char first2 = part2.charAt(0);
                    if (first1 >= '0' && first1 <= '9' && first2 >= '0' && first2 <= '9') {
                        try {
                            long long1 = Long.parseLong(part1);
                            long long2 = Long.parseLong(part2);
                            if (long1 == long2) continue;
                            return long1 > long2 ? 1 : -1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if ((compareString = part1.compareTo(part2)) == 0) continue;
                return compareString;
            }
            return 0;
        }
    }
}

