/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.blockstate;

import de.diddiz.LogBlock.blockstate.BlockStateCodec;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlockStateCodecSign
implements BlockStateCodec {
    @Override
    public Material[] getApplicableMaterials() {
        return (Material[])BukkitUtils.getAllSignMaterials().toArray(Material[]::new);
    }

    @Override
    public YamlConfiguration serialize(BlockState state) {
        YamlConfiguration conf = null;
        if (state instanceof Sign) {
            Sign sign = (Sign)state;
            boolean waxed = sign.isWaxed();
            if (waxed) {
                conf = new YamlConfiguration();
                conf.set("waxed", (Object)waxed);
            }
            for (Side side : Side.values()) {
                YamlConfiguration sideSection;
                DyeColor signColor;
                SignSide signSide = sign.getSide(side);
                String[] lines = signSide.getLines();
                boolean hasText = false;
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i] == null || lines[i].length() <= 0) continue;
                    hasText = true;
                    break;
                }
                if ((signColor = signSide.getColor()) == null) {
                    signColor = DyeColor.BLACK;
                }
                boolean glowing = signSide.isGlowingText();
                if (!hasText && signColor == DyeColor.BLACK && !glowing) continue;
                if (conf == null) {
                    conf = new YamlConfiguration();
                }
                Object object = sideSection = side == Side.FRONT ? conf : conf.createSection(side.name().toLowerCase());
                if (hasText) {
                    sideSection.set("lines", Arrays.asList(lines));
                }
                if (signColor != DyeColor.BLACK) {
                    sideSection.set("color", (Object)signColor.name());
                }
                if (!glowing) continue;
                sideSection.set("glowing", (Object)true);
            }
        }
        return conf;
    }

    public YamlConfiguration serialize(BlockState state, Side side, String[] lines) {
        YamlConfiguration conf;
        YamlConfiguration yamlConfiguration = conf = state == null ? null : this.serialize(state);
        if (lines != null) {
            YamlConfiguration sideSection;
            if (conf == null) {
                conf = new YamlConfiguration();
            }
            Object object = sideSection = side == Side.FRONT ? conf : conf.getConfigurationSection(side.name().toLowerCase());
            if (sideSection == null) {
                sideSection = conf.createSection(side.name().toLowerCase());
            }
            sideSection.set("lines", Arrays.asList(lines));
        }
        return conf;
    }

    @Override
    public void deserialize(BlockState state, YamlConfiguration conf) {
        block11: {
            if (!(state instanceof Sign)) break block11;
            Sign sign = (Sign)state;
            if (conf != null) {
                sign.setWaxed(conf.getBoolean("waxed"));
                for (Side side : Side.values()) {
                    YamlConfiguration sideSection = side == Side.FRONT ? conf : conf.getConfigurationSection(side.name().toLowerCase());
                    DyeColor signColor = DyeColor.BLACK;
                    boolean glowing = false;
                    List lines = Collections.emptyList();
                    if (sideSection != null) {
                        if (sideSection.contains("lines")) {
                            lines = sideSection.getStringList("lines");
                        }
                        if (sideSection.contains("color")) {
                            try {
                                signColor = DyeColor.valueOf((String)sideSection.getString("color"));
                            }
                            catch (IllegalArgumentException | NullPointerException runtimeException) {
                                // empty catch block
                            }
                        }
                        glowing = sideSection.getBoolean("glowing", false);
                    }
                    SignSide signSide = sign.getSide(side);
                    for (int i = 0; i < 4; ++i) {
                        String line = lines.size() > i && lines.get(i) != null ? (String)lines.get(i) : "";
                        signSide.setLine(i, line);
                    }
                    signSide.setColor(signColor);
                    signSide.setGlowingText(glowing);
                }
            } else {
                sign.setWaxed(false);
                for (Side side : Side.values()) {
                    SignSide signSide = sign.getSide(side);
                    for (int i = 0; i < 4; ++i) {
                        signSide.setLine(i, "");
                    }
                    signSide.setColor(DyeColor.BLACK);
                    signSide.setGlowingText(false);
                }
            }
        }
    }

    @Override
    public BaseComponent getChangesAsComponent(YamlConfiguration state, YamlConfiguration oldState) {
        if (state != null) {
            boolean oldWaxed;
            TextComponent tc = new TextComponent();
            boolean isWaxed = state.getBoolean("waxed");
            boolean bl = oldWaxed = oldState != null && oldState.getBoolean("waxed");
            if (isWaxed != oldWaxed) {
                tc.addExtra(isWaxed ? "(waxed)" : "(not waxed)");
            }
            for (Side side : Side.values()) {
                Object oldSideSection;
                YamlConfiguration sideSection;
                Object object = sideSection = side == Side.FRONT ? state : state.getConfigurationSection(side.name().toLowerCase());
                if (tc.getExtra() != null && !tc.getExtra().isEmpty()) {
                    tc.addExtra(" ");
                }
                tc.addExtra(side.name() + ":");
                List lines = sideSection == null ? Collections.emptyList() : sideSection.getStringList("lines");
                List oldLines = Collections.emptyList();
                DyeColor signColor = DyeColor.BLACK;
                if (sideSection != null && sideSection.contains("color")) {
                    try {
                        signColor = DyeColor.valueOf((String)sideSection.getString("color"));
                    }
                    catch (IllegalArgumentException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
                DyeColor oldSignColor = DyeColor.BLACK;
                boolean glowing = sideSection != null && sideSection.getBoolean("glowing", false);
                boolean oldGlowing = false;
                if (oldState != null) {
                    Object object2 = oldSideSection = side == Side.FRONT ? oldState : oldState.getConfigurationSection(side.name().toLowerCase());
                    if (oldSideSection != null) {
                        oldLines = oldSideSection.getStringList("lines");
                        if (oldSideSection.contains("color")) {
                            try {
                                oldSignColor = DyeColor.valueOf((String)oldSideSection.getString("color"));
                            }
                            catch (IllegalArgumentException | NullPointerException runtimeException) {
                                // empty catch block
                            }
                        }
                        oldGlowing = oldSideSection.getBoolean("glowing", false);
                    }
                }
                if (!lines.equals(oldLines)) {
                    oldSideSection = lines.iterator();
                    while (oldSideSection.hasNext()) {
                        String line = (String)oldSideSection.next();
                        if (tc.getExtra() != null && !tc.getExtra().isEmpty()) {
                            tc.addExtra(" ");
                        }
                        tc.addExtra("[");
                        if (line != null && !line.isEmpty()) {
                            tc.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)line)));
                        }
                        tc.addExtra("]");
                    }
                }
                if (signColor != oldSignColor) {
                    if (tc.getExtra() != null && !tc.getExtra().isEmpty()) {
                        tc.addExtra(" ");
                    }
                    tc.addExtra("(color: ");
                    TextComponent colorText = new TextComponent(signColor.name().toLowerCase());
                    colorText.setColor(ChatColor.of((Color)new Color(signColor.getColor().asARGB())));
                    tc.addExtra((BaseComponent)colorText);
                    tc.addExtra(")");
                }
                if (glowing == oldGlowing) continue;
                if (tc.getExtra() != null && !tc.getExtra().isEmpty()) {
                    tc.addExtra(" ");
                }
                if (glowing) {
                    tc.addExtra("(glowing)");
                    continue;
                }
                tc.addExtra("(not glowing)");
            }
            return tc;
        }
        return null;
    }
}

