/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.WorldEditor;
import de.diddiz.LogBlock.util.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.inventory.ItemStack;

public class WorldEditorEditFactory {
    private final WorldEditor editor;
    private final boolean rollback;
    private final QueryParams params;

    public WorldEditorEditFactory(WorldEditor editor, QueryParams params, boolean rollback) {
        this.editor = editor;
        this.params = params;
        this.rollback = rollback;
    }

    public void processRow(ResultSet rs) throws SQLException {
        if (this.params.bct == QueryParams.BlockChangeType.ENTITIES) {
            this.editor.queueEntityEdit(rs, this.params, this.rollback);
            return;
        }
        ChestAccess chestaccess = null;
        ItemStack stack = Utils.loadItemStack(rs.getBytes("item"));
        if (stack != null) {
            chestaccess = new ChestAccess(stack, rs.getBoolean("itemremove") == this.rollback, rs.getInt("itemtype"));
        }
        if (this.rollback) {
            this.editor.queueBlockEdit(rs.getTimestamp("date").getTime(), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getInt("replaced"), rs.getInt("replacedData"), rs.getBytes("replacedState"), rs.getInt("type"), rs.getInt("typeData"), rs.getBytes("typeState"), chestaccess);
        } else {
            this.editor.queueBlockEdit(rs.getTimestamp("date").getTime(), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getInt("type"), rs.getInt("typeData"), rs.getBytes("typeState"), rs.getInt("replaced"), rs.getInt("replacedData"), rs.getBytes("replacedState"), chestaccess);
        }
    }
}

