/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockSpreadEvent;

public class BlockSpreadLogging
extends LoggingListener {
    public BlockSpreadLogging(LogBlock lb) {
        super(lb);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        String name;
        block13: {
            Material type;
            World world;
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    world = event.getNewState().getWorld();
                                    type = event.getNewState().getType();
                                    if (type != Material.GRASS) break block12;
                                    if (!Config.isLogging(world, Logging.GRASSGROWTH)) {
                                        return;
                                    }
                                    name = "GrassGrowth";
                                    break block13;
                                }
                                if (type != Material.MYCELIUM) break block14;
                                if (!Config.isLogging(world, Logging.MYCELIUMSPREAD)) {
                                    return;
                                }
                                name = "MyceliumSpread";
                                break block13;
                            }
                            if (type != Material.VINE && type != Material.CAVE_VINES && type != Material.CAVE_VINES_PLANT && type != Material.WEEPING_VINES && type != Material.WEEPING_VINES_PLANT && type != Material.TWISTING_VINES && type != Material.TWISTING_VINES_PLANT) break block15;
                            if (!Config.isLogging(world, Logging.VINEGROWTH)) {
                                return;
                            }
                            name = "VineGrowth";
                            break block13;
                        }
                        if (type != Material.RED_MUSHROOM && type != Material.BROWN_MUSHROOM) break block16;
                        if (!Config.isLogging(world, Logging.MUSHROOMSPREAD)) {
                            return;
                        }
                        name = "MushroomSpread";
                        break block13;
                    }
                    if (type != Material.BAMBOO && type != Material.BAMBOO_SAPLING) break block17;
                    if (!Config.isLogging(world, Logging.BAMBOOGROWTH)) {
                        return;
                    }
                    name = "BambooGrowth";
                    if (type == Material.BAMBOO_SAPLING) {
                        this.consumer.queueBlockReplace(new Actor(name), event.getSource().getState(), Material.BAMBOO.createBlockData());
                    }
                    break block13;
                }
                if (type != Material.POINTED_DRIPSTONE) break block18;
                if (!Config.isLogging(world, Logging.DRIPSTONEGROWTH)) {
                    return;
                }
                name = "DripstoneGrowth";
                PointedDripstone pointed = (PointedDripstone)event.getNewState().getBlockData();
                if (pointed.getThickness() == PointedDripstone.Thickness.TIP_MERGE) {
                    PointedDripstone oldState = (PointedDripstone)event.getNewState().getBlockData();
                    oldState.setThickness(PointedDripstone.Thickness.TIP);
                    this.consumer.queueBlockReplace(new Actor(name), (BlockData)oldState, event.getNewState());
                    return;
                }
                BlockFace direction = pointed.getVerticalDirection();
                Block previousPart = event.getBlock().getRelative(direction.getOppositeFace());
                if (previousPart.getType() == Material.POINTED_DRIPSTONE) {
                    PointedDripstone newBelow = (PointedDripstone)previousPart.getBlockData();
                    newBelow.setThickness(PointedDripstone.Thickness.FRUSTUM);
                    this.consumer.queueBlockReplace(new Actor(name), previousPart.getState(), (BlockData)newBelow);
                    previousPart = previousPart.getRelative(direction.getOppositeFace());
                    if (previousPart.getType() == Material.POINTED_DRIPSTONE) {
                        Block evenMorePrevious = previousPart.getRelative(direction.getOppositeFace());
                        newBelow = (PointedDripstone)previousPart.getBlockData();
                        newBelow.setThickness(evenMorePrevious.getType() == Material.POINTED_DRIPSTONE ? PointedDripstone.Thickness.MIDDLE : PointedDripstone.Thickness.BASE);
                        this.consumer.queueBlockReplace(new Actor(name), previousPart.getState(), (BlockData)newBelow);
                    }
                }
                break block13;
            }
            if (type != Material.SCULK && type != Material.SCULK_VEIN && type != Material.SCULK_CATALYST && type != Material.SCULK_SENSOR && type != Material.SCULK_SHRIEKER) {
                return;
            }
            if (!Config.isLogging(world, Logging.SCULKSPREAD)) {
                return;
            }
            name = "SculkSpread";
        }
        this.consumer.queueBlockReplace(new Actor(name), event.getBlock().getState(), event.getNewState());
    }
}

