/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.worldedit;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import de.diddiz.LogBlock.LogBlock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class WorldEditHelper {
    private static boolean checkedForWorldEdit;
    private static boolean hasWorldEdit;

    public static boolean hasWorldEdit() {
        if (!checkedForWorldEdit) {
            checkedForWorldEdit = true;
            Plugin worldEdit = Bukkit.getPluginManager().getPlugin("WorldEdit");
            boolean bl = hasWorldEdit = worldEdit != null;
            if (worldEdit != null) {
                Internal.setWorldEdit(worldEdit);
            }
        }
        return hasWorldEdit;
    }

    public static boolean hasFullWorldEdit() {
        return hasWorldEdit && Internal.hasBukkitImplAdapter();
    }

    public static byte[] serializeEntity(org.bukkit.entity.Entity entity) {
        if (!WorldEditHelper.hasWorldEdit()) {
            return null;
        }
        return Internal.serializeEntity(entity);
    }

    public static org.bukkit.entity.Entity restoreEntity(Location location, EntityType type, byte[] serialized) {
        if (!WorldEditHelper.hasWorldEdit()) {
            return null;
        }
        return Internal.restoreEntity(location, type, serialized);
    }

    public static de.diddiz.LogBlock.util.CuboidRegion getSelectedRegion(Player player) throws IllegalArgumentException {
        if (!WorldEditHelper.hasWorldEdit()) {
            throw new IllegalArgumentException("WorldEdit not found!");
        }
        return Internal.getSelectedRegion(player);
    }

    private static class Internal {
        private static WorldEditPlugin worldEdit;
        private static Method getBukkitImplAdapter;

        private Internal() {
        }

        public static void setWorldEdit(Plugin worldEdit) {
            Internal.worldEdit = (WorldEditPlugin)worldEdit;
        }

        public static boolean hasBukkitImplAdapter() {
            if (getBukkitImplAdapter == null) {
                try {
                    getBukkitImplAdapter = WorldEditPlugin.class.getDeclaredMethod("getBukkitImplAdapter", new Class[0]);
                    getBukkitImplAdapter.setAccessible(true);
                }
                catch (Exception e) {
                    LogBlock.getInstance().getLogger().log(Level.SEVERE, "Exception while checking for BukkitImplAdapter", e);
                    return false;
                }
            }
            try {
                return getBukkitImplAdapter.invoke((Object)worldEdit, new Object[0]) != null;
            }
            catch (Exception e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Exception while checking for BukkitImplAdapter", e);
                return false;
            }
        }

        public static org.bukkit.entity.Entity restoreEntity(Location location, EntityType type, byte[] serialized) {
            com.sk89q.worldedit.world.entity.EntityType weType = BukkitAdapter.adapt((EntityType)type);
            com.sk89q.worldedit.util.Location weLocation = BukkitAdapter.adapt((Location)location);
            try {
                NBTInputStream nbtis = new NBTInputStream((InputStream)new ByteArrayInputStream(serialized));
                NamedTag namedTag = nbtis.readNamedTag();
                nbtis.close();
                UUID newUUID = null;
                if (namedTag.getName().equals("entity") && namedTag.getTag() instanceof CompoundTag) {
                    CompoundTag serializedState = (CompoundTag)namedTag.getTag();
                    BaseEntity state = new BaseEntity(weType, serializedState);
                    Entity weEntity = weLocation.getExtent().createEntity(weLocation, state);
                    if (weEntity != null) {
                        CompoundTag newNbt = weEntity.getState().getNbtData();
                        int[] uuidInts = newNbt.getIntArray("UUID");
                        newUUID = uuidInts != null && uuidInts.length >= 4 ? new UUID((long)uuidInts[0] << 32 | (long)uuidInts[1] & 0xFFFFFFFFL, (long)uuidInts[2] << 32 | (long)uuidInts[3] & 0xFFFFFFFFL) : new UUID(newNbt.getLong("UUIDMost"), newNbt.getLong("UUIDLeast"));
                    }
                }
                return newUUID == null ? null : Bukkit.getEntity(newUUID);
            }
            catch (IOException e) {
                throw new RuntimeException("This IOException should be impossible", e);
            }
        }

        public static byte[] serializeEntity(org.bukkit.entity.Entity entity) {
            Entity weEntity = BukkitAdapter.adapt((org.bukkit.entity.Entity)entity);
            BaseEntity state = weEntity.getState();
            if (state != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    NBTOutputStream nbtos = new NBTOutputStream((OutputStream)baos);
                    CompoundTag nbt = state.getNbtData();
                    LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>(nbt.getValue());
                    value.put("Health", new FloatTag(20.0f));
                    value.put("Motion", new ListTag(DoubleTag.class, Arrays.asList(new DoubleTag(0.0), new DoubleTag(0.0), new DoubleTag(0.0))));
                    value.put("Fire", new ShortTag(-20));
                    value.put("HurtTime", new ShortTag(0));
                    nbtos.writeNamedTag("entity", (Tag)new CompoundTag(value));
                    nbtos.close();
                    return baos.toByteArray();
                }
                catch (IOException e) {
                    throw new RuntimeException("This IOException should be impossible", e);
                }
            }
            return null;
        }

        public static de.diddiz.LogBlock.util.CuboidRegion getSelectedRegion(Player player) throws IllegalArgumentException {
            Region selection;
            LocalSession session = worldEdit.getSession(player);
            org.bukkit.World world = player.getWorld();
            World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
            if (!weWorld.equals((Object)session.getSelectionWorld())) {
                throw new IllegalArgumentException("No selection defined");
            }
            try {
                selection = session.getSelection(weWorld);
            }
            catch (IncompleteRegionException e) {
                throw new IllegalArgumentException("No selection defined");
            }
            if (selection == null) {
                throw new IllegalArgumentException("No selection defined");
            }
            if (!(selection instanceof CuboidRegion)) {
                throw new IllegalArgumentException("You have to define a cuboid selection");
            }
            BlockVector3 min = selection.getMinimumPoint();
            BlockVector3 max = selection.getMaximumPoint();
            return new de.diddiz.LogBlock.util.CuboidRegion(world, new BlockVector(min.getBlockX(), min.getBlockY(), min.getBlockZ()), new BlockVector(max.getBlockX(), max.getBlockY(), max.getBlockZ()));
        }
    }
}

