/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSign;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.ComparableVersion;
import de.diddiz.util.UUIDFetcher;
import de.diddiz.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

class Updater {
    private final LogBlock logblock;
    final int UUID_CONVERT_BATCH_SIZE = 100;
    final int BLOCKS_CONVERT_BATCH_SIZE = 100000;
    final int OTHER_CONVERT_BATCH_SIZE = 20000;

    Updater(LogBlock logblock) {
        this.logblock = logblock;
    }

    boolean update() {
        Object rs;
        Statement st;
        Object conn;
        FileConfiguration config = this.logblock.getConfig();
        String versionString = config.getString("version");
        ComparableVersion configVersion = new ComparableVersion(versionString);
        if (configVersion.compareTo(new ComparableVersion("1.2.7")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.2.7 ...");
            if (Config.isLogging(Logging.CHAT) || Config.isLogging(Logging.PLAYER_COMMANDS) || Config.isLogging(Logging.CONSOLE_COMMANDS) || Config.isLogging(Logging.COMMANDBLOCK_COMMANDS)) {
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-chat` ADD FULLTEXT message (message)");
                    st.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            config.set("version", (Object)"1.2.7");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3")) < 0) {
            this.logblock.getLogger().info("Updating config to 1.3.0 ...");
            for (String tool : config.getConfigurationSection("tools").getKeys(false)) {
                if (config.get("tools." + tool + ".permissionDefault") != null) continue;
                config.set("tools." + tool + ".permissionDefault", (Object)"OP");
            }
            config.set("version", (Object)"1.3.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.3.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.execute("ALTER TABLE `lb-players` ADD COLUMN lastlogin DATETIME NOT NULL, ADD COLUMN onlinetime TIME NOT NULL, ADD COLUMN ip VARCHAR(255) NOT NULL");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.3.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3.2")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.3.2 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.execute("ALTER TABLE `lb-players` ADD COLUMN firstlogin DATETIME NOT NULL AFTER playername");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.3.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.4")) < 0) {
            this.logblock.getLogger().info("Updating config to 1.4.0 ...");
            config.set("clearlog.keepLogDays", null);
            config.set("version", (Object)"1.4.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.4.2")) < 0) {
            this.logblock.getLogger().info("Updating config to 1.4.2 ...");
            for (String world : config.getStringList("loggedWorlds")) {
                File file = new File(this.logblock.getDataFolder(), BukkitUtils.friendlyWorldname(world) + ".yml");
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                if (yamlConfiguration.contains("logBlockCreations")) {
                    yamlConfiguration.set("logging.BLOCKPLACE", (Object)yamlConfiguration.getBoolean("logBlockCreations"));
                }
                if (yamlConfiguration.contains("logBlockDestroyings")) {
                    yamlConfiguration.set("logging.BLOCKBREAK", (Object)yamlConfiguration.getBoolean("logBlockDestroyings"));
                }
                if (yamlConfiguration.contains("logSignTexts")) {
                    yamlConfiguration.set("logging.SIGNTEXT", (Object)yamlConfiguration.getBoolean("logSignTexts"));
                }
                if (yamlConfiguration.contains("logFire")) {
                    yamlConfiguration.set("logging.FIRE", (Object)yamlConfiguration.getBoolean("logFire"));
                }
                if (yamlConfiguration.contains("logLeavesDecay")) {
                    yamlConfiguration.set("logging.LEAVESDECAY", (Object)yamlConfiguration.getBoolean("logLeavesDecay"));
                }
                if (yamlConfiguration.contains("logLavaFlow")) {
                    yamlConfiguration.set("logging.LAVAFLOW", (Object)yamlConfiguration.getBoolean("logLavaFlow"));
                }
                if (yamlConfiguration.contains("logWaterFlow")) {
                    yamlConfiguration.set("logging.WATERFLOW", (Object)yamlConfiguration.getBoolean("logWaterFlow"));
                }
                if (yamlConfiguration.contains("logChestAccess")) {
                    yamlConfiguration.set("logging.CHESTACCESS", (Object)yamlConfiguration.getBoolean("logChestAccess"));
                }
                if (yamlConfiguration.contains("logButtonsAndLevers")) {
                    yamlConfiguration.set("logging.SWITCHINTERACT", (Object)yamlConfiguration.getBoolean("logButtonsAndLevers"));
                }
                if (yamlConfiguration.contains("logKills")) {
                    yamlConfiguration.set("logging.KILL", (Object)yamlConfiguration.getBoolean("logKills"));
                }
                if (yamlConfiguration.contains("logChat")) {
                    yamlConfiguration.set("logging.CHAT", (Object)yamlConfiguration.getBoolean("logChat"));
                }
                if (yamlConfiguration.contains("logSnowForm")) {
                    yamlConfiguration.set("logging.SNOWFORM", (Object)yamlConfiguration.getBoolean("logSnowForm"));
                }
                if (yamlConfiguration.contains("logSnowFade")) {
                    yamlConfiguration.set("logging.SNOWFADE", (Object)yamlConfiguration.getBoolean("logSnowFade"));
                }
                if (yamlConfiguration.contains("logDoors")) {
                    yamlConfiguration.set("logging.DOORINTERACT", (Object)yamlConfiguration.getBoolean("logDoors"));
                }
                if (yamlConfiguration.contains("logCakes")) {
                    yamlConfiguration.set("logging.CAKEEAT", (Object)yamlConfiguration.getBoolean("logCakes"));
                }
                if (yamlConfiguration.contains("logEndermen")) {
                    yamlConfiguration.set("logging.ENDERMEN", (Object)yamlConfiguration.getBoolean("logEndermen"));
                }
                if (yamlConfiguration.contains("logExplosions")) {
                    boolean logExplosions = yamlConfiguration.getBoolean("logExplosions");
                    yamlConfiguration.set("logging.TNTEXPLOSION", (Object)logExplosions);
                    yamlConfiguration.set("logging.MISCEXPLOSION", (Object)logExplosions);
                    yamlConfiguration.set("logging.CREEPEREXPLOSION", (Object)logExplosions);
                    yamlConfiguration.set("logging.GHASTFIREBALLEXPLOSION", (Object)logExplosions);
                }
                yamlConfiguration.set("logBlockCreations", null);
                yamlConfiguration.set("logBlockDestroyings", null);
                yamlConfiguration.set("logSignTexts", null);
                yamlConfiguration.set("logExplosions", null);
                yamlConfiguration.set("logFire", null);
                yamlConfiguration.set("logLeavesDecay", null);
                yamlConfiguration.set("logLavaFlow", null);
                yamlConfiguration.set("logWaterFlow", null);
                yamlConfiguration.set("logChestAccess", null);
                yamlConfiguration.set("logButtonsAndLevers", null);
                yamlConfiguration.set("logKills", null);
                yamlConfiguration.set("logChat", null);
                yamlConfiguration.set("logSnowForm", null);
                yamlConfiguration.set("logSnowFade", null);
                yamlConfiguration.set("logDoors", null);
                yamlConfiguration.set("logCakes", null);
                yamlConfiguration.set("logEndermen", null);
                try {
                    yamlConfiguration.save(file);
                }
                catch (IOException ex) {
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                }
            }
            config.set("clearlog.keepLogDays", null);
            config.set("version", (Object)"1.4.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.5.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.5.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                for (WorldConfig worldConfig : Config.getLoggedWorlds()) {
                    if (!worldConfig.isLogging(Logging.KILL)) continue;
                    st.execute("ALTER TABLE `" + worldConfig.table + "-kills` ADD (x MEDIUMINT NOT NULL DEFAULT 0, y SMALLINT NOT NULL DEFAULT 0, z MEDIUMINT NOT NULL DEFAULT 0)");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.5.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.5.2")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.5.2 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                rs = st.executeQuery("SHOW COLUMNS FROM `lb-players` WHERE field = 'onlinetime'");
                if (rs.next() && rs.getString("Type").equalsIgnoreCase("time")) {
                    st.execute("ALTER TABLE `lb-players` ADD onlinetime2 INT UNSIGNED NOT NULL");
                    st.execute("UPDATE `lb-players` SET onlinetime2 = HOUR(onlinetime) * 3600 + MINUTE(onlinetime) * 60 + SECOND(onlinetime)");
                    st.execute("ALTER TABLE `lb-players` DROP onlinetime");
                    st.execute("ALTER TABLE `lb-players` CHANGE onlinetime2 onlinetime INT UNSIGNED NOT NULL");
                } else {
                    this.logblock.getLogger().info("Column lb-players was already modified, skipping it.");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.5.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.8.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.8.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                for (WorldConfig worldConfig : Config.getLoggedWorlds()) {
                    if (!worldConfig.isLogging(Logging.CHESTACCESS)) continue;
                    st.execute("ALTER TABLE `" + worldConfig.table + "-chest` CHANGE itemdata itemdata SMALLINT NOT NULL");
                    this.logblock.getLogger().info("Table " + worldConfig.table + "-chest modified");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.8.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.9")) < 0) {
            block148: {
                this.logblock.getLogger().info("Updating tables to 1.9.0 ...");
                this.logblock.getLogger().info("Importing UUIDs for large databases may take some time");
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-players` ADD `UUID` VARCHAR(36) NOT NULL");
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 1060) break block148;
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            try {
                String unimportedPrefix = "noimport_";
                conn.setAutoCommit(true);
                Statement statement = conn.createStatement();
                if (config.getBoolean("logging.logPlayerInfo")) {
                    statement.execute("UPDATE `lb-players` SET UUID = CONCAT ('log_',playername) WHERE onlinetime=0 AND LENGTH(UUID) = 0");
                } else {
                    unimportedPrefix = "log_";
                }
                rs = statement.executeQuery("SELECT COUNT(playername) FROM `lb-players` WHERE LENGTH(UUID)=0");
                rs.next();
                String total = Integer.toString(rs.getInt(1));
                this.logblock.getLogger().info(total + " players to convert");
                int done = 0;
                conn.setAutoCommit(false);
                HashMap<String, Integer> players = new HashMap<String, Integer>();
                ArrayList<String> names = new ArrayList<String>(100);
                rs = statement.executeQuery("SELECT playerid,playername FROM `lb-players` WHERE LENGTH(UUID)=0 LIMIT " + Integer.toString(100));
                while (rs.next()) {
                    do {
                        players.put(rs.getString(2), rs.getInt(1));
                        names.add(rs.getString(2));
                    } while (rs.next());
                    if (names.size() <= 0) continue;
                    Map<String, UUID> response = UUIDFetcher.getUUIDs(names);
                    for (Map.Entry entry : players.entrySet()) {
                        String theUUID;
                        if (response.get(entry.getKey()) == null) {
                            theUUID = unimportedPrefix + (String)entry.getKey();
                            this.logblock.getLogger().warning((String)entry.getKey() + " not found - giving UUID of " + theUUID);
                        } else {
                            theUUID = response.get(entry.getKey()).toString();
                        }
                        String thePID = ((Integer)entry.getValue()).toString();
                        statement.execute("UPDATE `lb-players` SET UUID = '" + theUUID + "' WHERE playerid = " + thePID);
                        ++done;
                    }
                    conn.commit();
                    players.clear();
                    names.clear();
                    this.logblock.getLogger().info("Processed " + Integer.toString(done) + " out of " + total);
                    rs.close();
                    rs = statement.executeQuery("SELECT playerid,playername FROM `lb-players` WHERE LENGTH(UUID)=0 LIMIT " + Integer.toString(100));
                }
                rs.close();
                statement.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            catch (Exception ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[UUID importer]", ex);
                return false;
            }
            config.set("version", (Object)"1.9.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.9.4")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.9.4 ...");
            conn = this.logblock.getConnection();
            try {
                block150: {
                    block149: {
                        conn.setAutoCommit(true);
                        st = conn.createStatement();
                        try {
                            st.execute("DROP INDEX UUID ON `lb-players`");
                        }
                        catch (SQLException ex) {
                            if (ex.getErrorCode() == 1091) break block149;
                            this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                            return false;
                        }
                    }
                    try {
                        st.execute("DROP INDEX playername ON `lb-players`");
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 1091) break block150;
                        this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                        return false;
                    }
                }
                st.execute("CREATE INDEX UUID ON `lb-players` (UUID);");
                st.execute("CREATE INDEX playername ON `lb-players` (playername);");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.9.4");
        }
        if (configVersion.compareTo(new ComparableVersion("1.10.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.10.0 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                this.checkCharset("lb-players", "name", st, false);
                if (Config.isLogging(Logging.CHAT) || Config.isLogging(Logging.PLAYER_COMMANDS) || Config.isLogging(Logging.CONSOLE_COMMANDS) || Config.isLogging(Logging.COMMANDBLOCK_COMMANDS)) {
                    this.checkCharset("lb-chat", "message", st, false);
                }
                for (WorldConfig worldConfig : Config.getLoggedWorlds()) {
                    if (!worldConfig.isLogging(Logging.SIGNTEXT)) continue;
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.10.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.12.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.12.0 ...");
            if (Config.isLogging(Logging.CHAT) || Config.isLogging(Logging.PLAYER_COMMANDS) || Config.isLogging(Logging.CONSOLE_COMMANDS) || Config.isLogging(Logging.COMMANDBLOCK_COMMANDS)) {
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-chat` MODIFY COLUMN `message` VARCHAR(256) NOT NULL");
                    st.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            config.set("version", (Object)"1.12.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.13.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.13.0 ...");
            try {
                MaterialUpdater1_13 materialUpdater = new MaterialUpdater1_13(this.logblock);
                this.logblock.getLogger().info("Convertig BlockId to BlockData. This can take a while ...");
                Connection conn2 = this.logblock.getConnection();
                conn2.setAutoCommit(false);
                Statement st3 = conn2.createStatement();
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    ResultSet rs2;
                    int failedRows;
                    int id;
                    this.logblock.getLogger().info("Processing world " + wcfg.world + "...");
                    this.logblock.getLogger().info("Processing block changes...");
                    boolean hadRow = true;
                    long rowsToConvert = 0L;
                    long done = 0L;
                    try {
                        ResultSet rs22 = st3.executeQuery("SELECT count(*) as rowcount FROM `" + wcfg.table + "`");
                        if (rs22.next()) {
                            rowsToConvert = rs22.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + wcfg.table);
                        }
                        rs22.close();
                        PreparedStatement deleteStatement = conn2.prepareStatement("DELETE FROM `" + wcfg.table + "` WHERE id = ?");
                        PreparedStatement insertStatement = conn2.prepareStatement("INSERT INTO `" + wcfg.table + "-blocks` (id, date, playerid, replaced, replacedData, type, typeData, x, y, z) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
                        while (hadRow) {
                            hadRow = false;
                            ResultSet entries = st3.executeQuery("SELECT id, date, playerid, replaced, type, data, x, y, z FROM `" + wcfg.table + "` ORDER BY id ASC LIMIT " + 100000);
                            while (entries.next()) {
                                hadRow = true;
                                id = entries.getInt("id");
                                Timestamp date = entries.getTimestamp("date");
                                int playerid = entries.getInt("playerid");
                                int replaced = entries.getInt("replaced");
                                int type = entries.getInt("type");
                                int data = entries.getInt("data");
                                int x = entries.getInt("x");
                                int y = entries.getInt("y");
                                int z = entries.getInt("z");
                                if (data == 16) {
                                    data = 0;
                                }
                                try {
                                    BlockData replacedBlockData = materialUpdater.getBlockData(replaced, data);
                                    BlockData setBlockData = materialUpdater.getBlockData(type, data);
                                    int newReplacedId = MaterialConverter.getOrAddMaterialId(replacedBlockData);
                                    int newReplacedData = MaterialConverter.getOrAddBlockStateId(replacedBlockData);
                                    int newSetId = MaterialConverter.getOrAddMaterialId(setBlockData);
                                    int newSetData = MaterialConverter.getOrAddBlockStateId(setBlockData);
                                    insertStatement.setInt(1, id);
                                    insertStatement.setTimestamp(2, date);
                                    insertStatement.setInt(3, playerid);
                                    insertStatement.setInt(4, newReplacedId);
                                    insertStatement.setInt(5, newReplacedData);
                                    insertStatement.setInt(6, newSetId);
                                    insertStatement.setInt(7, newSetData);
                                    insertStatement.setInt(8, x);
                                    insertStatement.setInt(9, y);
                                    insertStatement.setInt(10, z);
                                    insertStatement.addBatch();
                                }
                                catch (Exception e) {
                                    this.logblock.getLogger().info("Exception in entry " + id + " (" + replaced + ":" + data + "->" + type + ":" + data + "): " + e.getMessage());
                                }
                                deleteStatement.setInt(1, id);
                                deleteStatement.addBatch();
                                ++done;
                            }
                            entries.close();
                            failedRows = 0;
                            if (hadRow) {
                                try {
                                    insertStatement.executeBatch();
                                }
                                catch (BatchUpdateException e) {
                                    for (int result : e.getUpdateCounts()) {
                                        if (result != -3) continue;
                                        ++failedRows;
                                    }
                                }
                                deleteStatement.executeBatch();
                            }
                            conn2.commit();
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " " + (failedRows > 0 ? "Duplicates: " + failedRows + " " : "") + "(" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                        }
                        insertStatement.close();
                        deleteStatement.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + wcfg.table + ": " + e.getMessage());
                    }
                    this.logblock.getLogger().info("Processing chests...");
                    rowsToConvert = 0L;
                    done = 0L;
                    try {
                        rs2 = st3.executeQuery("SELECT count(*) as rowcount FROM `" + wcfg.table + "-chest`");
                        if (rs2.next()) {
                            rowsToConvert = rs2.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + wcfg.table + "-chest");
                        }
                        rs2.close();
                        PreparedStatement insertChestData = conn2.prepareStatement("INSERT INTO `" + wcfg.table + "-chestdata` (id, item, itemremove, itemtype) VALUES (?, ?, ?, ?)");
                        PreparedStatement deleteChest = conn2.prepareStatement("DELETE FROM `" + wcfg.table + "-chest` WHERE id = ?");
                        while (true) {
                            rs2 = st3.executeQuery("SELECT id, itemtype, itemamount, itemdata FROM `" + wcfg.table + "-chest` ORDER BY id ASC LIMIT " + 20000);
                            boolean anyRow = false;
                            while (rs2.next()) {
                                anyRow = true;
                                id = rs2.getInt("id");
                                int itemtype = rs2.getInt("itemtype");
                                int itemdata = rs2.getInt("itemdata");
                                int amount = rs2.getInt("itemamount");
                                Material weaponMaterial = materialUpdater.getMaterial(itemtype, itemdata);
                                if (weaponMaterial == null) {
                                    weaponMaterial = Material.AIR;
                                }
                                ItemStack stack = weaponMaterial.getMaxDurability() > 0 ? new ItemStack(weaponMaterial, Math.abs(amount), (short)itemdata) : new ItemStack(weaponMaterial, Math.abs(amount));
                                insertChestData.setInt(1, id);
                                insertChestData.setBytes(2, Utils.saveItemStack(stack));
                                insertChestData.setInt(3, amount >= 0 ? 0 : 1);
                                insertChestData.setInt(4, MaterialConverter.getOrAddMaterialId(weaponMaterial));
                                insertChestData.addBatch();
                                deleteChest.setInt(1, id);
                                deleteChest.addBatch();
                                ++done;
                            }
                            rs2.close();
                            if (!anyRow) break;
                            failedRows = 0;
                            try {
                                insertChestData.executeBatch();
                            }
                            catch (BatchUpdateException e) {
                                for (int result : e.getUpdateCounts()) {
                                    if (result != -3) continue;
                                    ++failedRows;
                                }
                            }
                            deleteChest.executeBatch();
                            conn2.commit();
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " " + (failedRows > 0 ? "Duplicates: " + failedRows + " " : "") + "(" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                        }
                        insertChestData.close();
                        deleteChest.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + wcfg.table + "-chest: " + e.getMessage());
                    }
                    if (!wcfg.isLogging(Logging.KILL)) continue;
                    this.logblock.getLogger().info("Processing kills...");
                    rowsToConvert = 0L;
                    done = 0L;
                    try {
                        rs2 = st3.executeQuery("SELECT count(*) as rowcount FROM `" + wcfg.table + "-kills`");
                        if (rs2.next()) {
                            rowsToConvert = rs2.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + wcfg.table + "-kills");
                        }
                        rs2.close();
                        PreparedStatement updateWeaponStatement = conn2.prepareStatement("UPDATE `" + wcfg.table + "-kills` SET weapon = ? WHERE id = ?");
                        int start = 0;
                        while (true) {
                            rs2 = st3.executeQuery("SELECT id, weapon FROM `" + wcfg.table + "-kills` ORDER BY id ASC LIMIT " + start + "," + 20000);
                            boolean anyUpdate = false;
                            boolean anyRow = false;
                            while (rs2.next()) {
                                int newWeapon;
                                anyRow = true;
                                int id2 = rs2.getInt("id");
                                int weapon = rs2.getInt("weapon");
                                Material weaponMaterial = materialUpdater.getMaterial(weapon, 0);
                                if (weaponMaterial == null) {
                                    weaponMaterial = Material.AIR;
                                }
                                if ((newWeapon = MaterialConverter.getOrAddMaterialId(weaponMaterial)) != weapon) {
                                    anyUpdate = true;
                                    updateWeaponStatement.setInt(1, newWeapon);
                                    updateWeaponStatement.setInt(2, id2);
                                    updateWeaponStatement.addBatch();
                                }
                                ++done;
                            }
                            rs2.close();
                            if (anyUpdate) {
                                updateWeaponStatement.executeBatch();
                                conn2.commit();
                            }
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " (" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                            if (!anyRow) break;
                            start += 20000;
                        }
                        updateWeaponStatement.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + wcfg.table + "-kills: " + e.getMessage());
                    }
                }
                st3.close();
                conn2.close();
                this.logblock.getLogger().info("Updating config to 1.13.0 ...");
                config.set("logging.hiddenBlocks", materialUpdater.convertMaterials(config.getStringList("logging.hiddenBlocks")));
                config.set("rollback.dontRollback", materialUpdater.convertMaterials(config.getStringList("rollback.dontRollback")));
                config.set("rollback.replaceAnyway", materialUpdater.convertMaterials(config.getStringList("rollback.replaceAnyway")));
                ConfigurationSection configurationSection = config.getConfigurationSection("tools");
                for (String toolName : configurationSection.getKeys(false)) {
                    ConfigurationSection tSec = configurationSection.getConfigurationSection(toolName);
                    tSec.set("item", (Object)materialUpdater.convertMaterial(tSec.getString("item", "OAK_LOG")));
                }
            }
            catch (IOException | SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.13.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.13.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.13.1 ...");
            try {
                conn = this.logblock.getConnection();
                conn.setAutoCommit(false);
                st = conn.createStatement();
                for (WorldConfig worldConfig : Config.getLoggedWorlds()) {
                    this.logblock.getLogger().info("Processing world " + worldConfig.world + "...");
                    ResultSet rsCol = st.executeQuery("SHOW COLUMNS FROM `" + worldConfig.table + "-chestdata` LIKE 'itemtype'");
                    if (!rsCol.next()) {
                        st.execute("ALTER TABLE `" + worldConfig.table + "-chestdata` ADD COLUMN `itemtype` SMALLINT NOT NULL DEFAULT '0'");
                    }
                    rsCol.close();
                    conn.commit();
                    if (!worldConfig.isLogging(Logging.SIGNTEXT)) continue;
                    long rowsToConvert = 0L;
                    long done = 0L;
                    try {
                        ResultSet rs3 = st.executeQuery("SELECT count(*) as rowcount FROM `" + worldConfig.table + "-sign`");
                        if (rs3.next()) {
                            rowsToConvert = rs3.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + worldConfig.table + "-sign");
                        }
                        rs3.close();
                        PreparedStatement insertSignState = conn.prepareStatement("INSERT INTO `" + worldConfig.table + "-state` (id, replacedState, typeState) VALUES (?, ?, ?)");
                        PreparedStatement deleteSign = conn.prepareStatement("DELETE FROM `" + worldConfig.table + "-sign` WHERE id = ?");
                        while (true) {
                            rs3 = st.executeQuery("SELECT id, signtext, replaced, type FROM `" + worldConfig.table + "-sign` LEFT JOIN `" + worldConfig.table + "-blocks` USING (id) ORDER BY id ASC LIMIT " + 20000);
                            boolean anyRow = false;
                            while (rs3.next()) {
                                anyRow = true;
                                int id = rs3.getInt("id");
                                String signText = rs3.getString("signtext");
                                int replaced = rs3.getInt("replaced");
                                boolean nullBlock = rs3.wasNull();
                                int type = rs3.getInt("type");
                                if (!nullBlock && signText != null) {
                                    String[] lines = signText.split("\u0000", 4);
                                    byte[] bytes = Utils.serializeYamlConfiguration(BlockStateCodecSign.serialize(lines));
                                    Material replacedMaterial = MaterialConverter.getBlockData(replaced, -1).getMaterial();
                                    Material typeMaterial = MaterialConverter.getBlockData(type, -1).getMaterial();
                                    boolean wasSign = replacedMaterial == Material.OAK_SIGN || replacedMaterial == Material.OAK_WALL_SIGN;
                                    boolean isSign = typeMaterial == Material.OAK_SIGN || typeMaterial == Material.OAK_WALL_SIGN;
                                    insertSignState.setInt(1, id);
                                    insertSignState.setBytes(2, (byte[])(wasSign ? bytes : null));
                                    insertSignState.setBytes(3, (byte[])(isSign ? bytes : null));
                                    insertSignState.addBatch();
                                }
                                deleteSign.setInt(1, id);
                                deleteSign.addBatch();
                                ++done;
                            }
                            rs3.close();
                            if (!anyRow) break;
                            int failedRows = 0;
                            try {
                                insertSignState.executeBatch();
                            }
                            catch (BatchUpdateException e) {
                                for (int result : e.getUpdateCounts()) {
                                    if (result != -3) continue;
                                    ++failedRows;
                                }
                            }
                            deleteSign.executeBatch();
                            conn.commit();
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " " + (failedRows > 0 ? "Duplicates: " + failedRows + " " : "") + "(" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                        }
                        insertSignState.close();
                        deleteSign.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + worldConfig.table + "-sign: " + e.getMessage());
                    }
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.13.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.16.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.16.0 ...");
            try {
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    for (WorldConfig worldConfig : Config.getLoggedWorlds()) {
                        this.createIndexIfDoesNotExist(worldConfig.table + "-entities", "entityid", "KEY `entityid` (entityid)", st, false);
                    }
                    st.close();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Warning: Could not add index", ex);
            }
            config.set("version", (Object)"1.16.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.17.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.17.0 ...");
            this.logblock.getLogger().warning("The updating process might take several minutes if you have a huge log table! Please do not shutdown your server until it is completed.");
            try {
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    for (WorldConfig worldConfig : Config.getLoggedWorlds()) {
                        st.executeUpdate("ALTER TABLE `" + worldConfig.table + "-blocks` CHANGE `y` `y` SMALLINT(5) NOT NULL");
                    }
                    st.close();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Warning: Could not alter table", ex);
            }
            this.logblock.getLogger().info("Update to 1.17.0 completed.");
            config.set("version", (Object)"1.17.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.17.0")) < 0) {
            config.set("version", (Object)"1.17.0");
        }
        try {
            conn = this.logblock.getConnection();
            conn.setAutoCommit(true);
            st = conn.createStatement();
            this.checkCharset("lb-players", "name", st, true);
            if (Config.isLogging(Logging.CHAT) || Config.isLogging(Logging.PLAYER_COMMANDS) || Config.isLogging(Logging.CONSOLE_COMMANDS) || Config.isLogging(Logging.COMMANDBLOCK_COMMANDS)) {
                this.checkCharset("lb-chat", "message", st, true);
            }
            this.createIndexIfDoesNotExist("lb-materials", "name", "UNIQUE KEY `name` (`name`(150))", st, true);
            this.createIndexIfDoesNotExist("lb-blockstates", "name", "UNIQUE KEY `name` (`name`(150))", st, true);
            st.close();
            conn.close();
        }
        catch (SQLException ex) {
            this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
            return false;
        }
        this.updateMaterialsPost1_13();
        this.logblock.saveConfig();
        return true;
    }

    void createIndexIfDoesNotExist(String table, String indexName, String definition, Statement st, boolean silent) throws SQLException {
        ResultSet rs = st.executeQuery("SHOW INDEX FROM `" + table + "` WHERE Key_name = '" + indexName + "'");
        if (!rs.next()) {
            st.execute("ALTER TABLE `" + table + "` ADD " + definition);
            this.logblock.getLogger().info("Add index " + indexName + " to table " + table + ": Table modified");
        } else if (!silent) {
            this.logblock.getLogger().info("Add index " + indexName + " to table " + table + ": Already fine, skipping it");
        }
        rs.close();
    }

    void checkCharset(String table, String column, Statement st, boolean silent) throws SQLException {
        ResultSet rs = st.executeQuery("SHOW FULL COLUMNS FROM `" + table + "` WHERE field = '" + column + "'");
        String charset = "utf8";
        if (Config.mb4) {
            charset = "utf8mb4";
        }
        if (rs.next() && !rs.getString("Collation").substring(0, charset.length()).equalsIgnoreCase(charset)) {
            st.execute("ALTER TABLE `" + table + "` CONVERT TO CHARSET " + charset);
            this.logblock.getLogger().info("Table " + table + " modified");
        } else if (!silent) {
            this.logblock.getLogger().info("Table " + table + " already fine, skipping it");
        }
        rs.close();
    }

    void checkTables() throws SQLException {
        Connection conn;
        String charset = "utf8";
        if (Config.mb4) {
            charset = "utf8mb4";
        }
        if ((conn = this.logblock.getConnection()) == null) {
            throw new SQLException("No connection");
        }
        Statement state = conn.createStatement();
        conn.setAutoCommit(true);
        this.createTable(state, "lb-players", "(playerid INT UNSIGNED NOT NULL AUTO_INCREMENT, UUID varchar(36) NOT NULL, playername varchar(32) NOT NULL, firstlogin DATETIME NOT NULL, lastlogin DATETIME NOT NULL, onlinetime INT UNSIGNED NOT NULL, ip varchar(255) NOT NULL, PRIMARY KEY (playerid), INDEX (UUID), INDEX (playername)) DEFAULT CHARSET " + charset);
        ResultSet rs = state.executeQuery("SELECT NULL FROM `lb-players` LIMIT 1;");
        if (!rs.next()) {
            state.execute("INSERT IGNORE INTO `lb-players` (UUID,playername) VALUES ('log_dummy_record','dummy_record')");
        }
        if (Config.isLogging(Logging.CHAT) || Config.isLogging(Logging.PLAYER_COMMANDS) || Config.isLogging(Logging.CONSOLE_COMMANDS) || Config.isLogging(Logging.COMMANDBLOCK_COMMANDS)) {
            try {
                this.createTable(state, "lb-chat", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, message VARCHAR(256) NOT NULL, PRIMARY KEY (id), KEY playerid (playerid), FULLTEXT message (message)) DEFAULT CHARSET " + charset);
            }
            catch (SQLException e) {
                this.createTable(state, "lb-chat", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, message VARCHAR(256) NOT NULL, PRIMARY KEY (id), KEY playerid (playerid)) DEFAULT CHARSET " + charset);
            }
        }
        this.createTable(state, "lb-materials", "(id INT UNSIGNED NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY (id)) DEFAULT CHARSET " + charset);
        this.createTable(state, "lb-blockstates", "(id INT UNSIGNED NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY (id)) DEFAULT CHARSET " + charset);
        this.createTable(state, "lb-entitytypes", "(id INT UNSIGNED NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY (id)) DEFAULT CHARSET " + charset);
        for (WorldConfig wcfg : Config.getLoggedWorlds()) {
            this.createTable(state, wcfg.table + "-blocks", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, replaced SMALLINT UNSIGNED NOT NULL, replacedData SMALLINT NOT NULL, type SMALLINT UNSIGNED NOT NULL, typeData SMALLINT NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT NOT NULL, z MEDIUMINT NOT NULL, PRIMARY KEY (id), KEY coords (x, z, y), KEY date (date), KEY playerid (playerid))");
            this.createTable(state, wcfg.table + "-chestdata", "(id INT UNSIGNED NOT NULL, item MEDIUMBLOB, itemremove TINYINT, itemtype SMALLINT NOT NULL DEFAULT '0', PRIMARY KEY (id))");
            this.createTable(state, wcfg.table + "-state", "(id INT UNSIGNED NOT NULL, replacedState MEDIUMBLOB NULL, typeState MEDIUMBLOB NULL, PRIMARY KEY (id))");
            if (wcfg.isLogging(Logging.KILL)) {
                this.createTable(state, wcfg.table + "-kills", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, killer INT UNSIGNED, victim INT UNSIGNED NOT NULL, weapon SMALLINT UNSIGNED NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT NOT NULL, z MEDIUMINT NOT NULL, PRIMARY KEY (id))");
            }
            this.createTable(state, wcfg.table + "-entityids", "(entityid INT UNSIGNED NOT NULL AUTO_INCREMENT, entityuuid VARCHAR(36) CHARACTER SET ascii COLLATE ascii_bin NOT NULL, PRIMARY KEY (entityid), UNIQUE KEY (entityuuid))");
            this.createTable(state, wcfg.table + "-entities", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, entityid INT UNSIGNED NOT NULL, entitytypeid INT UNSIGNED NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT NOT NULL, z MEDIUMINT NOT NULL, action TINYINT UNSIGNED NOT NULL, data MEDIUMBLOB NULL, PRIMARY KEY (id), KEY coords (x, z, y), KEY date (date), KEY playerid (playerid), KEY entityid (entityid))");
        }
        state.close();
        conn.close();
    }

    private void createTable(Statement state, String table, String query) throws SQLException {
        block13: {
            try (ResultSet tableResult = state.executeQuery("SHOW TABLES LIKE '" + table + "'");){
                if (tableResult.next()) break block13;
                this.logblock.getLogger().log(Level.INFO, "Creating table " + table + ".");
                state.execute("CREATE TABLE `" + table + "` " + query);
                try (ResultSet tableResultNew = state.executeQuery("SHOW TABLES LIKE '" + table + "'");){
                    if (!tableResultNew.next()) {
                        throw new SQLException("Table " + table + " not found and failed to create");
                    }
                }
            }
        }
    }

    private void updateMaterialsPost1_13() {
        FileConfiguration config = this.logblock.getConfig();
        String previousMinecraftVersion = config.getString("previousMinecraftVersion");
        if (previousMinecraftVersion == null) {
            previousMinecraftVersion = "1.13";
        }
        ComparableVersion comparablePreviousMinecraftVersion = new ComparableVersion(previousMinecraftVersion);
        String currentMinecraftVersion = this.logblock.getServer().getVersion();
        currentMinecraftVersion = currentMinecraftVersion.substring(currentMinecraftVersion.indexOf("(MC: ") + 5);
        int currentVersionEnd = currentMinecraftVersion.indexOf(" ");
        int currentVersionEnd2 = currentMinecraftVersion.indexOf(")");
        if (currentVersionEnd2 >= 0 && (currentVersionEnd < 0 || currentVersionEnd2 < currentVersionEnd)) {
            currentVersionEnd = currentVersionEnd2;
        }
        currentMinecraftVersion = currentMinecraftVersion.substring(0, currentVersionEnd);
        this.logblock.getLogger().info("[Updater] Current Minecraft Version: '" + currentMinecraftVersion + "'");
        ComparableVersion comparableCurrentMinecraftVersion = new ComparableVersion(currentMinecraftVersion);
        if (comparablePreviousMinecraftVersion.compareTo("1.14") < 0 && comparableCurrentMinecraftVersion.compareTo("1.14") >= 0) {
            this.logblock.getLogger().info("[Updater] Upgrading Materials to 1.14");
            this.renameMaterial("minecraft:sign", Material.OAK_SIGN);
            this.renameMaterial("minecraft:wall_sign", Material.OAK_WALL_SIGN);
            this.renameMaterial("minecraft:stone_slab", Material.SMOOTH_STONE_SLAB);
            this.renameMaterial("minecraft:rose_red", Material.RED_DYE);
            this.renameMaterial("minecraft:dandelion_yellow", Material.YELLOW_DYE);
            this.renameMaterial("minecraft:cactus_green", Material.GREEN_DYE);
        }
        if (comparablePreviousMinecraftVersion.compareTo("1.17") < 0 && comparableCurrentMinecraftVersion.compareTo("1.17") >= 0) {
            this.logblock.getLogger().info("[Updater] Upgrading Materials to 1.17");
            this.renameMaterial("minecraft:grass_path", Material.DIRT_PATH);
        }
        config.set("previousMinecraftVersion", (Object)currentMinecraftVersion);
        this.logblock.saveConfig();
    }

    private void renameMaterial(String oldName, Material newName) {
        Connection conn = this.logblock.getConnection();
        try {
            conn.setAutoCommit(false);
            PreparedStatement stSelectMaterial = conn.prepareStatement("SELECT id FROM `lb-materials` WHERE name = ?");
            stSelectMaterial.setString(1, oldName);
            ResultSet rs = stSelectMaterial.executeQuery();
            if (rs.next()) {
                this.logblock.getLogger().info("[Updater] Updating " + oldName + " to " + newName);
                int oldId = rs.getInt(1);
                int newId = MaterialConverter.getOrAddMaterialId(newName);
                Statement st = conn.createStatement();
                int rows = 0;
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    rows += st.executeUpdate("UPDATE `" + wcfg.table + "-blocks` SET replaced = " + newId + " WHERE replaced = " + oldId);
                    rows += st.executeUpdate("UPDATE `" + wcfg.table + "-blocks` SET type = " + newId + " WHERE type = " + oldId);
                    rows += st.executeUpdate("UPDATE `" + wcfg.table + "-chestdata` SET itemtype = " + newId + " WHERE itemtype = " + oldId);
                    if (!wcfg.isLogging(Logging.KILL)) continue;
                    rows += st.executeUpdate("UPDATE `" + wcfg.table + "-kills` SET weapon = " + newId + " WHERE weapon = " + oldId);
                }
                st.close();
                if (rows > 0) {
                    this.logblock.getLogger().info("[Updater] Successfully updated " + rows + " entries..");
                }
            }
            stSelectMaterial.close();
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: " + ex.getMessage(), ex);
        }
    }

    public static class MaterialUpdater1_13 {
        BlockData[][] blockDataMapping;
        Material[][] itemMapping = new Material[10][];

        public MaterialUpdater1_13(LogBlock plugin) throws IOException {
            this.blockDataMapping = new BlockData[256][16];
            try (JarFile file = new JarFile(plugin.getFile());){
                String line;
                String line2;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(file.getInputStream(file.getJarEntry("blockdata.txt"))), "UTF-8"));
                while ((line2 = reader.readLine()) != null) {
                    int splitter1 = line2.indexOf(":");
                    int splitter2 = line2.indexOf(",");
                    if (splitter1 < 0 || splitter2 < 0) continue;
                    int blockid = Integer.parseInt(line2.substring(0, splitter1));
                    int blockdata = Integer.parseInt(line2.substring(splitter1 + 1, splitter2));
                    BlockData newBlockData = Bukkit.createBlockData((String)line2.substring(splitter2 + 1));
                    if (blockdata == 0) {
                        for (int i = 0; i < 16; ++i) {
                            if (this.blockDataMapping[blockid][i] != null) continue;
                            this.blockDataMapping[blockid][i] = newBlockData;
                        }
                        continue;
                    }
                    this.blockDataMapping[blockid][blockdata] = newBlockData;
                }
                reader.close();
                HashMap<String, Material> materialKeysToMaterial = new HashMap<String, Material>();
                for (Material material : Material.values()) {
                    materialKeysToMaterial.put(material.getKey().toString(), material);
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(file.getInputStream(file.getJarEntry("itemdata.txt"))), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    Material[] itemValues;
                    int splitter1 = line.indexOf(":");
                    int splitter2 = line.indexOf(",");
                    if (splitter1 < 0 || splitter2 < 0) continue;
                    int itemid = Integer.parseInt(line.substring(0, splitter1));
                    int itemdata = Integer.parseInt(line.substring(splitter1 + 1, splitter2));
                    Material newMaterial = (Material)materialKeysToMaterial.get(line.substring(splitter2 + 1));
                    if (newMaterial == null) {
                        throw new IOException("Unknown item: " + line.substring(splitter2 + 1));
                    }
                    if (itemid >= this.itemMapping.length) {
                        this.itemMapping = (Material[][])Arrays.copyOf(this.itemMapping, Math.max(this.itemMapping.length * 3 / 2, itemid + 1));
                    }
                    if ((itemValues = this.itemMapping[itemid]) == null) {
                        itemValues = new Material[itemdata + 1];
                        this.itemMapping[itemid] = itemValues;
                    } else if (itemValues.length <= itemdata) {
                        itemValues = Arrays.copyOf(itemValues, itemdata + 1);
                        this.itemMapping[itemid] = itemValues;
                    }
                    itemValues[itemdata] = newMaterial;
                }
                reader.close();
            }
        }

        public BlockData getBlockData(int id, int data) {
            return id >= 0 && id < 256 && data >= 0 && data < 16 ? this.blockDataMapping[id][data] : null;
        }

        public Material getMaterial(int id, int data) {
            Material[] materials;
            Material[] materialArray = materials = id >= 0 && id < this.itemMapping.length ? this.itemMapping[id] : null;
            if (materials != null && materials.length > 0) {
                if (materials[0] != null && materials[0].getMaxDurability() == 0 && data >= 0 && data < materials.length && materials[data] != null) {
                    return materials[data];
                }
                return materials[0];
            }
            return null;
        }

        public Material getMaterial(String id) {
            int item = 0;
            int data = 0;
            int seperator = id.indexOf(58);
            if (seperator < 0) {
                item = Integer.parseInt(id);
            } else {
                item = Integer.parseInt(id.substring(0, seperator));
                data = Integer.parseInt(id.substring(seperator + 1));
            }
            return this.getMaterial(item, data);
        }

        public String convertMaterial(String oldEntry) {
            block5: {
                if (oldEntry == null) {
                    return null;
                }
                try {
                    Material newMaterial = this.getMaterial(oldEntry);
                    if (newMaterial != null) {
                        return newMaterial.name();
                    }
                }
                catch (Exception e) {
                    Material newMaterial = Material.matchMaterial((String)oldEntry, (boolean)true);
                    if (newMaterial != null) {
                        return newMaterial.name();
                    }
                    newMaterial = Material.matchMaterial((String)oldEntry);
                    if (newMaterial == null) break block5;
                    return newMaterial.name();
                }
            }
            return null;
        }

        public List<String> convertMaterials(Collection<String> oldEntries) {
            LinkedHashSet<String> newEntries = new LinkedHashSet<String>();
            for (String oldEntry : oldEntries) {
                String newEntry = this.convertMaterial(oldEntry);
                if (newEntry == null) continue;
                newEntries.add(newEntry);
                if (!newEntry.equals(Material.AIR.name())) continue;
                newEntries.add(Material.CAVE_AIR.name());
                newEntries.add(Material.VOID_AIR.name());
            }
            return new ArrayList<String>(newEntries);
        }
    }

    public static class PlayerCountChecker
    implements Runnable {
        private LogBlock logblock;

        public PlayerCountChecker(LogBlock logblock) {
            this.logblock = logblock;
        }

        @Override
        public void run() {
            block4: {
                Connection conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    Statement st = conn.createStatement();
                    ResultSet rs = st.executeQuery("SELECT auto_increment FROM information_schema.columns AS col join information_schema.tables AS tab ON (col.table_schema=tab.table_schema AND col.table_name=tab.table_name) WHERE col.table_name = 'lb-players' AND col.column_name = 'playerid' AND col.data_type = 'smallint' AND col.table_schema = DATABASE() AND auto_increment > 65000;");
                    if (rs.next()) {
                        for (int i = 0; i < 6; ++i) {
                            this.logblock.getLogger().warning("Your server reached 65000 players. You should soon update your database table schema - see FAQ: https://github.com/LogBlock/LogBlock/wiki/FAQ#logblock-your-server-reached-65000-players-");
                        }
                    }
                    st.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    if (!this.logblock.isCompletelyEnabled()) break block4;
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                }
            }
        }
    }
}

