/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.cache;

import com.griefcraft.cache.CacheKey;
import com.griefcraft.cache.LRUCache;
import com.griefcraft.cache.MethodCounter;
import com.griefcraft.cache.WeakLRUCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;

public class ProtectionCache {
    private static final int ADAPTIVE_CACHE_TICK = 10;
    private static final int ADAPTIVE_CACHE_MAX = 100000;
    private final LWC lwc;
    private final LRUCache<Protection, Object> references;
    private final WeakLRUCache<UUID, Protection> byEntityId;
    private final WeakLRUCache<CacheKey, Protection> byCacheKey;
    private final WeakLRUCache<Integer, Protection> byId;
    private final WeakLRUCache<CacheKey, Protection> byKnownBlock;
    private final LRUCache<CacheKey, Object> byKnownNulls;
    private final LRUCache<CacheKey, Object> directByKnownNulls;
    private final LRUCache<UUID, Object> byKnownNullsEntities;
    private int capacity;
    private int adaptiveCapacity = 0;
    private final MethodCounter counter = new MethodCounter();
    private static final Object FAKE_VALUE = new Object();

    public ProtectionCache(LWC lwc) {
        this.lwc = lwc;
        this.capacity = Math.max(10000, lwc.getConfiguration().getInt("core.cacheSize", 10000));
        this.references = new LRUCache(this.capacity);
        this.byCacheKey = new WeakLRUCache(this.capacity);
        this.byId = new WeakLRUCache(this.capacity);
        this.byKnownBlock = new WeakLRUCache(this.capacity);
        this.byEntityId = new WeakLRUCache(this.capacity);
        this.byKnownNulls = new LRUCache(this.capacity);
        this.directByKnownNulls = new LRUCache(this.capacity);
        this.byKnownNullsEntities = new LRUCache(this.capacity);
    }

    public void increaseIfNecessary() {
        if (this.isFull() && this.adaptiveCapacity < 100000) {
            this.adaptiveCapacity += 10;
            this.adjustCacheSizes();
        }
    }

    public LRUCache<Protection, Object> getReferences() {
        return this.references;
    }

    public MethodCounter getMethodCounter() {
        return this.counter;
    }

    public int capacity() {
        return this.capacity;
    }

    public int adaptiveCapacity() {
        return this.adaptiveCapacity;
    }

    public int totalCapacity() {
        return this.capacity + this.adaptiveCapacity;
    }

    public void clear() {
        this.references.clear();
        this.byCacheKey.clear();
        this.byId.clear();
        this.byKnownBlock.clear();
        this.byKnownNulls.clear();
        this.directByKnownNulls.clear();
        this.byKnownNullsEntities.clear();
        this.byEntityId.clear();
    }

    public boolean isFull() {
        return this.references.size() >= this.totalCapacity();
    }

    public int size() {
        return this.references.size();
    }

    public void addProtection(Protection protection) {
        if (protection == null) {
            return;
        }
        this.counter.increment("addProtection");
        if (protection.getEntityId() != null) {
            this.byKnownNullsEntities.remove(protection.getEntityId());
        } else {
            this.byKnownNulls.remove(protection.getCacheKey());
            this.directByKnownNulls.remove(protection.getCacheKey());
        }
        this.references.put(protection, null);
        if (protection.getEntityId() != null) {
            this.byEntityId.put(protection.getEntityId(), protection);
            this.byId.put(protection.getId(), protection);
            return;
        }
        this.byCacheKey.put(protection.getCacheKey(), protection);
        this.byId.put(protection.getId(), protection);
        if (protection.getProtectionFinder() != null && protection.getBlock() != null) {
            Block protectedBlock = protection.getBlock();
            for (BlockState state : protection.getProtectionFinder().getBlocks()) {
                if (protectedBlock.equals((Object)state.getBlock())) continue;
                CacheKey cacheKey = ProtectionCache.cacheKey(state.getLocation());
                this.byKnownBlock.put(cacheKey, protection);
            }
        }
    }

    public void removeProtection(Protection protection) {
        this.counter.increment("removeProtection");
        this.references.remove(protection);
        if (protection.getEntityId() != null) {
            this.byEntityId.remove(protection.getEntityId());
            this.byId.remove(protection.getId());
            return;
        }
        this.byId.remove(protection.getId());
        if (protection.getProtectionFinder() != null) {
            for (BlockState state : protection.getProtectionFinder().getBlocks()) {
                this.remove(ProtectionCache.cacheKey(state.getLocation()));
            }
        }
    }

    public Protection getProtection(BlockState block) {
        return this.getProtection(ProtectionCache.cacheKey(block.getWorld().getName(), block.getX(), block.getY(), block.getZ()));
    }

    public void remove(CacheKey cacheKey) {
        this.byCacheKey.remove(cacheKey);
        this.byKnownBlock.remove(cacheKey);
        this.byKnownNulls.remove(cacheKey);
        this.directByKnownNulls.remove(cacheKey);
    }

    public void remove(UUID entityId) {
        this.byEntityId.remove(entityId);
        this.byKnownNullsEntities.remove(entityId);
    }

    public void addKnownNull(CacheKey cacheKey) {
        this.counter.increment("addKnownNull");
        this.byKnownNulls.put(cacheKey, FAKE_VALUE);
    }

    public boolean isKnownNull(CacheKey cacheKey) {
        this.counter.increment("isKnownNull");
        return this.byKnownNulls.containsKey(cacheKey);
    }

    public void addDirectKnownNull(CacheKey cacheKey) {
        this.counter.increment("addDirectKnownNull");
        this.directByKnownNulls.put(cacheKey, FAKE_VALUE);
    }

    public boolean isDirectKnownNull(CacheKey cacheKey) {
        this.counter.increment("isDirectKnownNull");
        return this.directByKnownNulls.containsKey(cacheKey);
    }

    public boolean isKnownNull(UUID entityId) {
        return this.byKnownNullsEntities.containsKey(entityId);
    }

    public Protection getProtection(CacheKey cacheKey) {
        this.counter.increment("getProtection");
        Protection protection = this.byCacheKey.get(cacheKey);
        if (protection != null) {
            return protection;
        }
        return this.byKnownBlock.get(cacheKey);
    }

    public Protection getProtection(Block block) {
        return this.getProtection(ProtectionCache.cacheKey(block.getWorld().getName(), block.getX(), block.getY(), block.getZ()));
    }

    public Protection getProtection(Entity entity) {
        return this.byEntityId.get(entity.getUniqueId());
    }

    public boolean isKnownBlock(Block block) {
        this.counter.increment("isKnownBlock");
        return this.byKnownBlock.containsKey(ProtectionCache.cacheKey(block.getWorld().getName(), block.getX(), block.getY(), block.getZ()));
    }

    public Protection getProtectionById(int id) {
        this.counter.increment("getProtectionById");
        return this.byId.get(id);
    }

    public static CacheKey cacheKey(Location location) {
        return ProtectionCache.cacheKey(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static CacheKey cacheKey(String world, int x, int y, int z) {
        return new CacheKey(world, x, y, z);
    }

    private void adjustCacheSizes() {
        this.references.maxCapacity = this.totalCapacity();
        this.byCacheKey.maxCapacity = this.totalCapacity();
        this.byId.maxCapacity = this.totalCapacity();
        this.byKnownBlock.maxCapacity = this.totalCapacity();
        this.byKnownNulls.maxCapacity = this.totalCapacity();
        this.directByKnownNulls.maxCapacity = this.totalCapacity();
        this.byEntityId.maxCapacity = this.totalCapacity();
        this.byKnownNullsEntities.maxCapacity = this.totalCapacity();
    }

    public LWC getLwc() {
        return this.lwc;
    }

    public void addKnownNull(UUID entityId) {
        this.byKnownNullsEntities.put(entityId, null);
    }
}

