/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.matchers;

import com.griefcraft.util.ProtectionFinder;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;

public class WallMatcher
implements ProtectionFinder.Matcher {
    public static final Set<Material> PROTECTABLES_WALL = EnumSet.of(Material.ACACIA_WALL_SIGN, new Material[]{Material.BIRCH_WALL_SIGN, Material.DARK_OAK_WALL_SIGN, Material.SPRUCE_WALL_SIGN, Material.JUNGLE_WALL_SIGN, Material.OAK_WALL_SIGN, Material.WHITE_WALL_BANNER, Material.ORANGE_WALL_BANNER, Material.MAGENTA_WALL_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.YELLOW_WALL_BANNER, Material.LIME_WALL_BANNER, Material.PINK_WALL_BANNER, Material.GRAY_WALL_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.CYAN_WALL_BANNER, Material.PURPLE_WALL_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_WALL_BANNER, Material.GREEN_WALL_BANNER, Material.RED_WALL_BANNER, Material.BLACK_WALL_BANNER, Material.STONE_BUTTON, Material.LEVER, Material.OAK_BUTTON, Material.SPRUCE_BUTTON, Material.BIRCH_BUTTON, Material.JUNGLE_BUTTON, Material.DARK_OAK_BUTTON, Material.ACACIA_BUTTON});
    public static final BlockFace[] POSSIBLE_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    @Override
    public boolean matches(ProtectionFinder finder) {
        Block block = finder.getBaseBlock().getBlock();
        for (BlockFace blockFace : POSSIBLE_FACES) {
            Block matched;
            Block face = block.getRelative(blockFace);
            if (face == null || (matched = this.tryMatchBlock(face, blockFace)) == null) continue;
            finder.addBlock(matched);
            return true;
        }
        return false;
    }

    private Block tryMatchBlock(Block block, BlockFace matchingFace) {
        if (PROTECTABLES_WALL.contains(block.getType())) {
            Switch switcher;
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Directional)) {
                return null;
            }
            BlockFace existingFace = ((Directional)blockData).getFacing();
            if (blockData instanceof Switch && (switcher = (Switch)blockData).getAttachedFace() != FaceAttachable.AttachedFace.WALL) {
                BlockFace blockFace = existingFace = switcher.getAttachedFace() == FaceAttachable.AttachedFace.FLOOR ? BlockFace.UP : BlockFace.DOWN;
            }
            if (existingFace == matchingFace) {
                return block;
            }
        }
        return null;
    }
}

