/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MethodCounter {
    private final Map<String, VariableInteger> counts = new HashMap<String, VariableInteger>();

    public void increment(String method) {
        this.deltaMethod(method, 1);
    }

    public void decrement(String method) {
        this.deltaMethod(method, -1);
    }

    public int get(String method) {
        return this.counts.containsKey(method) ? this.counts.get((Object)method).value : 0;
    }

    public Map<String, Integer> sortByValue() {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        for (Map.Entry<String, VariableInteger> e : this.counts.entrySet()) {
            out.put(e.getKey(), e.getValue().value);
        }
        return Collections.unmodifiableMap(MethodCounter.sortByComparator(out, false));
    }

    private void deltaMethod(String method, int delta) {
        VariableInteger value = this.counts.get(method);
        if (value == null) {
            this.counts.put(method, new VariableInteger(delta));
            return;
        }
        value.value += delta;
    }

    private static Map<String, Integer> sortByComparator(Map<String, Integer> unsortMap, final boolean order) {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    private class VariableInteger {
        public int value;

        public VariableInteger(int value) {
            this.value = value;
        }
    }
}

