/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

public class TimeUtil {
    public static long parseTime(String time) {
        long seconds = 0L;
        String[] split = time.split(" ");
        for (int index = 0; index < split.length; ++index) {
            if (index == 0) continue;
            String sub = split[index].toLowerCase();
            int multiplier = 0;
            long unit = 0L;
            try {
                multiplier = Integer.parseInt(split[index - 1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (sub.startsWith("second")) {
                unit = 1L;
            } else if (sub.startsWith("minute")) {
                unit = 60L;
            } else if (sub.startsWith("hour")) {
                unit = 3600L;
            } else if (sub.startsWith("day")) {
                unit = 86400L;
            } else if (sub.startsWith("week")) {
                unit = 604800L;
            } else if (sub.startsWith("month")) {
                unit = 2629743L;
            } else if (sub.startsWith("year")) {
                unit = 31556926L;
            }
            seconds += (long)multiplier * unit;
        }
        return seconds;
    }

    public static String timeToString(long time) {
        String str = "";
        if (System.currentTimeMillis() / 1000L - time <= 0L) {
            return "Not yet known";
        }
        long days = time / 86400L;
        long hours = (time -= days * 86400L) / 3600L;
        long minutes = (time -= hours * 3600L) / 60L;
        long seconds = time -= minutes * 60L;
        if (days > 0L) {
            str = str + days + " day" + (days == 1L ? "" : "s") + " ";
        }
        if (hours > 0L) {
            str = str + hours + " hour" + (hours == 1L ? "" : "s") + " ";
        }
        if (minutes > 0L) {
            str = str + minutes + " minute" + (minutes == 1L ? "" : "s") + " ";
        }
        if (seconds > 0L) {
            str = str + seconds + " second" + (seconds == 1L ? "" : "s") + " ";
        }
        if (str.equals("")) {
            return "less than a second";
        }
        return str.trim();
    }
}

