/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.modify;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ModifyModule
extends JavaModule {
    private final Pattern ID_MATCHER = Pattern.compile(".*id:(\\d+).*");

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("modify") && !event.hasAction("create")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        LWCPlayer player = lwc.wrapPlayer((CommandSender)event.getPlayer());
        Player bPlayer = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        if (!lwc.isAdmin(bPlayer) && Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "readonly-modify"))) {
            lwc.sendLocale(player, "protection.accessdenied", new Object[0]);
            return;
        }
        if (lwc.canAdminProtection(player.getBukkitPlayer(), protection)) {
            Action action = player.hasAction("modify") ? player.getAction("modify") : player.getAction("create");
            String data = action.getData();
            String[] rights = new String[]{};
            if (data.length() > 0) {
                rights = data.split(" ");
            }
            lwc.removeModes(player.getBukkitPlayer());
            lwc.processRightsModifications((CommandSender)player.getBukkitPlayer(), protection, rights);
        } else {
            lwc.sendLocale(player, "protection.interact.error.notowner", "block", LWC.materialToString(protection.getBlockMaterial()));
            lwc.removeModes(player.getBukkitPlayer());
        }
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("modify")) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        lwc.sendLocale((CommandSender)player, "protection.interact.error.notregistered", "block", LWC.materialToString(block));
        lwc.removeModes(player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("m", "modify")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        String full = StringUtil.join(args, 0).trim();
        event.setCancelled(true);
        if (!lwc.hasPlayerPermission(sender, "lwc.modify")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        if (args.length < 1) {
            lwc.sendLocale(sender, "help.modify", new Object[0]);
            return;
        }
        Matcher matcher = this.ID_MATCHER.matcher(full);
        if (matcher.matches()) {
            int protectionId = Integer.parseInt(matcher.group(1));
            Protection protection = lwc.getPhysicalDatabase().loadProtection(protectionId);
            if (protection == null) {
                lwc.sendLocale(sender, "lwc.protectionnotfound", new Object[0]);
                return;
            }
            if (sender instanceof Player && !lwc.canAdminProtection((Player)sender, protection)) {
                lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
                return;
            }
            lwc.processRightsModifications(sender, protection, args);
            return;
        }
        if (!(sender instanceof Player)) {
            lwc.sendLocale(sender, "lwc.onlyrealplayers", new Object[0]);
            return;
        }
        LWCPlayer player = lwc.wrapPlayer(sender);
        Action action = new Action();
        action.setName("modify");
        action.setPlayer(player);
        action.setData(full);
        player.removeAllActions();
        player.addAction(action);
        lwc.sendLocale(sender, "protection.modify.finalize", new Object[0]);
    }
}

