/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.flag;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.Flag;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.StringUtil;
import org.bukkit.command.CommandSender;

public class BaseFlagModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (!event.hasAction("flag")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        LWCPlayer player = lwc.wrapPlayer((CommandSender)event.getPlayer());
        Action action = player.getAction("flag");
        String data = action.getData();
        event.setResult(Module.Result.CANCEL);
        if (!event.canAdmin()) {
            lwc.sendLocale(player, "protection.accessdenied", new Object[0]);
            return;
        }
        boolean shouldAdd = data.substring(0, 1).equals("+");
        String flagName = data.substring(1);
        Flag.Type type = null;
        for (Flag.Type tmp : Flag.Type.values()) {
            if (!tmp.toString().equalsIgnoreCase(flagName)) continue;
            type = tmp;
            break;
        }
        if (type == null) {
            lwc.sendLocale(player, "protection.internalerror", "id", "flg");
            return;
        }
        Flag flag = protection.getFlag(type);
        if (flag == null) {
            flag = new Flag(type);
        }
        if (shouldAdd) {
            protection.addFlag(flag);
            lwc.sendLocale(player, "protection.interact.flag.add", "flag", StringUtil.capitalizeFirstLetter(flagName));
        } else {
            protection.removeFlag(flag);
            lwc.sendLocale(player, "protection.interact.flag.remove", "flag", StringUtil.capitalizeFirstLetter(flagName));
        }
        protection.save();
        lwc.removeModes(player.getBukkitPlayer());
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        String internalType;
        if (!event.hasFlag("f", "flag")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (args.length < 2) {
            lwc.sendSimpleUsage(sender, "/lwc flag <flag> <on/off>");
            if (args.length < 1) {
                Object flags = "";
                for (Flag.Type type : Flag.Type.values()) {
                    flags = (String)flags + "\u00a7e" + type.toString().toLowerCase() + "\u00a7f, ";
                }
                flags = ((String)flags).substring(0, ((String)flags).length() - 2);
                lwc.sendLocale(sender, "lwc.flags.available", "flags", flags);
            }
            return;
        }
        LWCPlayer player = lwc.wrapPlayer(sender);
        String flagName = args[0];
        String type = args[1].toLowerCase();
        if (!lwc.hasPermission(sender, "lwc.flag." + flagName, "lwc.protect", "lwc.allflags")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        Flag.Type match = null;
        for (Flag.Type flag : Flag.Type.values()) {
            if (!flag.toString().equalsIgnoreCase(flagName) && !flag.toString().toLowerCase().startsWith(flagName.toLowerCase())) continue;
            match = flag;
            flagName = flag.toString();
            break;
        }
        if (match == null) {
            lwc.sendLocale(sender, "protection.flag.invalidflag", "flag", flagName);
            return;
        }
        if (match.isRestricted() && !lwc.isAdmin(player.getBukkitPlayer())) {
            lwc.sendLocale(player, "protection.accessdenied", new Object[0]);
            return;
        }
        if (type.equals("on") || type.equals("true") || type.equals("yes")) {
            internalType = "+";
        } else if (type.equals("off") || type.equals("false") || type.equals("no")) {
            internalType = "-";
        } else {
            lwc.sendLocale(sender, "protection.flag.invalidtype", "type", type);
            return;
        }
        Action action = new Action();
        action.setName("flag");
        action.setPlayer(player);
        action.setData(internalType + flagName);
        player.removeAllActions();
        player.addAction(action);
        lwc.sendLocale(sender, "protection.flag.finalize", new Object[0]);
    }
}

