/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Chest;

public class BlockUtil {
    public static Block findAdjacentDoubleChest(Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Chest)) {
            return null;
        }
        Chest chestData = (Chest)blockData;
        if (chestData.getType() != Chest.Type.SINGLE) {
            Block face;
            BlockFace chestFace = chestData.getFacing();
            if (chestFace == BlockFace.WEST) {
                chestFace = BlockFace.NORTH;
            } else if (chestFace == BlockFace.NORTH) {
                chestFace = BlockFace.EAST;
            } else if (chestFace == BlockFace.EAST) {
                chestFace = BlockFace.SOUTH;
            } else if (chestFace == BlockFace.SOUTH) {
                chestFace = BlockFace.WEST;
            }
            if (chestData.getType() == Chest.Type.RIGHT) {
                chestFace = chestFace.getOppositeFace();
            }
            if ((face = block.getRelative(chestFace)).getType() == block.getType()) {
                return face;
            }
        }
        return null;
    }

    public static Block findAdjacentBedPart(Block block) {
        Block relativeBlock;
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Bed)) {
            return null;
        }
        Bed bedData = (Bed)blockData;
        BlockFace bedFace = bedData.getFacing();
        if (bedData.getPart() == Bed.Part.HEAD) {
            bedFace = bedFace.getOppositeFace();
        }
        if ((relativeBlock = block.getRelative(bedFace)).getType() == block.getType()) {
            return relativeBlock;
        }
        return null;
    }
}

