/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.redstone;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCRedstoneEvent;
import com.griefcraft.util.ProtectionFinder;
import com.griefcraft.util.matchers.DoorMatcher;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;

public class RedstoneModule
extends JavaModule {
    @Override
    public void onRedstone(LWCRedstoneEvent event) {
        if (event.isCancelled()) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        ProtectionFinder finder = protection.getProtectionFinder();
        if (finder != null) {
            for (BlockState found : finder.getBlocks()) {
                if (!DoorMatcher.PRESSURE_PLATES.contains(found.getType())) continue;
                int x = found.getX();
                int y = found.getY();
                int z = found.getZ();
                Player player = lwc.findPlayer(found.getWorld(), x - 1, x + 1, y, y + 1, z - 1, z + 1);
                if (player == null) continue;
                if (!lwc.canAccessProtection(player, protection)) {
                    event.setCancelled(true);
                    continue;
                }
                return;
            }
        }
        boolean hasFlag = protection.hasFlag(Flag.Type.REDSTONE);
        boolean denyRedstone = lwc.getConfiguration().getBoolean("protections.denyRedstone", false);
        if (!hasFlag && denyRedstone || hasFlag && !denyRedstone) {
            event.setCancelled(true);
        }
    }
}

