/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.config;

import com.griefcraft.lwc.LWC;
import com.griefcraft.util.config.Configuration;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConfigUpdater {
    private static List<String> BLACKLIST = Arrays.asList("protections.blocks", "master", "groups", "players", "defaults");
    private final Map<String, Configuration> referenceConfigFileCache = new HashMap<String, Configuration>();

    private Map<String, Configuration> loadReferenceConfigFiles() throws IOException {
        if (this.referenceConfigFileCache.size() > 0) {
            return this.referenceConfigFileCache;
        }
        ZipFile jarFile = new ZipFile(URLDecoder.decode(LWC.getInstance().getPlugin().getFile().getPath(), "UTF-8"));
        Enumeration<? extends ZipEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry file = entries.nextElement();
            String name = file.getName();
            if (!name.startsWith("config/") || !name.endsWith(".yml")) continue;
            String realName = name.substring(name.indexOf(47) + 1);
            Configuration configuration = new Configuration(null);
            configuration.load(jarFile.getInputStream(file));
            this.referenceConfigFileCache.put(realName, configuration);
        }
        return this.referenceConfigFileCache;
    }

    public void update(Configuration configuration) {
        try {
            boolean contains;
            Map<String, Configuration> referenceFiles = this.loadReferenceConfigFiles();
            Configuration reference = referenceFiles.get(configuration.getFile().getName());
            if (reference == null) {
                return;
            }
            List<String> currentKeys = this.getKeysDepth2(configuration);
            List<String> referenceKeys = this.getKeysDepth2(reference);
            boolean modified = false;
            for (String key : referenceKeys) {
                contains = configuration.getProperty(key) != null;
                if (contains) continue;
                configuration.setProperty(key, reference.getProperty(key));
                modified = true;
            }
            for (String key : currentKeys) {
                contains = reference.getProperty(key) != null;
                if (contains) continue;
                configuration.removeProperty(key);
                modified = true;
            }
            if (modified) {
                configuration.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> getKeysDepth2(Configuration configuration) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : configuration.getKeys(null)) {
            if (BLACKLIST.contains(key)) continue;
            keys.add(key);
            for (String subkey : configuration.getKeys(key)) {
                String fullKey = key + "." + subkey;
                if (BLACKLIST.contains(fullKey)) continue;
                keys.add(fullKey);
            }
        }
        return keys;
    }
}

