/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.history;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.History;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.TimeUtil;
import java.util.Date;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HistoryModule
extends JavaModule {
    public static final int ITEMS_PER_PAGE = 15;

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != DEFAULT) {
            return;
        }
        if (!event.hasAction("history")) {
            return;
        }
        LWC lwc = event.getLWC();
        Player player = event.getPlayer();
        Protection protection = event.getProtection();
        this.historyTool(lwc, player, protection.getX(), protection.getY(), protection.getZ());
        event.setResult(Module.Result.CANCEL);
        lwc.removeModes((CommandSender)player);
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != DEFAULT) {
            return;
        }
        if (!event.hasAction("history")) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        this.historyTool(lwc, player, block.getX(), block.getY(), block.getZ());
        event.setResult(Module.Result.CANCEL);
        lwc.removeModes((CommandSender)player);
    }

    private void historyTool(LWC lwc, Player player, int x, int y, int z) {
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        Action action = lwcPlayer.getAction("history");
        if (action == null) {
            player.sendMessage("\u00a74History action is null!");
            return;
        }
        int page = Integer.parseInt(action.getData());
        List<History> relatedHistory = null;
        relatedHistory = lwc.isAdmin(player) ? lwc.getPhysicalDatabase().loadHistory(x, y, z) : lwc.getPhysicalDatabase().loadHistory(player.getName(), x, y, z);
        if (page < 0 || page >= relatedHistory.size()) {
            page = 0;
        }
        if (relatedHistory.size() == 0) {
            lwc.sendLocale((CommandSender)player, "lwc.noresults", new Object[0]);
            return;
        }
        History history = relatedHistory.get(page);
        if (history == null) {
            lwcPlayer.removeAllActions();
            lwcPlayer.sendMessage("Refusing to send null history object");
            return;
        }
        if (!lwc.isAdmin(player) && !history.getPlayer().equals(player.getName())) {
            return;
        }
        lwcPlayer.sendMessage("History tool: Page " + (page + 1) + "/" + relatedHistory.size());
        this.sendDetails((CommandSender)player, history);
        if (page >= relatedHistory.size()) {
            action.setData("0");
        } else {
            action.setData(Integer.toString(page + 1));
        }
    }

    public void sendHistoryList(CommandSender sender, List<History> relatedHistory, int page, int maxPages, int historyCount) {
        String format = "%4s%12s%12s%12s";
        LWC.getInstance().sendLocale(sender, "lwc.history.list", "header", String.format(format, "Id", "Player", "Type", "Status"), "size", relatedHistory.size(), "page", page, "totalpages", maxPages, "totalhistory", historyCount);
        for (History history : relatedHistory) {
            sender.sendMessage(String.format(format, new Object[]{"" + history.getId(), history.getPlayer(), history.getType(), history.getStatus()}));
        }
    }

    private void sendDetails(CommandSender sender, History history) {
        LWC lwc = LWC.getInstance();
        Protection protection = history.getProtection();
        if (history.hasKey("destroyer")) {
            protection = null;
        }
        lwc.sendLocale(sender, "lwc.history.details.header", new Object[]{"id", history.getId(), "player", history.getPlayer(), "location", String.format("[%d %d %d]", history.getX(), history.getY(), history.getZ()), "status", history.getStatus(), "type", history.getType(), "protection", protection == null ? "n/a" : protection, "creator", history.getString("creator"), "currencyname", lwc.getCurrency().getMoneyName()});
        if (history.hasKey("destroyer")) {
            lwc.sendLocale(sender, "lwc.history.details.destroyer", "player", history.getString("destroyer"));
        }
        sender.sendMessage(" ");
        if (history.hasKey("charge")) {
            lwc.sendLocale(sender, "lwc.history.details.econcharge", "charge", history.getDouble("charge"), "moneyname", lwc.getCurrency().getMoneyName(), "discount", (history.hasKey("discount") ? "\u00a74Yes" : "\u00a7eNo") + "\u00a7e" + " " + (history.hasKey("discountId") ? "(" + history.getString("discountId") + ")" : ""));
        }
        String creation = null;
        if (history.getTimestamp() > 0L) {
            creation = new Date(history.getTimestamp() * 1000L).toString();
        }
        lwc.sendLocale(sender, "lwc.history.details.dates", "date", creation == null ? "Unknown" : creation);
        if (creation != null) {
            lwc.sendLocale(sender, "lwc.history.details.timeago", "time", TimeUtil.timeToString(System.currentTimeMillis() / 1000L - history.getTimestamp()));
        }
        if (history.hasKey("destroyer")) {
            String destroyerTime = history.getString("destroyerTime");
            long destroyed = 0L;
            if (!destroyerTime.isEmpty()) {
                destroyed = Long.parseLong(destroyerTime);
            }
            String absoluteDestroyDate = destroyed > 0L ? new Date(destroyed * 1000L).toString() : "Unknown";
            String relativeDestroyDate = destroyed > 0L ? TimeUtil.timeToString(System.currentTimeMillis() / 1000L - destroyed) : "Unknown";
            lwc.sendLocale(sender, "lwc.history.details.destroyed", "date", absoluteDestroyDate);
            if (destroyed > 0L) {
                lwc.sendLocale(sender, "lwc.history.details.timeago", "time", relativeDestroyDate);
            }
        }
    }

    private void doDetailsCommand(LWCCommandEvent event) {
        int historyId;
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (args.length < 1) {
            lwc.sendSimpleUsage(sender, "/lwc details <HistoryId>");
            return;
        }
        try {
            historyId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            lwc.sendLocale(sender, "lwc.noresults", new Object[0]);
            return;
        }
        History history = lwc.getPhysicalDatabase().loadHistory(historyId);
        if (history == null) {
            lwc.sendLocale(sender, "lwc.noresults", new Object[0]);
            return;
        }
        if (!lwc.isAdmin(sender) && sender instanceof Player && !history.getPlayer().equalsIgnoreCase(((Player)sender).getName())) {
            lwc.sendLocale(sender, "lwc.noresults", new Object[0]);
            return;
        }
        this.sendDetails(sender, history);
    }

    private void doHistoryCommand(LWCCommandEvent event) {
        List<History> relatedHistory;
        String playerName;
        int pageCount;
        int historyCount;
        int page;
        boolean isWildcard;
        CommandSender sender;
        LWC lwc;
        block21: {
            lwc = event.getLWC();
            sender = event.getSender();
            String[] args = event.getArgs();
            event.setCancelled(true);
            isWildcard = false;
            page = 1;
            historyCount = 0;
            pageCount = 0;
            if (!(sender instanceof Player) && args.length == 0) {
                isWildcard = true;
            }
            playerName = null;
            if (args.length > 0) {
                try {
                    page = Integer.parseInt(args[0]);
                    if (args.length > 1) {
                        playerName = args[1];
                    }
                }
                catch (NumberFormatException e) {
                    playerName = args[0];
                    if (args.length <= 1) break block21;
                    try {
                        page = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (playerName != null) {
            if (!lwc.isAdmin(sender)) {
                lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
                return;
            }
            if (playerName.equals("*")) {
                isWildcard = true;
            }
        } else if (sender instanceof Player) {
            playerName = ((Player)sender).getName();
        }
        if (playerName == null) {
            if (!(sender instanceof Player)) {
                isWildcard = true;
            } else {
                playerName = ((Player)sender).getName();
            }
        }
        if (isWildcard) {
            relatedHistory = lwc.getPhysicalDatabase().loadHistory((page - 1) * 15, 15);
            historyCount = lwc.getPhysicalDatabase().getHistoryCount();
        } else {
            relatedHistory = lwc.getPhysicalDatabase().loadHistory(playerName, (page - 1) * 15, 15);
            historyCount = lwc.getPhysicalDatabase().getHistoryCount(playerName);
        }
        if (historyCount > 0) {
            pageCount = (int)Math.floor(historyCount / (page * 15));
            while (pageCount * 15 < historyCount) {
                ++pageCount;
            }
        }
        if (relatedHistory.size() == 0) {
            lwc.sendLocale(sender, "lwc.noresults", new Object[0]);
            return;
        }
        if (page > pageCount) {
            lwc.sendLocale(sender, "lwc.noresults", new Object[0]);
            return;
        }
        this.sendHistoryList(sender, relatedHistory, page, pageCount, historyCount);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.hasFlag("h", "history")) {
            this.doHistoryCommand(event);
        } else if (event.hasFlag("d", "details")) {
            this.doDetailsCommand(event);
        }
    }
}

