/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.model;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.util.StringUtil;
import java.util.Arrays;
import java.util.List;

public class History {
    private int id;
    private int protectionId;
    private Protection protection;
    private String player;
    private int x;
    private int y;
    private int z;
    private Type type = Type.TRANSACTION;
    private Status status = Status.INACTIVE;
    private String[] metadata = new String[0];
    private long timestamp;
    private boolean exists = false;
    private boolean modified = false;
    private boolean saving = false;

    public boolean wasModified() {
        return this.modified;
    }

    public Protection getProtection() {
        if (this.protection == null) {
            this.protection = LWC.getInstance().getPhysicalDatabase().loadProtection(this.protectionId);
        }
        return this.protection;
    }

    public void addMetaData(String data) {
        String[] temp = new String[this.metadata.length + 1];
        System.arraycopy(this.metadata, 0, temp, 0, this.metadata.length);
        temp[this.metadata.length] = data;
        this.metadata = temp;
        this.modified = true;
    }

    public boolean hasKey(String key) {
        return this.getMetaDataStartsWith(key + "=") != null;
    }

    public boolean getBoolean(String key) {
        String metadata = this.getMetaDataStartsWith(key + "=");
        return metadata != null && Boolean.parseBoolean(metadata.substring((key + "=").length()));
    }

    public String getString(String key) {
        String metadata = this.getMetaDataStartsWith(key + "=");
        if (metadata == null) {
            return "";
        }
        return metadata.substring((key + "=").length());
    }

    public int getInteger(String key) {
        String metadata = this.getMetaDataStartsWith(key + "=");
        if (metadata == null) {
            return 0;
        }
        return Integer.parseInt(metadata.substring((key + "=").length()));
    }

    public double getDouble(String key) {
        String metadata = this.getMetaDataStartsWith(key + "=");
        if (metadata == null) {
            return 0.0;
        }
        return Double.parseDouble(metadata.substring((key + "=").length()));
    }

    public String getMetaDataStartsWith(String startsWith) {
        for (String temp : this.metadata) {
            if (!temp.startsWith(startsWith)) continue;
            return temp;
        }
        return null;
    }

    public boolean removeMetaData(String data) {
        List<String> temp = Arrays.asList(this.metadata);
        int expected = this.metadata.length - 1;
        temp.remove(data);
        this.metadata = temp.toArray(new String[temp.size()]);
        this.modified = true;
        return this.metadata.length == expected;
    }

    public void setProtection(Protection protection) {
        if (protection == null) {
            return;
        }
        this.protection = protection;
        this.protectionId = protection.getId();
    }

    public boolean doesExist() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
        this.modified = true;
    }

    public String getSafeMetaData() {
        return StringUtil.join(this.metadata, 0, ",");
    }

    public void save() {
        if (!this.modified || this.saving) {
            return;
        }
        LWC.getInstance();
        Protection protection = this.getProtection();
        if (protection == null) {
            this.saveNow();
            return;
        }
        this.saving = true;
        protection.checkHistory(this);
        protection.save();
    }

    public void saveNow() {
        LWC.getInstance().getPhysicalDatabase().saveHistory(this);
        this.modified = false;
        this.saving = false;
    }

    public void sync() {
        this.save();
    }

    public void remove() {
        LWC.getInstance().getPhysicalDatabase().removeHistory(this.id);
        this.modified = false;
    }

    public int getId() {
        return this.id;
    }

    public int getProtectionId() {
        return this.protectionId;
    }

    public String getPlayer() {
        return this.player;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Type getType() {
        return this.type;
    }

    public Status getStatus() {
        return this.status;
    }

    public String[] getMetaData() {
        return this.metadata;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setId(int id) {
        this.id = id;
        this.exists = true;
        this.modified = true;
    }

    public void setProtectionId(int protectionId) {
        this.protectionId = protectionId;
        this.modified = true;
    }

    public void setPlayer(String player) {
        this.player = player;
        this.modified = true;
    }

    public void setX(int x) {
        this.x = x;
        this.modified = true;
    }

    public void setY(int y) {
        this.y = y;
        this.modified = true;
    }

    public void setZ(int z) {
        this.z = z;
        this.modified = true;
    }

    public void setType(Type type) {
        this.type = type;
        this.modified = true;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.modified = true;
    }

    public void setMetaData(String[] metadata) {
        this.metadata = metadata;
        this.modified = true;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.modified = true;
    }

    public static enum Status {
        ACTIVE,
        INACTIVE;

    }

    public static enum Type {
        TRANSACTION;

    }
}

