/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.info;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("info")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        String type = lwc.getPlugin().getMessageParser().parseMessage(protection.typeToString().toLowerCase(), new Object[0]);
        lwc.sendLocale((CommandSender)player, "lwc.info", "owner", protection.getFormattedOwnerPlayerName(), "type", type);
        if (protection.getType() == Protection.Type.PRIVATE || protection.getType() == Protection.Type.DONATION || protection.getType() == Protection.Type.SHOWCASE) {
            lwc.sendLocale((CommandSender)player, "lwc.acl", "size", protection.getPermissions().size());
            int index = 0;
            for (Permission permission : protection.getPermissions()) {
                if (index >= 9) break;
                player.sendMessage(permission.toString());
                ++index;
            }
            if (index == 0 && event.canAdmin()) {
                lwc.sendLocale((CommandSender)player, "lwc.acl.empty", new Object[0]);
            } else if (index >= 9) {
                lwc.sendLocale((CommandSender)player, "lwc.acl.limitreached", new Object[0]);
            }
            if (index > 0) {
                player.sendMessage("");
            }
        }
        if (lwc.isAdmin(player)) {
            lwc.sendLocale((CommandSender)player, "protection.interact.info.raw", "raw", protection.toString());
        } else {
            player.sendMessage(protection.toShortString());
        }
        lwc.removeModes(player);
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("info")) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        lwc.sendLocale((CommandSender)player, "protection.interact.error.notregistered", "block", LWC.materialToString(block));
        lwc.removeModes(player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("i", "info")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!(sender instanceof Player)) {
            return;
        }
        event.setCancelled(true);
        if (!lwc.hasPlayerPermission(sender, "lwc.info")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        LWCPlayer player = lwc.wrapPlayer(sender);
        String type = "info";
        if (args.length > 0) {
            type = args[0].toLowerCase();
        }
        if (type.equals("info")) {
            Action action = new Action();
            action.setName("info");
            action.setPlayer(player);
            player.removeAllActions();
            player.addAction(action);
            lwc.sendLocale(player, "protection.info.finalize", new Object[0]);
        } else if (type.equals("history")) {
            Action action = new Action();
            action.setName("history");
            action.setData("0");
            action.setPlayer(player);
            player.removeAllActions();
            player.addAction(action);
            lwc.sendLocale(player, "protection.info.finalize", new Object[0]);
        }
    }
}

