/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.unlock;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.util.StringUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnlockModule
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("u", "unlock")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            lwc.sendLocale(sender, "lwc.onlyrealplayers", new Object[0]);
            return;
        }
        if (!lwc.hasPlayerPermission(sender, "lwc.unlock")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        if (args.length < 1) {
            lwc.sendSimpleUsage(sender, "/lwc -u <Password>");
            return;
        }
        LWCPlayer player = lwc.wrapPlayer(sender);
        String password = StringUtil.join(args, 0);
        password = StringUtil.encrypt(password);
        Action action = player.getAction("interacted");
        if (action == null) {
            lwc.sendLocale(sender, "lwc.unlock.noselection", new Object[0]);
        } else {
            Protection protection = action.getProtection();
            if (protection == null) {
                lwc.logAndPrintInternalException(player.getBukkitPlayer(), "UNLOCK", null, protection);
                return;
            }
            if (protection.getType() != Protection.Type.PASSWORD) {
                lwc.sendLocale(player, "protection.unlock.notpassword", new Object[0]);
                return;
            }
            if (protection.getPassword().equals(password)) {
                player.addAccessibleProtection(protection);
                player.removeAction(action);
                lwc.sendLocale(player, "protection.unlock.password.valid", new Object[0]);
            } else {
                lwc.sendLocale(player, "protection.unlock.password.invalid", new Object[0]);
            }
        }
    }
}

