/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.ModuleException;
import com.griefcraft.util.Statistics;
import com.griefcraft.util.config.Configuration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public abstract class Database {
    public Type currentType;
    private Map<String, PreparedStatement> statementCache = new HashMap<String, PreparedStatement>();
    protected Connection connection = null;
    public static Type DefaultType = Type.NONE;
    private boolean connected = false;
    protected boolean loaded = false;
    protected String prefix = "";
    private boolean useStatementCache = true;

    public Database() {
        this.currentType = DefaultType;
        this.prefix = LWC.getInstance().getConfiguration().getString("database.prefix", "");
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    public Database(Type currentType) {
        this();
        this.currentType = currentType;
    }

    public void pingDatabase() {
        this.runAndIgnoreException(() -> {
            Statement stmt = this.connection.createStatement();
            stmt.executeQuery("SELECT 1;");
            stmt.close();
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected void printException(Exception exception) {
        throw new ModuleException(exception);
    }

    public boolean connect() throws SQLException {
        if (this.connection != null) {
            return true;
        }
        if (this.currentType == null || this.currentType == Type.NONE) {
            this.log("Invalid database engine");
            return false;
        }
        try {
            if (this.currentType == Type.MySQL) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else {
                Class.forName("org.sqlite.JDBC");
            }
        }
        catch (ClassNotFoundException e) {
            LWC.getInstance().getPlugin().getLogger().log(Level.SEVERE, "Could not load the database driver!", e);
        }
        Properties properties = new Properties();
        if (this.currentType == Type.MySQL) {
            LWC lwc = LWC.getInstance();
            properties.put("user", lwc.getConfiguration().getString("database.username"));
            properties.put("password", lwc.getConfiguration().getString("database.password"));
        }
        this.statementCache.clear();
        try {
            this.connection = DriverManager.getConnection("jdbc:" + this.currentType.toString().toLowerCase() + ":" + this.getDatabasePath(), properties);
            this.connection.setAutoCommit(false);
            this.connected = true;
            return true;
        }
        catch (SQLException e) {
            this.log("Failed to connect to " + String.valueOf((Object)this.currentType) + ": " + e.getErrorCode() + " - " + e.getMessage());
            if (e.getCause() != null) {
                this.log("Connection failure cause: " + e.getCause().getMessage());
            }
            throw e;
        }
    }

    public void dispose() {
        this.statementCache.clear();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connection = null;
    }

    protected <T> T runAndIgnoreException(SQLCallable<T> callable) {
        try {
            return this.run(callable);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    protected <T> T runAndLogException(SQLCallable<T> callable) {
        try {
            return this.run(callable);
        }
        catch (SQLException e) {
            LWC.getInstance().getPlugin().getLogger().log(Level.SEVERE, "Database Exception", e);
            return null;
        }
    }

    protected <T> T runAndThrowModuleExceptionIfFailing(SQLCallable<T> callable) {
        try {
            return this.run(callable);
        }
        catch (SQLException e) {
            throw new ModuleException(e);
        }
    }

    protected synchronized <T> T run(SQLCallable<T> callable) throws SQLException {
        int fails = 0;
        while (true) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.connect();
                }
                T rv = callable.call();
                this.connection.commit();
                return rv;
            }
            catch (SQLException e) {
                ++fails;
                if (this.connection != null) {
                    try {
                        if (!this.connection.isClosed()) {
                            this.connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.dispose();
                if (fails < 3) continue;
                throw e;
            }
            break;
        }
    }

    protected void runAndIgnoreException(SQLRunnable runnable) {
        try {
            this.run(runnable);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void runAndLogException(SQLRunnable runnable) {
        try {
            this.run(runnable);
        }
        catch (SQLException e) {
            LWC.getInstance().getPlugin().getLogger().log(Level.SEVERE, "Database Exception", e);
        }
    }

    protected void runAndThrowModuleExceptionIfFailing(SQLRunnable runnable) {
        try {
            this.run(runnable);
        }
        catch (SQLException e) {
            throw new ModuleException(e);
        }
    }

    protected synchronized void run(SQLRunnable runnable) throws SQLException {
        int fails = 0;
        while (true) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.connect();
                }
                runnable.run();
                this.connection.commit();
                return;
            }
            catch (SQLException e) {
                ++fails;
                if (this.connection != null) {
                    try {
                        if (!this.connection.isClosed()) {
                            this.connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.dispose();
                if (fails < 3) continue;
                throw e;
            }
            break;
        }
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected String getDatabasePath() {
        Configuration lwcConfiguration = LWC.getInstance().getConfiguration();
        if (this.currentType == Type.MySQL) {
            return "//" + lwcConfiguration.getString("database.host") + "/" + lwcConfiguration.getString("database.database");
        }
        return lwcConfiguration.getString("database.path");
    }

    public Type getType() {
        return this.currentType;
    }

    public abstract void load();

    protected void log(String str) {
        LWC.getInstance().log(str);
    }

    protected PreparedStatement prepare(String sql) throws SQLException {
        return this.prepare(sql, false);
    }

    protected PreparedStatement prepare(String sql, boolean returnGeneratedKeys) throws SQLException {
        if (this.connection == null) {
            return null;
        }
        if (this.useStatementCache && this.statementCache.containsKey(sql)) {
            Statistics.addQuery();
            return this.statementCache.get(sql);
        }
        PreparedStatement preparedStatement = returnGeneratedKeys ? this.connection.prepareStatement(sql, 1) : this.connection.prepareStatement(sql);
        this.statementCache.put(sql, preparedStatement);
        Statistics.addQuery();
        return preparedStatement;
    }

    protected boolean addColumn(String table, String column, String type) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " ADD " + column + " " + type);
    }

    protected boolean dropColumn(String table, String column) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " DROP COLUMN " + column);
    }

    protected boolean renameTable(String table, String newName) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " RENAME TO " + newName);
    }

    protected boolean dropTable(String table) {
        return this.executeUpdateNoException("DROP TABLE " + table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeUpdateNoException(String query) {
        Statement statement = null;
        boolean exception = false;
        try {
            statement = this.connection.createStatement();
            statement.executeUpdate(query);
        }
        catch (SQLException e) {
            exception = true;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return exception;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean useStatementCache() {
        return this.useStatementCache;
    }

    public void setUseStatementCache(boolean useStatementCache) {
        this.useStatementCache = useStatementCache;
    }

    public static enum Type {
        MySQL,
        SQLite,
        NONE;


        public static Type matchType(String str) {
            for (Type type : Type.values()) {
                if (!type.toString().equalsIgnoreCase(str)) continue;
                return type;
            }
            return null;
        }
    }

    public static interface SQLRunnable {
        public void run() throws SQLException;
    }

    public static interface SQLCallable<T> {
        public T call() throws SQLException;
    }
}

