/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.free;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.ConfirmAction;
import com.griefcraft.model.History;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FreeModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("free")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        if (!lwc.isAdmin(player) && Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "readonly-remove"))) {
            lwc.sendLocale((CommandSender)player, "protection.accessdenied", new Object[0]);
            return;
        }
        if (lwc.hasAdminPermission((CommandSender)player, "lwc.admin.remove") || lwc.canDestoryProtection(player, protection)) {
            LWCProtectionDestroyEvent evt = new LWCProtectionDestroyEvent(player, protection, LWCProtectionDestroyEvent.Method.COMMAND, true, true);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (!evt.isCancelled()) {
                for (History history : protection.getRelatedHistory(History.Type.TRANSACTION)) {
                    if (history.getStatus() != History.Status.ACTIVE) continue;
                    history.addMetaData("destroyer=" + player.getName());
                    history.addMetaData("destroyerTime=" + System.currentTimeMillis() / 1000L);
                }
                protection.remove();
                lwc.sendLocale((CommandSender)player, "protection.interact.remove.finalize", "block", LWC.materialToString(protection.getBlockMaterial()));
            }
            lwc.removeModes((CommandSender)player);
        } else {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.notowner", "block", LWC.materialToString(protection.getBlockMaterial()));
            lwc.removeModes((CommandSender)player);
        }
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (!event.hasAction("free")) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        lwc.sendLocale((CommandSender)player, "protection.interact.error.notregistered", "block", LWC.materialToString(block));
        lwc.removeModes((CommandSender)player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("r", "remove")) {
            return;
        }
        final LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!(sender instanceof Player)) {
            return;
        }
        event.setCancelled(true);
        if (!lwc.hasPlayerPermission(sender, "lwc.remove")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        if (args.length < 1) {
            lwc.sendSimpleUsage(sender, "/lwc -r <protection" + (lwc.hasPermission(sender, "lwc.removeall", new String[0]) ? "|allprotections" : "") + "|modes>");
            return;
        }
        String type = args[0].toLowerCase();
        final LWCPlayer player = lwc.wrapPlayer(sender);
        if (type.equals("protection") || type.equals("chest") || type.equals("furnace") || type.equals("dispenser")) {
            Action action = new Action();
            action.setName("free");
            action.setPlayer(player);
            player.removeAllActions();
            player.addAction(action);
            lwc.sendLocale(sender, "protection.remove.protection.finalize", new Object[0]);
        } else if (type.equals("modes")) {
            player.disableAllModes();
            player.removeAllActions();
            lwc.sendLocale(sender, "protection.remove.modes.finalize", new Object[0]);
        } else if (type.equals("allprotections") && lwc.hasPermission(sender, "lwc.removeall", new String[0])) {
            lwc.sendLocale(player, "lwc.remove.allprotections", new Object[0]);
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    for (Protection protection : lwc.getPhysicalDatabase().loadProtectionsByPlayer(player.getUniqueId().toString())) {
                        protection.remove();
                    }
                    lwc.sendLocale(player, "lwc.remove.allprotections.success", new Object[0]);
                }
            };
            ConfirmAction action = new ConfirmAction(callback);
            action.setPlayer(player);
            player.addAction(action);
        } else {
            lwc.sendSimpleUsage(sender, "/lwc -r <protection" + (lwc.hasPermission(sender, "lwc.removeall", new String[0]) ? "|allprotections" : "") + "|modes>");
        }
    }
}

