/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.matchers;

import com.griefcraft.lwc.LWC;
import com.griefcraft.util.ProtectionFinder;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;

public class DoorMatcher
implements ProtectionFinder.Matcher {
    public static final Set<Material> PROTECTABLES_DOORS = EnumSet.noneOf(Material.class);
    public static final Set<Material> WOODEN_DOORS = EnumSet.noneOf(Material.class);
    public static final Set<Material> PRESSURE_PLATES = EnumSet.noneOf(Material.class);
    public static final Set<Material> FENCE_GATES = EnumSet.noneOf(Material.class);
    public static final Set<Material> TRAPDOORS = EnumSet.noneOf(Material.class);
    private static final BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH};

    @Override
    public boolean matches(ProtectionFinder finder) {
        BlockState baseBlockState = finder.getBaseBlock();
        Block block = baseBlockState.getBlock();
        Block aboveBaseBlock = block.getRelative(BlockFace.UP);
        Block aboveAboveBaseBlock = aboveBaseBlock.getRelative(BlockFace.UP);
        if (PRESSURE_PLATES.contains(baseBlockState.getType()) || PRESSURE_PLATES.contains(aboveBaseBlock.getType())) {
            Block pressurePlate = PRESSURE_PLATES.contains(baseBlockState.getType()) ? block : aboveBaseBlock;
            for (BlockFace face : faces) {
                ProtectionFinder doorFinder;
                Block relative = pressurePlate.getRelative(face);
                if (!PROTECTABLES_DOORS.contains(relative.getType()) || !(doorFinder = new ProtectionFinder(LWC.getInstance())).matchBlocks(relative)) continue;
                for (BlockState found : doorFinder.getBlocks()) {
                    finder.addBlock(found);
                }
                finder.addBlock(pressurePlate);
                return true;
            }
        }
        if (PROTECTABLES_DOORS.contains(aboveAboveBaseBlock.getType()) && PROTECTABLES_DOORS.contains(aboveBaseBlock.getType())) {
            finder.addBlock(aboveAboveBaseBlock);
            finder.addBlock(aboveBaseBlock);
            this.findPressurePlate(finder, aboveBaseBlock);
            return true;
        }
        if (PROTECTABLES_DOORS.contains(aboveBaseBlock.getType())) {
            finder.addBlock(aboveBaseBlock);
            finder.addBlock(block.getRelative(BlockFace.DOWN));
            this.findPressurePlate(finder, block);
            return true;
        }
        if (PROTECTABLES_DOORS.contains(baseBlockState.getType())) {
            Block bottomHalf = block.getRelative(BlockFace.DOWN);
            finder.addBlock(bottomHalf);
            finder.addBlock(bottomHalf.getRelative(BlockFace.DOWN));
            this.findPressurePlate(finder, bottomHalf);
            return true;
        }
        return false;
    }

    private void findPressurePlate(ProtectionFinder finder, Block block) {
        for (BlockFace face : faces) {
            Block relative = block.getRelative(face);
            if (!PRESSURE_PLATES.contains(relative.getType())) continue;
            finder.addBlock(relative);
        }
    }

    static {
        for (Material m : Material.values()) {
            if (m.name().endsWith("_DOOR")) {
                PROTECTABLES_DOORS.add(m);
                if (m == Material.IRON_DOOR) continue;
                WOODEN_DOORS.add(m);
                continue;
            }
            if (m.name().endsWith("_TRAPDOOR") && m != Material.IRON_TRAPDOOR) {
                TRAPDOORS.add(m);
                continue;
            }
            if (m.name().endsWith("_FENCE_GATE")) {
                FENCE_GATES.add(m);
                continue;
            }
            if (!m.name().endsWith("_PRESSURE_PLATE")) continue;
            PRESSURE_PLATES.add(m);
        }
    }
}

