/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    protected int maxCapacity;
    private long reads = 0L;
    private long writes = 0L;

    public LRUCache(int maxCapacity) {
        super(maxCapacity, 0.75f, true);
        this.maxCapacity = maxCapacity;
    }

    @Override
    public V get(Object key) {
        ++this.reads;
        return super.get(key);
    }

    @Override
    public V put(K key, V value) {
        ++this.writes;
        return super.put(key, value);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCapacity;
    }

    public long getReads() {
        return this.reads;
    }

    public long getWrites() {
        return this.writes;
    }
}

