/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientVelocity;
import de.cubeside.connection.PlayerPropertiesAPI;
import de.cubeside.connection.PlayerPropertiesImplementation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@Plugin(id="globalconnectionvelocity", name="Global Connection Velocity", version="0.0.1-SNAPSHOT", url="https://cubeside.de", description="GlobalClient", authors={"Cubeside"})
public class GlobalClientPlugin {
    private GlobalClientVelocity globalClient;
    private PlayerPropertiesImplementation propertiesAPI;
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private CommentedConfigurationNode configuration;

    @Inject
    public GlobalClientPlugin(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.saveDefaultConfig();
        this.globalClient = new GlobalClientVelocity(this);
        this.reconnectClient();
        this.propertiesAPI = new PlayerPropertiesImplementation(this);
        CommandManager commandManager = this.server.getCommandManager();
        CommandMeta commandMeta = commandManager.metaBuilder("velocityglobalclientreload").plugin((Object)this).build();
        commandManager.register(commandMeta, (Command)new ReloadCommand());
    }

    private void saveDefaultConfig() {
        try {
            Path configFile = this.dataDirectory.resolve("config.yml");
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectory(this.dataDirectory, new FileAttribute[0]);
                if (Files.notExists(configFile, new LinkOption[0])) {
                    try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("config.yml");){
                        Files.copy(stream, configFile, new CopyOption[0]);
                    }
                }
            }
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configFile)).build();
            this.configuration = (CommentedConfigurationNode)loader.load();
        }
        catch (IOException e) {
            this.logger.error("Error while loading config", (Throwable)e);
        }
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.globalClient != null) {
            this.globalClient.shutdown();
        }
        this.globalClient = null;
    }

    public void reconnectClient() {
        String account = ((CommentedConfigurationNode)this.configuration.node(new Object[]{"client", "account"})).getString();
        String password = ((CommentedConfigurationNode)this.configuration.node(new Object[]{"client", "password"})).getString();
        String host = ((CommentedConfigurationNode)this.configuration.node(new Object[]{"server", "host"})).getString();
        int port = ((CommentedConfigurationNode)this.configuration.node(new Object[]{"server", "port"})).getInt();
        this.globalClient.setServer(host, port, account, password);
    }

    public ConnectionAPI getConnectionAPI() {
        return this.globalClient;
    }

    public PlayerPropertiesAPI getPropertiesAPI() {
        return this.propertiesAPI;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public class ReloadCommand
    implements SimpleCommand {
        public void execute(SimpleCommand.Invocation invocation) {
            if (!invocation.source().hasPermission("globalclient.reload")) {
                return;
            }
            GlobalClientPlugin.this.reconnectClient();
        }

        public boolean hasPermission(SimpleCommand.Invocation invocation) {
            return invocation.source().hasPermission("globalclient.reload");
        }
    }
}

