/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.plugin;

import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.plugin.Plugin;
import de.cubeside.globalserver.plugin.PluginClassLoader;
import de.cubeside.globalserver.plugin.PluginContext;
import de.cubeside.globalserver.plugin.PluginDependency;
import de.cubeside.globalserver.plugin.PluginDescription;
import de.cubeside.globalserver.plugin.PluginLoadException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PluginManager {
    public static final Logger LOGGER = LogManager.getLogger("PluginManager");
    private static final Function<PluginContext, HashSet<PluginContext>> HASH_SET_CREATOR = c -> new HashSet();
    private final GlobalServer server;
    private LinkedHashMap<String, PluginContext> pluginContexts;
    private Collection<Plugin> plugins;

    PluginManager(GlobalServer server) {
        this.server = server;
    }

    void loadPlugins() throws PluginLoadException {
        LOGGER.info("Resolving plugins..");
        File[] pluginFiles = this.server.getPluginFolder().listFiles(f -> f.isFile() && f.getName().endsWith(".jar"));
        ArrayList<PluginContext> loadedContexts = new ArrayList<PluginContext>();
        for (File jarFile : pluginFiles) {
            PluginDescription description = new PluginDescription(jarFile);
            loadedContexts.add(new PluginContext(this.server, description));
        }
        loadedContexts.sort((f1, f2) -> f1.getDescription().getName().compareTo(f2.getDescription().getName()));
        LinkedHashMap<String, PluginContext> pluginContexts = new LinkedHashMap<String, PluginContext>();
        for (PluginContext context : loadedContexts) {
            if (pluginContexts.put(context.getDescription().getName(), context) == null) continue;
            throw new PluginLoadException("Duplicate plugin " + context.getDescription().getName());
        }
        HashMap<PluginContext, HashSet<PluginContext>> allLoadBefore = new HashMap<PluginContext, HashSet<PluginContext>>();
        for (Object context : pluginContexts.values()) {
            HashSet<PluginContext> dependencies = new HashSet<PluginContext>();
            for (PluginDependency pluginDependency : ((PluginContext)context).getDescription().getDependencies()) {
                PluginContext resolvedDependency = (PluginContext)pluginContexts.get(pluginDependency.plugin());
                if (resolvedDependency != null) {
                    Semver dependencyVersion = resolvedDependency.getDescription().getVersion();
                    boolean matchesAny = false;
                    for (Requirement requiredVersion : pluginDependency.version()) {
                        if (!dependencyVersion.satisfies(requiredVersion)) continue;
                        matchesAny = true;
                        break;
                    }
                    if (!matchesAny) {
                        throw new PluginLoadException("Plugin " + resolvedDependency.getDescription().getName() + " does not have the required version for " + ((PluginContext)context).getDescription().getName() + ": " + Arrays.toString(pluginDependency.version()));
                    }
                    this.addDependenciesRecursive(pluginContexts, dependencies, resolvedDependency, pluginDependency.loadOrder(), (PluginContext)context, allLoadBefore);
                    continue;
                }
                if (pluginDependency.type() != PluginDependency.Type.REQUIRED) continue;
                throw new PluginLoadException("Plugin " + ((PluginContext)context).getDescription().getName() + " is missing the required dependency " + pluginDependency.plugin());
            }
            ArrayList<PluginClassLoader> dependencyLoaders = new ArrayList<PluginClassLoader>();
            for (PluginContext otherContext : dependencies) {
                if (otherContext == context) continue;
                dependencyLoaders.add(otherContext.getClassLoader());
            }
            ((PluginContext)context).getClassLoader().setDependencyClassLoades(dependencyLoaders);
        }
        ArrayList<PluginContext> notOrderedIn = new ArrayList<PluginContext>();
        for (PluginContext context : pluginContexts.values()) {
            HashSet deps = (HashSet)allLoadBefore.get(context);
            if (deps != null && deps.contains(context)) {
                throw new PluginLoadException("Circular dependencies for plugin " + context.getDescription().getName());
            }
            notOrderedIn.add(context);
        }
        HashSet<PluginContext> orderedIn = new HashSet<PluginContext>();
        LinkedHashMap<String, PluginContext> newPluginContexts = new LinkedHashMap<String, PluginContext>();
        while (!notOrderedIn.isEmpty()) {
            Iterator it = notOrderedIn.iterator();
            block10: while (it.hasNext()) {
                PluginContext pluginContext = (PluginContext)it.next();
                HashSet loadBeforeThis = (HashSet)allLoadBefore.get(pluginContext);
                if (loadBeforeThis != null) {
                    for (PluginContext e : loadBeforeThis) {
                        if (orderedIn.contains(e)) continue;
                        continue block10;
                    }
                }
                orderedIn.add(pluginContext);
                newPluginContexts.put(pluginContext.getDescription().getName(), pluginContext);
                it.remove();
            }
        }
        pluginContexts = newPluginContexts;
        for (PluginContext pluginContext : pluginContexts.values()) {
            try {
                LOGGER.info("Loading plugin " + pluginContext.getDescription().getName());
                pluginContext.createMainClassInstance();
            }
            catch (Exception e) {
                throw new PluginLoadException("Could not load the plugin " + pluginContext.getDescription().getName(), e);
            }
        }
        this.pluginContexts = pluginContexts;
        this.plugins = Collections.unmodifiableList(pluginContexts.values().stream().map(c -> c.getMainClassInstance()).toList());
    }

    void shutdown() {
        if (this.pluginContexts != null) {
            for (PluginContext context : this.pluginContexts.values()) {
                try {
                    context.getClassLoader().close();
                }
                catch (IOException e) {
                    LOGGER.error("Could not close ClassLoader for " + context.getDescription().getName(), (Throwable)e);
                }
            }
        }
    }

    private void addDependenciesRecursive(HashMap<String, PluginContext> pluginContexts, HashSet<PluginContext> dependencies, PluginContext dependency, PluginDependency.LoadOrder loadOrder, PluginContext initialPlugin, HashMap<PluginContext, HashSet<PluginContext>> allLoadBefore) {
        if (loadOrder == PluginDependency.LoadOrder.BEFORE) {
            set = allLoadBefore.computeIfAbsent(initialPlugin, HASH_SET_CREATOR);
            set.add(dependency);
        } else if (loadOrder == PluginDependency.LoadOrder.AFTER) {
            set = allLoadBefore.computeIfAbsent(dependency, HASH_SET_CREATOR);
            set.add(initialPlugin);
        }
        if (dependencies.add(dependency)) {
            for (PluginDependency nextDependency : dependency.getDescription().getDependencies()) {
                PluginContext resolvedDependency = pluginContexts.get(nextDependency.plugin());
                if (resolvedDependency == null) continue;
                this.addDependenciesRecursive(pluginContexts, dependencies, resolvedDependency, nextDependency.loadOrder() == loadOrder ? loadOrder : PluginDependency.LoadOrder.ANY, initialPlugin, allLoadBefore);
            }
        }
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins;
    }

    public Plugin getPlugin(String name) {
        PluginContext context = this.pluginContexts.get(name);
        return context != null ? context.getMainClassInstance() : null;
    }
}

