/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin;

import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;

public interface Codec<T> {
    public String className();

    public boolean canDecode(Column var1, Class<?> var2);

    public boolean canEncode(Object var1);

    public T decodeText(ReadableByteBuf var1, int var2, Column var3, Calendar var4) throws SQLDataException;

    public T decodeBinary(ReadableByteBuf var1, int var2, Column var3, Calendar var4) throws SQLDataException;

    public void encodeText(Writer var1, Context var2, Object var3, Calendar var4, Long var5) throws IOException, SQLException;

    public void encodeBinary(Writer var1, Object var2, Calendar var3, Long var4) throws IOException, SQLException;

    default public boolean canEncodeLongData() {
        return false;
    }

    default public void encodeLongData(Writer encoder, T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    default public byte[] encodeData(T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    public int getBinaryEncodeType();
}

