/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import de.cubeside.globalserver.ArgsParser;
import de.cubeside.globalserver.Console;
import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.ServerCommand;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class JLineConsole
implements Console {
    private static final Logger logger = LogManager.getLogger("Console");
    private GlobalServer server;
    private SimpleConsoleReaderThread thread;
    private volatile boolean running;
    private LineReader lineReader;

    public JLineConsole(GlobalServer server) {
        this.server = server;
        this.running = true;
        logger.log(Level.INFO, "Starting console...");
        try {
            Terminal terminal = TerminalBuilder.builder().build();
            this.lineReader = LineReaderBuilder.builder().terminal(terminal).history(new DefaultHistory()).completer(new ConsoleCompleter()).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).build();
        }
        catch (IOException e) {
            logger.log(Level.ERROR, "Error creating console", (Throwable)e);
        }
        this.thread = new SimpleConsoleReaderThread();
        this.thread.setName("console");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void appendOutput(String message) {
        this.lineReader.printAbove(message);
    }

    @Override
    public void stop() {
        this.running = false;
    }

    private class SimpleConsoleReaderThread
    extends Thread {
        private SimpleConsoleReaderThread() {
        }

        @Override
        public void run() {
            while (JLineConsole.this.running) {
                try {
                    String line = JLineConsole.this.lineReader.readLine("> ");
                    JLineConsole.this.server.processCommand(line == null ? "stop" : line);
                }
                catch (UserInterruptException e) {
                    logger.log(Level.ERROR, "User Interrupt", (Throwable)e);
                }
                catch (EndOfFileException e) {
                    JLineConsole.this.running = false;
                }
            }
            logger.log(Level.INFO, "Console shutdown completed.");
        }
    }

    private class ConsoleCompleter
    implements Completer {
        private ConsoleCompleter() {
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            block5: {
                block4: {
                    if (line.wordIndex() != 0) break block4;
                    for (String commandName : JLineConsole.this.server.getCommandNames()) {
                        candidates.add(new Candidate(commandName));
                    }
                    break block5;
                }
                List<String> words = line.words();
                ServerCommand command = JLineConsole.this.server.getCommand(words.get(0));
                if (command == null) break block5;
                int wordCount = line.wordIndex();
                String[] wordsArray = new String[wordCount];
                for (int i = 0; i < wordCount; ++i) {
                    wordsArray[i] = words.get(i + 1);
                }
                Collection<String> result = command.tabComplete(JLineConsole.this.server, new ArgsParser(wordsArray));
                if (result != null && !result.isEmpty()) {
                    for (String suggestion : result) {
                        candidates.add(new Candidate(suggestion));
                    }
                }
            }
        }
    }
}

