/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.NamedChatColor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtilCore {
    public static final ToIntFunction<String> CASE_IGNORING_HASHER = s2 -> {
        if (s2 == null) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            hash = 31 * hash + Character.toLowerCase((int)c);
        }
        return hash;
    };
    public static final BiPredicate<String, String> CASE_IGNORING_EQUALITY = (s1, s2) -> s1 == null ? s2 == null : s1.equalsIgnoreCase((String)s2);
    public static final char COLOR_CHAR = '\u00a7';
    public static final Pattern COLOR_CHAR_PATTERN = Pattern.compile("\\\u00a7");
    public static final Pattern COLOR_CODES_PATTERN = Pattern.compile("\\\u00a7([0-9a-fk-or]|(x(\u00a7[0-9a-f]){6}))", 2);

    public static String filterIncompleteSurrogatePairs(String input) {
        StringBuilder sb = null;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c < '\ud800' || c > '\udfff') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < input.length()) {
                char next = input.charAt(i + 1);
                if (next >= '\udc00' && next <= '\udfff') {
                    ++i;
                    if (Character.isDefined(Character.toCodePoint(c, next))) {
                        if (sb == null) continue;
                        sb.append(c);
                        sb.append(next);
                        continue;
                    }
                    if (sb != null) continue;
                    sb = new StringBuilder();
                    sb.append(input, 0, i - 1);
                    continue;
                }
                if (sb != null) continue;
                sb = new StringBuilder();
                sb.append(input, 0, i);
                continue;
            }
            if (sb != null) continue;
            sb = new StringBuilder();
            sb.append(input, 0, i);
        }
        return sb != null ? sb.toString() : input;
    }

    public static String filterControlCharacters(String input, boolean allowNewline) {
        StringBuilder sb = null;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c < ' ' && (!allowNewline || c != '\n') || c >= '\u007f' && c < '\u00a0') {
                if (sb != null) continue;
                sb = new StringBuilder();
                sb.append(input, 0, i);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : input;
    }

    public static int findMatchingBrace(String s2) {
        return StringUtilCore.findMatchingCharacter(s2, '{', '}', '\\');
    }

    public static int findMatchingCharacter(String s2, char opening, char closing, char escaping) {
        if (opening != closing && s2.charAt(0) != opening) {
            throw new IllegalArgumentException("string doesn't start with opening");
        }
        int open = 1;
        for (int i = 1; i < s2.length(); ++i) {
            char current = s2.charAt(i);
            if (current == closing) {
                if (--open != 0) continue;
                return i;
            }
            if (current == opening) {
                ++open;
                continue;
            }
            if (current != escaping) continue;
            ++i;
        }
        return -1;
    }

    public static ArrayList<String> copyPartialMatches(String token, Collection<String> unfiltered) {
        return unfiltered.stream().filter(s2 -> StringUtilCore.startsWithIgnoreCase(s2, token)).collect(Collectors.toCollection(() -> new ArrayList()));
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.length() >= prefix.length() && string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean startsWithIgnoreCase(String string, int start, String prefix) {
        return string.length() >= prefix.length() && string.regionMatches(true, start, prefix, 0, prefix.length());
    }

    public static String convertColors(String text) {
        return StringUtilCore.parseColors(text, false);
    }

    public static String stripColors(String text) {
        return StringUtilCore.parseColors(text, true);
    }

    private static String parseColors(String text, boolean remove) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char next;
            char current = text.charAt(i);
            if (current == '&' && i + 1 < len && (NamedChatColor.getByCode(next = text.charAt(i + 1)) != null || next == '&' || next == 'x')) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(text, 0, i);
                }
                ++i;
                if (next != '&') {
                    if (next == 'x') {
                        Integer hex = StringUtilCore.parseHexColor(text, i + 1);
                        if (hex == null) {
                            builder.append(current).append(next);
                            continue;
                        }
                        if (!remove) {
                            String hexString = Integer.toString(hex, 16);
                            builder.append('\u00a7').append('x');
                            int offset = hexString.length() - 6;
                            for (int j = 0; j < 6; ++j) {
                                int charPos = j + offset;
                                char c = charPos >= 0 ? (char)hexString.charAt(charPos) : (char)'0';
                                builder.append('\u00a7').append(c);
                            }
                        }
                        i += 6;
                        continue;
                    }
                    if (remove) continue;
                    builder.append('\u00a7').append(next);
                    continue;
                }
            }
            if (builder == null) continue;
            builder.append(current);
        }
        return builder == null ? text : builder.toString();
    }

    public static Integer parseHexColor(String text, int startIndex) {
        if (text.length() - startIndex < 6) {
            return null;
        }
        StringBuilder hexString = new StringBuilder("");
        for (int i = 0; i < 6; ++i) {
            char c = Character.toLowerCase(text.charAt(i + startIndex));
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f')) {
                return null;
            }
            hexString.append(c);
        }
        return Integer.parseInt(hexString.toString(), 16);
    }

    public static String revertColors(String converted) {
        if (converted == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < converted.length(); ++i) {
            char c = converted.charAt(i);
            if (c == '\u00a7') {
                if (converted.length() > i + 1 && converted.charAt(i + 1) == 'x') {
                    if (i + 14 > converted.length()) {
                        builder.append("&");
                        continue;
                    }
                    String hexString = converted.substring(i, i + 14);
                    if (!COLOR_CODES_PATTERN.matcher(hexString).matches()) {
                        builder.append("&");
                        continue;
                    }
                    builder.append("&").append(COLOR_CHAR_PATTERN.matcher(hexString).replaceAll(""));
                    i += 13;
                    continue;
                }
                builder.append("&");
                continue;
            }
            if (c == '&') {
                builder.append("&&");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

