/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ClientConfig {
    private String login;
    private String password;
    private boolean restricted;
    private Set<String> allowedChannels;
    private Set<String> groups;

    public ClientConfig() {
    }

    public ClientConfig(String login, String password, boolean restricted, Set<String> allowedChannels) {
        this.login = login;
        this.password = password;
        this.restricted = restricted;
        this.allowedChannels = allowedChannels == null ? new HashSet<String>() : new HashSet<String>(allowedChannels);
        this.groups = new HashSet<String>();
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public Set<String> getAllowedChannels() {
        return this.allowedChannels;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public void setAllowedChannels(Set<String> allowedChannels) {
        this.allowedChannels = allowedChannels == null ? new HashSet<String>() : new HashSet<String>(allowedChannels);
    }

    public Set<String> getGroups() {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public boolean checkPassword(byte[] password, byte[] saltServer, byte[] saltClient) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(this.password.getBytes(StandardCharsets.UTF_8));
            digest.update(saltServer);
            digest.update(saltClient);
            byte[] encodedhash = digest.digest();
            return Arrays.equals(password, encodedhash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClientConfig)) {
            return false;
        }
        return ((ClientConfig)obj).login.equals(this.login);
    }

    public int hashCode() {
        return this.login.hashCode();
    }
}

