/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.permissions.impl;

import de.cubeside.globalserver.permissions.impl.CalculatedUserPermissions;
import java.util.HashMap;

public class PermissionUser {
    private String name;
    private HashMap<String, Boolean> directPermissions = new HashMap();
    private HashMap<String, Boolean> directEditorPermissions;
    private volatile CalculatedUserPermissions calculatedPermissions;

    public PermissionUser(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void addEditorPermission(String permission, boolean value) {
        if (this.directEditorPermissions == null) {
            this.directEditorPermissions = new HashMap<String, Boolean>(this.directPermissions);
        }
        this.directEditorPermissions.put(permission, value);
    }

    void removeEditorPermission(String permission) {
        if (this.directEditorPermissions == null) {
            this.directEditorPermissions = new HashMap<String, Boolean>(this.directPermissions);
        }
        this.directEditorPermissions.remove(permission);
    }

    void removeEditorAllPermissions(String permission) {
        if (this.directEditorPermissions == null) {
            this.directEditorPermissions = new HashMap();
        } else {
            this.directEditorPermissions.clear();
        }
    }

    void commit() {
        if (this.directEditorPermissions != null) {
            this.directPermissions = this.directEditorPermissions;
            this.directEditorPermissions = null;
        }
    }

    HashMap<String, Boolean> getDirectPermissions() {
        return this.directPermissions;
    }

    void setCalculatedPermissions(CalculatedUserPermissions calculated) {
        if (calculated != null) {
            calculated.increaseUseCounter();
        }
        if (this.calculatedPermissions != null) {
            this.calculatedPermissions.decreaseUseCounter();
        }
        this.calculatedPermissions = calculated;
    }

    public boolean hasPermission(String permission) {
        CalculatedUserPermissions local = this.calculatedPermissions;
        return local != null && local.hasPermission(permission);
    }
}

