/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import de.cubeside.globalserver.ClientConnection;
import de.cubeside.globalserver.GlobalServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerListener
extends Thread {
    protected static final Logger LOGGER = LogManager.getLogger((String)"Listener");
    private ServerSocket socket;
    private volatile boolean running;
    private GlobalServer server;

    public ServerListener(GlobalServer server, int port) throws IOException {
        this.server = server;
        LOGGER.info("Opening socket on port " + port);
        this.socket = new ServerSocket(port);
        this.running = true;
        this.setName("listener");
    }

    @Override
    public void run() {
        LOGGER.info("Listener running...");
        while (this.running) {
            try {
                Socket accepted = this.socket.accept();
                ClientConnection con = new ClientConnection(this.server, accepted);
                this.server.addPendingConnection(con);
                con.start();
            }
            catch (IOException e) {
                if (!this.running) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    LOGGER.info("Listener shutdown completed.");
                    return;
                }
                LOGGER.error("Exception in accept()", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        LOGGER.info("Initiating listener shutdown...");
        this.running = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

