/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.permissions;

import de.cubeside.globalserver.permissions.PermissionGroup;
import de.cubeside.globalserver.permissions.PermissionGroupComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CalculatedUserPermissions {
    private final HashMap<String, Boolean> directPermissions;
    private HashSet<String> directDependencies = new HashSet();
    private int useCounter;
    private HashMap<String, Boolean> resolvedPermissions;

    public CalculatedUserPermissions(HashMap<String, Boolean> directPermissions, ConcurrentHashMap<String, PermissionGroup> groups) {
        this.directPermissions = directPermissions;
        this.calculate(groups, false);
    }

    void calculate(Map<String, PermissionGroup> groups, boolean skipDirectDependencyUpdate) {
        Object dependencyName;
        PermissionGroup dependency;
        Map.Entry<String, Boolean> perm;
        if (!skipDirectDependencyUpdate) {
            this.recalculateDependencies(groups);
        }
        if (this.directPermissions.size() == 1 && this.directDependencies.size() == 1 && (perm = this.directPermissions.entrySet().iterator().next()).getValue() == Boolean.TRUE && (dependency = groups.get(dependencyName = perm.getKey())) != null) {
            this.resolvedPermissions = dependency.resolvedPermissions;
            return;
        }
        ArrayList<PermissionGroup> groupsByPriority = new ArrayList<PermissionGroup>();
        for (String dependencyName2 : this.directDependencies) {
            PermissionGroup dependency2 = groups.get(dependencyName2);
            if (dependency2 == null) continue;
            groupsByPriority.add(dependency2);
        }
        groupsByPriority.sort(PermissionGroupComparator.INSTANCE);
        HashMap<String, Boolean> resultingRermissions = new HashMap<String, Boolean>();
        HashSet<String> setByThisPriority = new HashSet<String>();
        for (int i = 0; i < groupsByPriority.size(); ++i) {
            Boolean dependencyValue;
            PermissionGroup next;
            PermissionGroup dependency3 = (PermissionGroup)groupsByPriority.get(i);
            boolean nextHasSamePriority = false;
            if (i < groupsByPriority.size() - 1 && (next = (PermissionGroup)groupsByPriority.get(i + 1)).getPriority() == dependency3.getPriority()) {
                nextHasSamePriority = true;
            }
            if ((dependencyValue = this.directPermissions.get(dependency3.getName())) == null) {
                throw new IllegalStateException("dependencyValue may not be null here");
            }
            for (Map.Entry<String, Boolean> e : dependency3.resolvedPermissions.entrySet()) {
                Boolean old;
                String permission = e.getKey();
                Boolean permissionValue = e.getValue();
                if (dependencyValue == Boolean.FALSE) {
                    Boolean bl = permissionValue = permissionValue == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE;
                }
                if ((old = resultingRermissions.put(permission, permissionValue)) != null && old != permissionValue && setByThisPriority.contains(permission)) {
                    permissionValue = Boolean.FALSE;
                    resultingRermissions.put(permission, permissionValue);
                }
                if (!nextHasSamePriority) continue;
                setByThisPriority.add(permission);
            }
            if (nextHasSamePriority) continue;
            setByThisPriority.clear();
        }
        for (Map.Entry<String, Boolean> e : this.directPermissions.entrySet()) {
            String permission = e.getKey();
            Boolean permissionValue = e.getValue();
            resultingRermissions.put(permission, permissionValue);
        }
        this.resolvedPermissions = resultingRermissions;
    }

    private void recalculateDependencies(Map<String, PermissionGroup> groups) {
        this.directDependencies.clear();
        for (String permission : this.directPermissions.keySet()) {
            if (!groups.containsKey(permission)) continue;
            this.directDependencies.add(permission);
        }
    }

    void decreaseUseCounter() {
        --this.useCounter;
    }

    void increaseUseCounter() {
        ++this.useCounter;
    }

    int getUseCounter() {
        return this.useCounter;
    }

    public boolean hasPermission(String permission) {
        return this.resolvedPermissions.get(permission) == Boolean.TRUE;
    }
}

