/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import de.cubeside.globalserver.ClientConfig;
import de.cubeside.globalserver.ClientConnection;
import de.cubeside.globalserver.Console;
import de.cubeside.globalserver.ConsoleImpl;
import de.cubeside.globalserver.JLineConsole;
import de.cubeside.globalserver.OnlinePlayer;
import de.cubeside.globalserver.ServerCommand;
import de.cubeside.globalserver.ServerConfig;
import de.cubeside.globalserver.ServerListener;
import de.cubeside.globalserver.command.AccountAddAllowedChannelCommand;
import de.cubeside.globalserver.command.AccountInfoCommand;
import de.cubeside.globalserver.command.AccountRemoveAllowedChannelCommand;
import de.cubeside.globalserver.command.AccountSetPasswordCommand;
import de.cubeside.globalserver.command.AccountSetRestrictedCommand;
import de.cubeside.globalserver.command.AccountsCommand;
import de.cubeside.globalserver.command.CreateAccountCommand;
import de.cubeside.globalserver.command.HelpCommand;
import de.cubeside.globalserver.command.ListCommand;
import de.cubeside.globalserver.command.PluginsCommand;
import de.cubeside.globalserver.command.ServersCommand;
import de.cubeside.globalserver.command.StopCommand;
import de.cubeside.globalserver.event.EventBus;
import de.cubeside.globalserver.event.clientconnection.ClientConnectionDissolveEvent;
import de.cubeside.globalserver.event.clientconnection.ClientConnectionEstablishedEvent;
import de.cubeside.globalserver.event.data.DataForwardEvent;
import de.cubeside.globalserver.event.globalserver.GlobalServerStartedEvent;
import de.cubeside.globalserver.event.globalserver.GlobalServerStoppedEvent;
import de.cubeside.globalserver.event.globalserver.GlobalServerStoppingEvent;
import de.cubeside.globalserver.event.player.PlayerJoinedEvent;
import de.cubeside.globalserver.event.player.PlayerQuitEvent;
import de.cubeside.globalserver.plugin.Plugin;
import de.cubeside.globalserver.plugin.PluginLoadException;
import de.cubeside.globalserver.plugin.PluginManager;
import de.cubeside.globalserver.plugin.PluginManagerWrapper;
import de.iani.cubesideutils.commands.ArgsParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class GlobalServer {
    public static final Logger LOGGER;
    private ServerListener listener;
    private static ConsoleImpl console;
    private boolean running;
    private File configFile = new File("config.yml");
    private Yaml configYaml;
    private ServerConfig serverConfig;
    private HashMap<String, ClientConfig> clientConfigs;
    private ArrayList<ClientConnection> pendingConnections;
    private ArrayList<ClientConnection> connections;
    private HashMap<String, ClientConnection> connectionsByAccount;
    private ConcurrentHashMap<String, ServerCommand> commands;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock shutdownLock = new ReentrantLock();
    private final Condition shutdownCondition = this.shutdownLock.newCondition();
    private final EventBus eventBus = new EventBus();
    private final PluginManagerWrapper pluginManagerWrapper;
    private final PluginManager pluginManager;
    private File pluginFolder;
    private final ExecutorService executor;

    public GlobalServer() throws PluginLoadException {
        console = new JLineConsole(this);
        LOGGER.info("Starting GlobalServer...");
        this.executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(Integer.MAX_VALUE);
        loaderOptions.setNestingDepthLimit(Integer.MAX_VALUE);
        Constructor constructor = new Constructor(ServerConfig.class, loaderOptions);
        TypeDescription serverConfigDescription = new TypeDescription(ServerConfig.class);
        serverConfigDescription.addPropertyParameters("clientConfigs", new Class[]{ClientConfig.class});
        constructor.addTypeDescription(serverConfigDescription);
        this.configYaml = new Yaml((BaseConstructor)constructor);
        if (this.configFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.configFile), Charset.forName("UTF-8")));){
                this.serverConfig = (ServerConfig)this.configYaml.loadAs((Reader)reader, ServerConfig.class);
                this.saveConfig();
            }
            catch (Exception e) {
                LOGGER.error("Could not parse config!", (Throwable)e);
            }
        }
        if (this.serverConfig == null) {
            this.serverConfig = new ServerConfig();
            LOGGER.info("Generating new config!");
            if (!this.configFile.exists()) {
                this.saveConfig();
            }
        }
        this.clientConfigs = new HashMap();
        for (ClientConfig cc : this.serverConfig.getClientConfigs()) {
            this.clientConfigs.put(cc.getLogin(), cc);
        }
        this.pendingConnections = new ArrayList();
        this.connections = new ArrayList();
        this.connectionsByAccount = new HashMap();
        this.commands = new ConcurrentHashMap();
        this.addCommand(new HelpCommand());
        this.addCommand(new StopCommand());
        this.addCommand(new ServersCommand());
        this.addCommand(new ListCommand());
        this.addCommand(new AccountsCommand());
        this.addCommand(new AccountInfoCommand());
        this.addCommand(new CreateAccountCommand());
        this.addCommand(new AccountSetPasswordCommand());
        this.addCommand(new AccountSetRestrictedCommand());
        this.addCommand(new AccountAddAllowedChannelCommand());
        this.addCommand(new AccountRemoveAllowedChannelCommand());
        this.addCommand(new PluginsCommand());
        this.addCommand("pl", new PluginsCommand());
        this.pluginFolder = new File("./plugins");
        this.pluginFolder.mkdirs();
        this.pluginManagerWrapper = new PluginManagerWrapper(this);
        this.pluginManager = this.pluginManagerWrapper.getPluginManager();
        this.pluginManagerWrapper.loadPlugins();
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            LOGGER.info("Starting plugin " + plugin.getDescription().getName() + " " + plugin.getDescription().getVersion());
            try {
                plugin.onLoad();
            }
            catch (Throwable t) {
                LOGGER.error("Exception while starting plugin " + plugin.getDescription().getName(), t);
            }
        }
    }

    public File getPluginFolder() {
        return this.pluginFolder;
    }

    public Collection<ServerCommand> getCommands() {
        return Collections.unmodifiableCollection(this.commands.values());
    }

    public Collection<String> getCommandNames() {
        return Collections.unmodifiableCollection(this.commands.keySet());
    }

    public ServerCommand getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    public void addCommand(ServerCommand command) {
        this.addCommand(command.getCommand(), command);
    }

    public void addCommand(String commandString, ServerCommand command) {
        this.commands.put(commandString.toLowerCase().trim(), command);
    }

    public void addAccount(String login, String password) {
        Objects.requireNonNull(login, "login must not be null");
        Objects.requireNonNull(password, "password must not be null");
        if (this.clientConfigs.containsKey(login)) {
            throw new IllegalArgumentException("Login name in use: " + login);
        }
        ClientConfig cfg = new ClientConfig(login, password, false, new HashSet<String>());
        this.clientConfigs.put(login, cfg);
        this.serverConfig.getClientConfigs().add(cfg);
        this.saveConfig();
    }

    public void saveConfig() {
        String output = this.configYaml.dumpAsMap((Object)this.serverConfig);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), Charset.forName("UTF-8")));){
            writer.write(output);
        }
        catch (Exception e) {
            LOGGER.error("Could not save config!", (Throwable)e);
        }
    }

    public Collection<ClientConfig> getAccounts() {
        return Collections.unmodifiableCollection(this.clientConfigs.values());
    }

    public ClientConfig getAccount(String name) {
        return this.clientConfigs.get(name);
    }

    public List<ClientConnection> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public ClientConnection getConnection(String account) {
        return this.connectionsByAccount.get(account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        this.running = true;
        int port = this.serverConfig.getPort();
        if (port <= 0) {
            port = 25701;
            this.serverConfig.setPort(port);
            this.saveConfig();
        }
        try {
            this.listener = new ServerListener(this, port);
            this.listener.start();
        }
        catch (IOException e) {
            LOGGER.error("Could not bind to " + port + ": " + e.getMessage());
            return;
        }
        this.readLock.lock();
        try {
            this.getEventBus().dispatchEvent(new GlobalServerStartedEvent(this));
        }
        finally {
            this.readLock.unlock();
        }
        while (true) {
            this.readLock.lock();
            try {
                for (ClientConnection cc : this.connections) {
                    cc.sendPing();
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.shutdownLock.lock();
            try {
                if (this.running) {
                    try {
                        this.shutdownCondition.await(20L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.running) continue;
            }
            finally {
                this.shutdownLock.unlock();
                continue;
            }
            break;
        }
        this.writeLock.lock();
        try {
            this.listener.shutdown();
            this.getEventBus().dispatchEvent(new GlobalServerStoppingEvent(this));
            for (ClientConnection cc : new ArrayList<ClientConnection>(this.pendingConnections)) {
                cc.closeConnection();
            }
            this.pendingConnections.clear();
            for (ClientConnection cc : new ArrayList<ClientConnection>(this.connections)) {
                cc.closeConnection();
            }
            this.connections.clear();
            this.connectionsByAccount.clear();
            this.getEventBus().dispatchEvent(new GlobalServerStoppedEvent(this));
            for (Plugin plugin : this.pluginManager.getPlugins()) {
                LOGGER.info("Unloading plugin " + plugin.getDescription().getName() + " " + plugin.getDescription().getVersion());
                try {
                    plugin.onUnload();
                }
                catch (Throwable t) {
                    LOGGER.error("Exception while unloading plugin " + plugin.getDescription().getName(), t);
                }
            }
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    LOGGER.info("Waiting 60 seconds for all async tasks to finish...");
                    if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                        LOGGER.warn("Not all tasks were completed before unloading!");
                    } else {
                        LOGGER.info("All tasks have finished executing!");
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.pluginManagerWrapper.shutdown();
            console.stop();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static void main(String[] args) {
        try {
            new GlobalServer().run();
        }
        catch (PluginLoadException e) {
            LOGGER.error("Could not load plugins", (Throwable)e);
        }
        LogManager.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCommand(String line) {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        int firstSpace = line.indexOf(32);
        String cmd = (firstSpace < 0 ? line : line.substring(0, firstSpace)).toLowerCase().trim();
        String args = firstSpace < 0 ? "" : line.substring(firstSpace + 1);
        ServerCommand command = this.commands.get(cmd);
        if (command != null) {
            ArrayList<String> splitArgs = new ArrayList<String>();
            for (String s : args.trim().split(" ++")) {
                String s2 = s.trim();
                if (s2.length() <= 0) continue;
                splitArgs.add(s2);
            }
            this.readLock.lock();
            try {
                command.execute(this, new ArgsParser(splitArgs.toArray(new String[splitArgs.size()])));
            }
            catch (Throwable t) {
                LOGGER.error("Could not execute command " + line, t);
            }
            finally {
                this.readLock.unlock();
            }
        } else {
            LOGGER.info("Unknown command: " + cmd);
        }
    }

    public void stopServer() {
        this.shutdownLock.lock();
        try {
            this.running = false;
            this.shutdownCondition.signal();
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    void addPendingConnection(ClientConnection connection) {
        this.writeLock.lock();
        try {
            this.pendingConnections.add(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ClientConnection connection) {
        this.writeLock.lock();
        try {
            boolean wasOnline = this.connections.remove(connection);
            this.pendingConnections.remove(connection);
            if (wasOnline) {
                this.connectionsByAccount.remove(connection.getAccount());
                for (ClientConnection cc : this.connections) {
                    if (cc == connection) continue;
                    cc.sendServerOffline(connection.getAccount());
                }
                for (OnlinePlayer player : connection.getPlayers()) {
                    this.getEventBus().dispatchEvent(new PlayerQuitEvent(connection, player));
                }
                this.getEventBus().dispatchEvent(new ClientConnectionDissolveEvent(connection));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConfig processLogin(ClientConnection connection, String account, byte[] password, byte[] saltServer, byte[] saltClient) throws IOException {
        this.writeLock.lock();
        try {
            ClientConfig config = this.clientConfigs.get(account);
            if (config == null || !config.checkPassword(password, saltServer, saltClient)) {
                LOGGER.info("Login failed for '" + account + "'.");
                this.pendingConnections.remove(connection);
                connection.sendLoginResultAndActivateEncryption(false, null);
                ClientConfig clientConfig = null;
                return clientConfig;
            }
            LOGGER.info("Login successfull for '" + account + "'.");
            for (ClientConnection cc : this.connections) {
                if (!cc.getAccount().equals(account)) continue;
                cc.closeConnection();
                this.removeConnection(cc);
                break;
            }
            connection.setClient(config);
            this.pendingConnections.remove(connection);
            this.connections.add(connection);
            this.connectionsByAccount.put(connection.getAccount(), connection);
            connection.sendLoginResultAndActivateEncryption(true, config);
            for (ClientConnection cc : this.connections) {
                if (cc == connection) continue;
                cc.sendServerOnline(account);
                connection.sendServerOnline(cc.getAccount());
                Collection<OnlinePlayer> players = cc.getPlayers();
                for (OnlinePlayer e : players) {
                    connection.sendPlayerOnline(cc.getAccount(), e.getUuid(), e.getName(), e.getJoinTime());
                }
            }
            this.getEventBus().dispatchEvent(new ClientConnectionEstablishedEvent(connection));
            ClientConfig clientConfig = config;
            return clientConfig;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPlayerOnline(ClientConnection connection, UUID uuid, String name, long joinTime) {
        this.writeLock.lock();
        try {
            OnlinePlayer joined = connection.addPlayer(uuid, name, joinTime);
            if (joined != null) {
                for (ClientConnection cc : this.connections) {
                    if (cc == connection) continue;
                    cc.sendPlayerOnline(connection.getAccount(), uuid, name, joinTime);
                }
                this.getEventBus().dispatchEvent(new PlayerJoinedEvent(connection, joined));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPlayerOffline(ClientConnection connection, UUID uuid) {
        this.writeLock.lock();
        try {
            OnlinePlayer player = connection.removePlayer(uuid);
            if (player != null) {
                for (ClientConnection cc : this.connections) {
                    if (cc == connection) continue;
                    cc.sendPlayerOffline(connection.getAccount(), uuid);
                }
                this.getEventBus().dispatchEvent(new PlayerQuitEvent(connection, player));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processData(ClientConnection connection, String channel, UUID targetUuid, String targetServer, byte[] data, boolean allowRestricted, boolean toAllUnrestrictedServers) {
        this.readLock.lock();
        try {
            HashSet<ClientConnection> targets = new HashSet<ClientConnection>();
            ClientConnection targetServerConnection = targetServer == null ? null : this.connectionsByAccount.get(targetServer);
            boolean fromRestricted = connection.getClient().isRestricted();
            if (!fromRestricted || connection.getClient().getAllowedChannels().contains(channel)) {
                for (ClientConnection cc : this.connections) {
                    boolean explicitPlayer;
                    boolean explicitServer;
                    boolean toRestricted;
                    if (cc == connection || (toRestricted = cc.getClient().isRestricted()) && !cc.getClient().getAllowedChannels().contains(channel)) continue;
                    boolean bl = explicitServer = cc == targetServerConnection;
                    if (targetServer != null && !explicitServer) continue;
                    boolean bl2 = explicitPlayer = targetUuid != null && cc.hasPlayer(targetUuid);
                    if (!toAllUnrestrictedServers && targetUuid != null && !explicitPlayer || !allowRestricted && (fromRestricted || toRestricted) && !explicitServer && !explicitPlayer) continue;
                    targets.add(cc);
                }
            }
            DataForwardEvent event = new DataForwardEvent(connection, targets, channel, targetUuid, targetServerConnection, data, allowRestricted, toAllUnrestrictedServers);
            this.getEventBus().dispatchEvent(event);
            if (!event.isCancelled()) {
                channel = event.getChannel();
                targetUuid = event.getTargetUuid();
                targetServerConnection = event.getTargetServer();
                data = event.getData();
                for (ClientConnection target : event.getTargets()) {
                    target.sendData(connection, channel, targetUuid, targetServerConnection, data);
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void runWithReadLock(Runnable r) {
        this.readLock.lock();
        try {
            r.run();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static Console getConsole() {
        return console;
    }

    Lock getReadLock() {
        return this.readLock;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    static {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        PrintStream logger = IoBuilder.forLogger((String)"System.out").setLevel(Level.INFO).buildPrintStream();
        PrintStream errorLogger = IoBuilder.forLogger((String)"System.err").setLevel(Level.ERROR).buildPrintStream();
        System.setOut(logger);
        System.setErr(errorLogger);
        LOGGER = LogManager.getLogger((String)"Server");
    }
}

