/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import de.cubeside.globalserver.ConsoleImpl;
import de.cubeside.globalserver.GlobalServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleConsole
implements ConsoleImpl {
    private static final Logger logger = LogManager.getLogger((String)"Console");
    private GlobalServer server;
    private SimpleConsoleReaderThread thread;
    private volatile boolean running;

    public SimpleConsole(GlobalServer server) {
        this.server = server;
        this.running = true;
        this.thread = new SimpleConsoleReaderThread();
        this.thread.setName("console");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void appendOutput(String message) {
        System.out.println(message);
    }

    private class SimpleConsoleReaderThread
    extends Thread {
        private SimpleConsoleReaderThread() {
        }

        @Override
        public void run() {
            logger.log(Level.INFO, "Starting console...");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (SimpleConsole.this.running) {
                try {
                    String line = reader.readLine();
                    SimpleConsole.this.server.processCommand(line == null ? "stop" : line);
                }
                catch (IOException e) {
                    logger.log(Level.ERROR, "Error reding from console", (Throwable)e);
                }
            }
            logger.log(Level.INFO, "Console shutdown completed.");
        }
    }
}

