/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.GlobalClient;
import de.cubeside.connection.GlobalPlayer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;

public class GlobalServer {
    private final GlobalClient client;
    private final String name;
    private final HashMap<UUID, GlobalPlayer> players;
    private final Collection<GlobalPlayer> unmodifiablePlayers;

    public GlobalServer(GlobalClient client, String name) {
        this.client = client;
        this.name = name;
        this.players = new HashMap();
        this.unmodifiablePlayers = Collections.unmodifiableCollection(this.players.values());
    }

    public String getName() {
        return this.name;
    }

    public Collection<GlobalPlayer> getPlayers() {
        return this.unmodifiablePlayers;
    }

    public void sendData(String channel, byte[] data) {
        this.client.sendData(channel, null, this.name, data, false, false);
    }

    protected void addPlayer(GlobalPlayer player) {
        this.players.put(player.getUniqueId(), player);
    }

    protected void removePlayer(UUID player) {
        this.players.remove(player);
    }

    public String toString() {
        return "GlobalServer{name=" + this.name + "}";
    }
}

