/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import com.google.common.base.Preconditions;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.PlayerPropertiesAPI;
import de.cubeside.connection.event.GlobalDataEvent;
import de.cubeside.connection.event.GlobalPlayerDisconnectedEvent;
import de.cubeside.connection.event.GlobalPlayerPropertyChangedEvent;
import de.cubeside.connection.event.GlobalServerConnectedEvent;
import de.cubeside.connection.util.AutoCloseableLockWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class PlayerPropertiesImplementation
implements PlayerPropertiesAPI,
Listener {
    private static final int MESSAGE_SET_PROPERTY = 1;
    private static final int MESSAGE_DELETE_PROPERTY = 2;
    private static final int MESSAGE_MULTISET_PROPERTIES = 3;
    private final GlobalClientPlugin plugin;
    private static final String CHANNEL = "GlobalClient.playerProperties";
    private final HashMap<UUID, HashMap<String, String>> playerProperties;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final AutoCloseableLockWrapper readLock = new AutoCloseableLockWrapper(this.lock.readLock());
    private final AutoCloseableLockWrapper writeLock = new AutoCloseableLockWrapper(this.lock.writeLock());

    public PlayerPropertiesImplementation(GlobalClientPlugin plugin) {
        this.plugin = plugin;
        this.playerProperties = new HashMap();
        plugin.getProxy().getPluginManager().registerListener((Plugin)plugin, (Listener)this);
    }

    @EventHandler
    public void onGlobalPlayerDisconnected(GlobalPlayerDisconnectedEvent e) {
        if (e.hasJustLeftTheNetwork()) {
            try (AutoCloseableLockWrapper lock = this.writeLock.open();){
                this.playerProperties.remove(e.getPlayer().getUniqueId());
            }
        }
    }

    @EventHandler
    public void onGlobalServerConnected(GlobalServerConnectedEvent e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(3);
            for (ProxiedPlayer p : this.plugin.getProxy().getPlayers()) {
                UUID uuid = p.getUniqueId();
                AutoCloseableLockWrapper lock = this.readLock.open();
                try {
                    HashMap<String, String> properties = this.playerProperties.get(uuid);
                    if (properties == null) continue;
                    dos.writeBoolean(true);
                    dos.writeLong(uuid.getMostSignificantBits());
                    dos.writeLong(uuid.getLeastSignificantBits());
                    dos.writeInt(properties.size());
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        dos.writeUTF(entry.getKey());
                        dos.writeUTF(entry.getValue());
                    }
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
            dos.writeBoolean(false);
            dos.close();
        }
        catch (IOException ex) {
            throw new Error("impossible");
        }
        e.getServer().sendData(CHANNEL, baos.toByteArray());
    }

    @EventHandler
    public void onGlobalData(GlobalDataEvent e) {
        block30: {
            if (e.getChannel().equals(CHANNEL)) {
                DataInputStream dis = new DataInputStream(e.getData());
                try {
                    byte type = dis.readByte();
                    if (type == 1) {
                        UUID uuid = this.readUUID(dis);
                        GlobalPlayer target = this.plugin.getConnectionAPI().getPlayer(uuid);
                        String property = dis.readUTF();
                        String value = dis.readUTF();
                        try (AutoCloseableLockWrapper lock = this.writeLock.open();){
                            HashMap properties = this.playerProperties.computeIfAbsent(uuid, theUuid -> new HashMap());
                            properties.put(property, value);
                        }
                        this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalPlayerPropertyChangedEvent(e.getSource(), target, property, value));
                        break block30;
                    }
                    if (type == 2) {
                        UUID uuid = this.readUUID(dis);
                        GlobalPlayer target = this.plugin.getConnectionAPI().getPlayer(uuid);
                        String property = dis.readUTF();
                        boolean event = false;
                        try (AutoCloseableLockWrapper lock = this.writeLock.open();){
                            HashMap<String, String> properties = this.playerProperties.get(uuid);
                            if (properties != null) {
                                properties.remove(property);
                                if (properties.isEmpty()) {
                                    this.playerProperties.remove(uuid);
                                }
                                event = true;
                            }
                        }
                        if (event) {
                            this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalPlayerPropertyChangedEvent(e.getSource(), target, property, null));
                        }
                        break block30;
                    }
                    if (type != 3) break block30;
                    while (dis.readBoolean()) {
                        UUID uuid = this.readUUID(dis);
                        GlobalPlayer target = this.plugin.getConnectionAPI().getPlayer(uuid);
                        int propertiesCount = dis.readInt();
                        if (propertiesCount <= 0) continue;
                        ArrayList<GlobalPlayerPropertyChangedEvent> events = new ArrayList<GlobalPlayerPropertyChangedEvent>();
                        try (AutoCloseableLockWrapper lock = this.writeLock.open();){
                            HashMap properties = this.playerProperties.computeIfAbsent(uuid, theUuid -> new HashMap());
                            for (int i = 0; i < propertiesCount; ++i) {
                                String property = dis.readUTF();
                                String value = dis.readUTF();
                                properties.put(property, value);
                                events.add(new GlobalPlayerPropertyChangedEvent(e.getSource(), target, property, null));
                            }
                        }
                        for (GlobalPlayerPropertyChangedEvent event : events) {
                            this.plugin.getProxy().getPluginManager().callEvent((Event)event);
                        }
                    }
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not parse PlayerProperties message", ex);
                }
            }
        }
    }

    private UUID readUUID(DataInputStream dis) throws IOException {
        long msb = dis.readLong();
        long lsb = dis.readLong();
        return new UUID(msb, lsb);
    }

    @Override
    public boolean hasProperty(GlobalPlayer player, String property) {
        try (AutoCloseableLockWrapper lock = this.readLock.open();){
            Preconditions.checkNotNull((Object)player, (Object)"player");
            Preconditions.checkNotNull((Object)property, (Object)"property");
            HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
            boolean bl = properties != null && properties.containsKey(property);
            return bl;
        }
    }

    @Override
    public String getPropertyValue(GlobalPlayer player, String property) {
        try (AutoCloseableLockWrapper lock = this.readLock.open();){
            Preconditions.checkNotNull((Object)player, (Object)"player");
            Preconditions.checkNotNull((Object)property, (Object)"property");
            HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
            String string = properties == null ? null : properties.get(property);
            return string;
        }
    }

    @Override
    public Map<String, String> getAllProperties(GlobalPlayer player) {
        try (AutoCloseableLockWrapper lock = this.readLock.open();){
            Preconditions.checkNotNull((Object)player, (Object)"player");
            HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
            HashMap<String, String> hashMap = properties == null ? Collections.emptyMap() : new HashMap<String, String>(properties);
            return hashMap;
        }
    }

    @Override
    public void setPropertyValue(GlobalPlayer player, String property, String value) {
        block40: {
            Preconditions.checkNotNull((Object)player, (Object)"player");
            Preconditions.checkNotNull((Object)property, (Object)"property");
            Preconditions.checkArgument((boolean)player.isOnAnyServer(), (Object)"player is not online");
            if (value == null) {
                try (AutoCloseableLockWrapper lock = this.writeLock.open();){
                    HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
                    if (properties != null && properties.remove(property) != null && properties.isEmpty()) {
                        this.playerProperties.remove(player.getUniqueId());
                    }
                }
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     DataOutputStream dos = new DataOutputStream(baos);){
                    dos.writeByte(2);
                    dos.writeLong(player.getUniqueId().getMostSignificantBits());
                    dos.writeLong(player.getUniqueId().getLeastSignificantBits());
                    dos.writeUTF(property);
                    dos.close();
                    this.plugin.getConnectionAPI().sendData(CHANNEL, baos.toByteArray(), true);
                    break block40;
                }
                catch (IOException ex) {
                    throw new Error("impossible");
                }
            }
            try (AutoCloseableLockWrapper lock = this.writeLock.open();){
                HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
                if (properties == null) {
                    properties = new HashMap();
                    this.playerProperties.put(player.getUniqueId(), properties);
                }
                properties.put(property, value);
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputStream dos = new DataOutputStream(baos);){
                dos.writeByte(1);
                dos.writeLong(player.getUniqueId().getMostSignificantBits());
                dos.writeLong(player.getUniqueId().getLeastSignificantBits());
                dos.writeUTF(property);
                dos.writeUTF(value);
                dos.close();
                this.plugin.getConnectionAPI().sendData(CHANNEL, baos.toByteArray(), true);
            }
            catch (IOException ex) {
                throw new Error("impossible");
            }
        }
        this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalPlayerPropertyChangedEvent(this.plugin.getConnectionAPI().getThisServer(), player, property, value));
    }
}

