/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.GlobalClient;
import de.cubeside.connection.GlobalPlayerOnServer;
import de.cubeside.connection.GlobalServer;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class GlobalPlayer {
    private final GlobalClient client;
    private final UUID uuid;
    private final String name;
    private final HashSet<GlobalPlayerOnServer> servers;
    private GlobalPlayerOnServer lastJoined;

    public GlobalPlayer(GlobalClient client, UUID uuid, String name, GlobalServer server, long joinTime) {
        this.client = client;
        this.uuid = uuid;
        this.name = name;
        this.servers = new HashSet();
        this.lastJoined = new GlobalPlayerOnServer(this, server, joinTime);
        this.servers.add(this.lastJoined);
    }

    public GlobalServer getCurrentServer() {
        return this.lastJoined == null ? null : this.lastJoined.getServer();
    }

    public List<GlobalServer> getCurrentServers() {
        return this.servers.stream().map(s -> s.getServer()).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public void sendData(String channel, byte[] data) {
        this.sendData(channel, data, false, false);
    }

    public void sendData(String channel, byte[] data, boolean sendToUnrestricted, boolean sendToRestricted) {
        this.client.sendData(channel, this.uuid, null, data, sendToUnrestricted, sendToRestricted);
    }

    public boolean isOnAnyServer() {
        return !this.servers.isEmpty();
    }

    public boolean isOnServer(GlobalServer server) {
        for (GlobalPlayerOnServer pos : this.servers) {
            if (pos.getServer() != server) continue;
            return true;
        }
        return false;
    }

    protected void addServer(GlobalServer server, long joinTime) {
        GlobalPlayerOnServer pos = new GlobalPlayerOnServer(this, server, joinTime);
        this.servers.add(pos);
        if (this.lastJoined == null || this.lastJoined.getJoinTime() < joinTime) {
            this.lastJoined = pos;
        }
    }

    protected void removeServer(GlobalServer server) {
        for (GlobalPlayerOnServer pos : this.servers) {
            if (pos.getServer() != server) continue;
            this.servers.remove(pos);
            if (this.lastJoined != pos) break;
            this.lastJoined = null;
            for (GlobalPlayerOnServer pos2 : this.servers) {
                if (this.lastJoined != null && this.lastJoined.getJoinTime() >= pos2.getJoinTime()) continue;
                this.lastJoined = pos2;
            }
        }
    }

    public long getJoinTime(GlobalServer s) {
        for (GlobalPlayerOnServer onServer : this.servers) {
            if (onServer.getServer() != s) continue;
            return onServer.getJoinTime();
        }
        return -1L;
    }

    public String toString() {
        return "GlobalPlayer{uuid=" + this.uuid + ";name=" + this.name + "}";
    }
}

