/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientBukkit;
import de.cubeside.connection.PlayerMessageAPI;
import de.cubeside.connection.PlayerMessageImplementation;
import de.cubeside.connection.util.GlobalLocation;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class GlobalClientPlugin
extends JavaPlugin {
    private GlobalClientBukkit globalClient;
    private PlayerMessageAPI messageAPI;

    public void onEnable() {
        this.saveDefaultConfig();
        ConfigurationSerialization.registerClass(GlobalLocation.class);
        this.globalClient = new GlobalClientBukkit(this);
        this.reconnectClient();
        this.messageAPI = new PlayerMessageImplementation(this);
        this.getServer().getServicesManager().register(ConnectionAPI.class, (Object)this.globalClient, (Plugin)this, ServicePriority.Normal);
        this.getServer().getServicesManager().register(PlayerMessageAPI.class, (Object)this.messageAPI, (Plugin)this, ServicePriority.Normal);
    }

    public void onDisable() {
        if (this.globalClient != null) {
            this.globalClient.shutdown();
        }
        this.globalClient = null;
        this.messageAPI = null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("globalclient.reload")) {
            return false;
        }
        this.reloadConfig();
        this.reconnectClient();
        return true;
    }

    public void reconnectClient() {
        String account = this.getConfig().getString("client.account");
        String password = this.getConfig().getString("client.password");
        String host = this.getConfig().getString("server.host");
        int port = this.getConfig().getInt("server.port");
        this.globalClient.setServer(host, port, account, password);
    }

    public ConnectionAPI getConnectionAPI() {
        return this.globalClient;
    }

    public PlayerMessageAPI getMessageAPI() {
        return this.messageAPI;
    }
}

