/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientBukkit;
import de.cubeside.connection.PlayerMessageAPI;
import de.cubeside.connection.PlayerMessageImplementation;
import de.cubeside.connection.PlayerPropertiesAPI;
import de.cubeside.connection.PlayerPropertiesImplementation;
import de.cubeside.connection.util.GlobalLocation;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class GlobalClientPlugin
extends JavaPlugin {
    private GlobalClientBukkit globalClient;
    private PlayerMessageAPI messageAPI;
    private PlayerPropertiesAPI propertiesAPI;

    public void onEnable() {
        this.saveDefaultConfig();
        ConfigurationSerialization.registerClass(GlobalLocation.class);
        this.globalClient = new GlobalClientBukkit(this);
        this.reconnectClient();
        this.getServer().getServicesManager().register(ConnectionAPI.class, (Object)this.globalClient, (Plugin)this, ServicePriority.Normal);
        this.messageAPI = new PlayerMessageImplementation(this);
        this.getServer().getServicesManager().register(PlayerMessageAPI.class, (Object)this.messageAPI, (Plugin)this, ServicePriority.Normal);
        this.propertiesAPI = new PlayerPropertiesImplementation(this);
        this.getServer().getServicesManager().register(PlayerPropertiesAPI.class, (Object)this.propertiesAPI, (Plugin)this, ServicePriority.Normal);
    }

    public void onDisable() {
        if (this.globalClient != null) {
            this.globalClient.shutdown();
        }
        this.globalClient = null;
        this.messageAPI = null;
        this.propertiesAPI = null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("globalclient.reload")) {
            return false;
        }
        this.reloadConfig();
        this.reconnectClient();
        return true;
    }

    public void reconnectClient() {
        boolean connect;
        String account = this.getConfig().getString("client.account");
        String password = this.getConfig().getString("client.password");
        String host = this.getConfig().getString("server.host");
        int port = this.getConfig().getInt("server.port");
        if (!this.getConfig().isSet("server.connect")) {
            this.getConfig().set("server.connect", (Object)true);
            this.saveConfig();
        }
        if (!(connect = this.getConfig().getBoolean("server.connect"))) {
            this.getLogger().warning("Not connecting to a server, because connecting is disabled in the config!");
        }
        this.globalClient.setServer(connect ? host : null, port, account, password);
    }

    public ConnectionAPI getConnectionAPI() {
        return this.globalClient;
    }

    public PlayerMessageAPI getMessageAPI() {
        return this.messageAPI;
    }

    public PlayerPropertiesAPI getPlayerPropertiesAPI() {
        return this.propertiesAPI;
    }
}

